/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCWithXAdESService
extends AbstractASiCSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithXAdESService.class);

    public ASiCWithXAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with XAdES created");
    }

    @Override
    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        GetDataToSignASiCWithXAdESHelper getDataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        return this.getXAdESService().getContentTimestamp(getDataToSignHelper.getSignedDocuments(), (XAdESSignatureParameters)parameters);
    }

    @Override
    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        if (Utils.isCollectionEmpty(toSignDocuments)) {
            throw new DSSException("List of documents to sign cannot be empty!");
        }
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        XAdESSignatureParameters xadesParameters = this.getParameters(parameters, dataToSignHelper);
        return this.getXAdESService().getDataToSign(dataToSignHelper.getSignedDocuments(), xadesParameters);
    }

    @Override
    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        if (Utils.isCollectionEmpty(toSignDocuments)) {
            throw new DSSException("List of documents to sign cannot be empty!");
        }
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertSigningDateInCertificateValidityRange(parameters);
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = ASiCWithXAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        List<DSSDocument> signatures = dataToSignHelper.getSignatures();
        List<DSSDocument> manifestFiles = dataToSignHelper.getManifestFiles();
        List<DSSDocument> signedDocuments = dataToSignHelper.getSignedDocuments();
        DSSDocument rootContainer = dataToSignHelper.getRootDocument();
        XAdESSignatureParameters xadesParameters = this.getParameters(parameters, dataToSignHelper);
        DSSDocument newSignature = this.getXAdESService().signDocument(signedDocuments, xadesParameters, signatureValue);
        String newSignatureFilename = dataToSignHelper.getSignatureFilename();
        newSignature.setName(newSignatureFilename);
        if (ASiCUtils.isASiCS(asicParameters) || rootContainer != null) {
            Iterator<DSSDocument> iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual(newSignatureFilename, iterator.next().getName())) continue;
                iterator.remove();
            }
        }
        signatures.add(newSignature);
        DSSDocument asicSignature = this.buildASiCContainer(signedDocuments, signatures, manifestFiles, asicParameters, rootContainer);
        asicSignature.setName(this.getFinalArchiveName(asicSignature, SigningOperation.SIGN, parameters.getSignatureLevel(), asicSignature.getMimeType()));
        parameters.reinitDeterministicId();
        return asicSignature;
    }

    @Override
    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, XAdESTimestampParameters parameters) {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-S/E + XAdES");
    }

    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithXAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        if (!ASiCUtils.isZip(toExtendDocument) || !ASiCUtils.isArchiveContainsCorrectSignatureFileWithExtension(toExtendDocument, ".xml")) {
            throw new DSSException("Unsupported file type");
        }
        this.extractCurrentArchive(toExtendDocument);
        List<DSSDocument> signatureDocuments = this.getEmbeddedSignatures();
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        boolean openDocument = ASiCUtils.isOpenDocument(this.getEmbeddedMimetype());
        for (DSSDocument signature : signatureDocuments) {
            XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, null, openDocument);
            if (openDocument) {
                xadesParameters.setDetachedContents(OpenDocumentSupportUtils.getOpenDocumentCoverage(this.archiveContent));
            } else {
                xadesParameters.setDetachedContents(this.getEmbeddedSignedDocuments());
            }
            DSSDocument extendDocument = this.getXAdESService().extendDocument(signature, xadesParameters);
            extendDocument.setName(signature.getName());
            extendedDocuments.add(extendDocument);
        }
        DSSDocument extensionResult = this.mergeArchiveAndExtendedSignatures(toExtendDocument, extendedDocuments);
        extensionResult.setName(this.getFinalArchiveName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), toExtendDocument.getMimeType()));
        return extensionResult;
    }

    @Override
    protected boolean isSignatureFilename(String name) {
        return ASiCUtils.isXAdES(name);
    }

    private XAdESService getXAdESService() {
        XAdESService xadesService = new XAdESService(this.certificateVerifier);
        xadesService.setTspSource(this.tspSource);
        return xadesService;
    }

    private XAdESSignatureParameters getParameters(ASiCWithXAdESSignatureParameters parameters, GetDataToSignASiCWithXAdESHelper dataToSignHelper) {
        boolean openDocument = dataToSignHelper.getRootDocument() != null;
        return this.getXAdESParameters(parameters, dataToSignHelper.getExistingSignature(), openDocument);
    }

    private XAdESSignatureParameters getXAdESParameters(ASiCWithXAdESSignatureParameters parameters, DSSDocument existingXAdESSignature, boolean openDocument) {
        ASiCWithXAdESSignatureParameters xadesParameters = parameters;
        xadesParameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        Document rootDocument = null;
        rootDocument = existingXAdESSignature != null ? DomUtils.buildDOM(existingXAdESSignature) : this.buildDomRoot(openDocument);
        xadesParameters.setRootDocument(rootDocument);
        return xadesParameters;
    }

    private Document buildDomRoot(boolean openDocument) {
        Document rootDocument = DomUtils.buildDOM();
        Element xadesSignatures = null;
        xadesSignatures = openDocument ? rootDocument.createElementNS("urn:oasis:names:tc:opendocument:xmlns:digitalsignature:1.0", "document-signatures") : DomUtils.createElementNS(rootDocument, ASiCNamespace.NS, ASiCElement.XADES_SIGNATURES);
        rootDocument.appendChild(xadesSignatures);
        return rootDocument;
    }

    @Override
    protected AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithXAdESContainerExtractor(archive);
    }

    @Override
    protected String getExpectedSignatureExtension() {
        return ".xml";
    }

    static {
        DomUtils.registerNamespace(ASiCNamespace.NS);
        DomUtils.registerNamespace(ManifestNamespace.NS);
    }
}

