/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignedAssertion;
import eu.europa.esig.dss.cades.SignedAssertions;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.cades.validation.CAdESCRLSource;
import eu.europa.esig.dss.cades.validation.CAdESCertificateSource;
import eu.europa.esig.dss.cades.validation.CAdESOCSPSource;
import eu.europa.esig.dss.cades.validation.CAdESSignatureIdentifier;
import eu.europa.esig.dss.cades.validation.CAdESTimestampSource;
import eu.europa.esig.dss.cades.validation.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificateIdentifier;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.bouncycastle.asn1.x509.RoleSyntax;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignature
extends DefaultAdvancedSignature {
    private static final long serialVersionUID = 8449504364217200965L;
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignature.class);
    private static final Date JANUARY_1950 = DSSUtils.getUtcDate(1950, 0, 1);
    private static final Date JANUARY_2050 = DSSUtils.getUtcDate(2050, 0, 1);
    private final CMSSignedData cmsSignedData;
    private final SignerInformation signerInformation;

    public CAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation) {
        Objects.requireNonNull(cmsSignedData, "CMSSignedData cannot be null!");
        Objects.requireNonNull(signerInformation, "SignerInformation must be provided!");
        this.cmsSignedData = cmsSignedData;
        this.signerInformation = signerInformation;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.CAdES;
    }

    @Override
    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new CAdESCertificateSource(this.cmsSignedData, this.signerInformation);
        }
        return this.offlineCertificateSource;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            try {
                this.signatureCRLSource = new CAdESCRLSource(this.cmsSignedData, this.signerInformation.getUnsignedAttributes());
            }
            catch (Exception e) {
                LOG.warn("Error in computing or in format of the algorithm: just continue...", e);
            }
        }
        return this.signatureCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new CAdESOCSPSource(this.cmsSignedData, this.signerInformation.getUnsignedAttributes());
        }
        return this.signatureOCSPSource;
    }

    @Override
    public CAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new CAdESTimestampSource(this);
        }
        return (CAdESTimestampSource)this.signatureTimestampSource;
    }

    public SignerId getSignerId() {
        return this.signerInformation.getSID();
    }

    @Override
    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyProvider) {
        SigPolicyQualifiers sigPolicyQualifiers;
        Attribute attribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId);
        if (attribute == null) {
            return;
        }
        ASN1Encodable attrValue = attribute.getAttrValues().getObjectAt(0);
        if (attrValue instanceof DERNull) {
            this.signaturePolicy = new SignaturePolicy();
            return;
        }
        SignaturePolicyId sigPolicy = SignaturePolicyId.getInstance(attrValue);
        if (sigPolicy == null) {
            return;
        }
        String policyId = sigPolicy.getSigPolicyId().getId();
        this.signaturePolicy = new SignaturePolicy(policyId);
        OtherHashAlgAndValue hashAlgAndValue = sigPolicy.getSigPolicyHash();
        ASN1OctetString digestValue = hashAlgAndValue.getHashValue();
        byte[] digestValueBytes = digestValue.getOctets();
        boolean zeroHash = this.isZeroHash(digestValueBytes);
        this.signaturePolicy.setZeroHash(zeroHash);
        if (!zeroHash) {
            AlgorithmIdentifier digestAlgorithmIdentifier = hashAlgAndValue.getHashAlgorithm();
            String digestAlgorithmOID = digestAlgorithmIdentifier.getAlgorithm().getId();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(digestAlgorithmOID);
            this.signaturePolicy.setDigest(new Digest(digestAlgorithm, digestValueBytes));
        }
        if ((sigPolicyQualifiers = sigPolicy.getSigPolicyQualifiers()) == null) {
            this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicyById(policyId));
        } else {
            for (int ii = 0; ii < sigPolicyQualifiers.size(); ++ii) {
                try {
                    SigPolicyQualifierInfo policyQualifierInfo = sigPolicyQualifiers.getInfoAt(ii);
                    ASN1ObjectIdentifier policyQualifierInfoId = policyQualifierInfo.getSigPolicyQualifierId();
                    String policyQualifierInfoValue = policyQualifierInfo.getSigQualifier().toString();
                    if (PKCSObjectIdentifiers.id_spq_ets_unotice.equals(policyQualifierInfoId)) {
                        this.signaturePolicy.setNotice(policyQualifierInfoValue);
                        continue;
                    }
                    if (PKCSObjectIdentifiers.id_spq_ets_uri.equals(policyQualifierInfoId)) {
                        this.signaturePolicy.setUrl(policyQualifierInfoValue);
                        this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicyByUrl(policyQualifierInfoValue));
                        continue;
                    }
                    LOG.error("Unknown signature policy qualifier id: {} with value: {}", (Object)policyQualifierInfoId, (Object)policyQualifierInfoValue);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Unable to read SigPolicyQualifierInfo {} : {}", (Object)ii, (Object)e.getMessage());
                }
            }
            if (this.signaturePolicy.getPolicyContent() != null) {
                signaturePolicyProvider.getSignaturePoliciesById().put(policyId, this.signaturePolicy.getPolicyContent());
            }
        }
    }

    private boolean isZeroHash(byte[] hashValue) {
        return this.isZeroHashEmpty(hashValue) || this.doesZeroHashContainSigneZeroByte(hashValue);
    }

    private boolean isZeroHashEmpty(byte[] hashValue) {
        return hashValue != null && hashValue.length == 0;
    }

    private boolean doesZeroHashContainSigneZeroByte(byte[] hashValue) {
        return hashValue != null && hashValue.length == 1 && (hashValue[0] == 48 || hashValue[0] == 0);
    }

    @Override
    public Date getSigningTime() {
        Attribute attr = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        if (attr == null) {
            return null;
        }
        ASN1Set attrValues = attr.getAttrValues();
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        Date signingDate = DSSASN1Utils.getDate(attrValue);
        if (signingDate != null) {
            if (signingDate.compareTo(JANUARY_1950) >= 0 && signingDate.before(JANUARY_2050) && !(attrValue instanceof ASN1UTCTime)) {
                LOG.error("RFC 3852 states that dates between January 1, 1950 and December 31, 2049 (inclusive) must be encoded as UTCTime. Any dates with year values before 1950 or after 2049 must be encoded as GeneralizedTime. Date found is {} encoded as {}", (Object)signingDate, (Object)attrValue.getClass());
                return null;
            }
            return signingDate;
        }
        if (LOG.isErrorEnabled()) {
            LOG.error("Error when reading signing time. Unrecognized {}", (Object)attrValue.getClass());
        }
        return null;
    }

    public CMSSignedData getCmsSignedData() {
        return this.cmsSignedData;
    }

    @Override
    public SignatureProductionPlace getSignatureProductionPlace() {
        DirectoryString localityName;
        Attribute signatureProductionPlaceAttr = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation);
        if (signatureProductionPlaceAttr == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = signatureProductionPlaceAttr.getAttrValues().getObjectAt(0);
        SignerLocation signerLocation = null;
        try {
            signerLocation = SignerLocation.getInstance(asn1Encodable);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        if (signerLocation == null) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        DirectoryString countryName = signerLocation.getCountry();
        if (countryName != null) {
            signatureProductionPlace.setCountryName(countryName.getString());
        }
        if ((localityName = signerLocation.getLocality()) != null) {
            signatureProductionPlace.setCity(localityName.getString());
        }
        StringBuilder address = new StringBuilder();
        ASN1Sequence seq = signerLocation.getPostalAddress();
        if (seq != null) {
            for (int ii = 0; ii < seq.size(); ++ii) {
                if (seq.getObjectAt(ii) instanceof DEROctetString) {
                    if (address.length() > 0) {
                        address.append(" / ");
                    }
                    address.append(new String(((DEROctetString)seq.getObjectAt(ii)).getOctets()));
                    continue;
                }
                if (!(seq.getObjectAt(ii) instanceof DERUTF8String)) continue;
                if (address.length() > 0) {
                    address.append(" / ");
                }
                DERUTF8String derutf8String = (DERUTF8String)seq.getObjectAt(ii);
                address.append(derutf8String.getString());
            }
        }
        signatureProductionPlace.setStreetAddress(address.toString());
        return signatureProductionPlace;
    }

    @Override
    public List<eu.europa.esig.dss.validation.CommitmentTypeIndication> getCommitmentTypeIndications() {
        Attribute commitmentTypeIndicationAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType);
        if (commitmentTypeIndicationAttribute == null) {
            return null;
        }
        try {
            ArrayList<eu.europa.esig.dss.validation.CommitmentTypeIndication> commitmentTypeIndications = null;
            ASN1Set attrValues = commitmentTypeIndicationAttribute.getAttrValues();
            int size = attrValues.size();
            if (size > 0) {
                commitmentTypeIndications = new ArrayList<eu.europa.esig.dss.validation.CommitmentTypeIndication>();
                for (int ii = 0; ii < size; ++ii) {
                    if (attrValues.getObjectAt(ii) instanceof ASN1Sequence) {
                        ASN1Sequence sequence = (ASN1Sequence)attrValues.getObjectAt(ii);
                        CommitmentTypeIndication commitmentTypeIndication = CommitmentTypeIndication.getInstance(sequence);
                        ASN1ObjectIdentifier commitmentTypeId = commitmentTypeIndication.getCommitmentTypeId();
                        commitmentTypeIndications.add(new eu.europa.esig.dss.validation.CommitmentTypeIndication(commitmentTypeId.getId()));
                        continue;
                    }
                    LOG.warn("Unsupported type for CommitmentType : {}", (Object)attrValues.getObjectAt(ii).getClass());
                }
            }
            return commitmentTypeIndications;
        }
        catch (Exception e) {
            throw new DSSException("Error when dealing with CommitmentTypeIndication!", e);
        }
    }

    @Override
    public List<SignerRole> getSignedAssertions() {
        ArrayList<SignerRole> result = new ArrayList<SignerRole>();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        if (signerAttrV2 != null) {
            for (Object signerAttrValue : signerAttrV2.getValues()) {
                if (!(signerAttrValue instanceof SignedAssertions)) continue;
                List<SignedAssertion> assertions = ((SignedAssertions)signerAttrValue).getAssertions();
                for (SignedAssertion sa : assertions) {
                    result.add(new SignerRole(sa.toString(), EndorsementType.SIGNED));
                }
            }
        }
        return result;
    }

    @Override
    public List<SignerRole> getClaimedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return Collections.emptyList();
            }
            ArrayList<SignerRole> claimedRoles = new ArrayList<SignerRole>();
            for (Object signerAttrValue : signerAttrValues) {
                org.bouncycastle.asn1.x509.Attribute[] signerAttrValueArray;
                if (!(signerAttrValue instanceof org.bouncycastle.asn1.x509.Attribute[])) continue;
                for (org.bouncycastle.asn1.x509.Attribute claimedRole : signerAttrValueArray = (org.bouncycastle.asn1.x509.Attribute[])signerAttrValue) {
                    ASN1Encodable[] attrValues1;
                    for (ASN1Encodable asn1Encodable : attrValues1 = claimedRole.getAttrValues().toArray()) {
                        if (!(asn1Encodable instanceof ASN1String)) continue;
                        ASN1String asn1String = (ASN1String)((Object)asn1Encodable);
                        String role = asn1String.getString();
                        claimedRoles.add(new SignerRole(role, EndorsementType.CLAIMED));
                    }
                }
            }
            return claimedRoles;
        }
        catch (Exception e) {
            LOG.error("Error when dealing with claimed signer roles : {}", (Object)signerAttrValues, (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<SignerRole> getCertifiedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return Collections.emptyList();
            }
            ArrayList<SignerRole> roles = new ArrayList<SignerRole>();
            for (Object signerAttrValue : signerAttrValues) {
                if (!(signerAttrValue instanceof AttributeCertificate)) continue;
                AttributeCertificate attributeCertificate = (AttributeCertificate)signerAttrValue;
                AttributeCertificateInfo acInfo = attributeCertificate.getAcinfo();
                AttCertValidityPeriod attrCertValidityPeriod = acInfo.getAttrCertValidityPeriod();
                ASN1Sequence attributes = acInfo.getAttributes();
                for (int ii = 0; ii < attributes.size(); ++ii) {
                    ASN1Encodable objectAt = attributes.getObjectAt(ii);
                    org.bouncycastle.asn1.x509.Attribute attribute = org.bouncycastle.asn1.x509.Attribute.getInstance(objectAt);
                    ASN1Set attrValues1 = attribute.getAttrValues();
                    ASN1Encodable firstItem = attrValues1.getObjectAt(0);
                    if (firstItem instanceof ASN1Sequence) {
                        ASN1Sequence sequence = (ASN1Sequence)firstItem;
                        RoleSyntax roleSyntax = RoleSyntax.getInstance(sequence);
                        SignerRole certifiedRole = new SignerRole(roleSyntax.getRoleNameAsString(), EndorsementType.CERTIFIED);
                        certifiedRole.setNotBefore(DSSASN1Utils.toDate(attrCertValidityPeriod.getNotBeforeTime()));
                        certifiedRole.setNotAfter(DSSASN1Utils.toDate(attrCertValidityPeriod.getNotAfterTime()));
                        roles.add(certifiedRole);
                        continue;
                    }
                    LOG.warn("Unsupported type for RoleSyntax : {}", (Object)(firstItem == null ? null : firstItem.getClass().getSimpleName()));
                }
            }
            return roles;
        }
        catch (Exception e) {
            LOG.error("Error when dealing with certified signer roles : {}", (Object)signerAttrValues, (Object)e);
            return Collections.emptyList();
        }
    }

    private SignerAttribute getSignerAttributeV1() {
        Attribute id_aa_ets_signerAttr = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr);
        if (id_aa_ets_signerAttr != null) {
            ASN1Set attrValues = id_aa_ets_signerAttr.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttribute.getInstance(attrValue);
            }
            catch (Exception e) {
                String warningMessage = "Unable to parse signerAttr - [{}]. Reason : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(warningMessage, Utils.toBase64(DSSASN1Utils.getDEREncoded(attrValue)), e.getMessage(), e);
                }
                LOG.warn(warningMessage, (Object)Utils.toBase64(DSSASN1Utils.getDEREncoded(attrValue)), (Object)e.getMessage());
            }
        }
        return null;
    }

    private SignerAttributeV2 getSignerAttributeV2() {
        Attribute id_aa_ets_signerAttrV2 = this.getSignedAttribute(OID.id_aa_ets_signerAttrV2);
        if (id_aa_ets_signerAttrV2 != null) {
            ASN1Set attrValues = id_aa_ets_signerAttrV2.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttributeV2.getInstance(attrValue);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse signerAttrV2 : {}", (Object)Utils.toBase64(DSSASN1Utils.getDEREncoded(attrValue)), (Object)e);
            }
        }
        return null;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        String oid = this.signerInformation.getEncryptionAlgOID();
        try {
            return EncryptionAlgorithm.forOID(oid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID(oid);
            return signatureAlgorithm.getEncryptionAlgorithm();
        }
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getEncryptedDigestAlgo();
        if (signatureAlgorithm != null) {
            if (SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.equals(signatureAlgorithm)) {
                return this.getPSSHashAlgorithm();
            }
            return signatureAlgorithm.getDigestAlgorithm();
        }
        try {
            String digestAlgOID = this.signerInformation.getDigestAlgOID();
            return DigestAlgorithm.forOID(digestAlgOID);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    private SignatureAlgorithm getEncryptedDigestAlgo() {
        try {
            return SignatureAlgorithm.forOID(this.signerInformation.getEncryptionAlgOID());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public DigestAlgorithm getPSSHashAlgorithm() {
        try {
            byte[] encryptionAlgParams = this.signerInformation.getEncryptionAlgParams();
            if (Utils.isArrayNotEmpty(encryptionAlgParams) && !Arrays.equals(DERNull.INSTANCE.getEncoded(), encryptionAlgParams)) {
                RSASSAPSSparams param = RSASSAPSSparams.getInstance(encryptionAlgParams);
                AlgorithmIdentifier pssHashAlgo = param.getHashAlgorithm();
                return DigestAlgorithm.forOID(pssHashAlgo.getAlgorithm().getId());
            }
        }
        catch (IOException e) {
            LOG.error("Unable to analyze EncryptionAlgParams", e);
        }
        return null;
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        try {
            byte[] encryptionAlgParams;
            SignatureAlgorithm signatureAlgorithm = this.getEncryptedDigestAlgo();
            if (signatureAlgorithm != null && SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.equals(signatureAlgorithm) && Utils.isArrayNotEmpty(encryptionAlgParams = this.signerInformation.getEncryptionAlgParams()) && !Arrays.equals(DERNull.INSTANCE.getEncoded(), encryptionAlgParams)) {
                RSASSAPSSparams param = RSASSAPSSparams.getInstance(encryptionAlgParams);
                AlgorithmIdentifier maskGenAlgorithm = param.getMaskGenAlgorithm();
                if (PKCSObjectIdentifiers.id_mgf1.equals(maskGenAlgorithm.getAlgorithm())) {
                    return MaskGenerationFunction.MGF1;
                }
                LOG.warn("Unsupported mask algorithm : {}", (Object)maskGenAlgorithm.getAlgorithm());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyze EncryptionAlgParams", e);
        }
        return null;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.getAlgorithm(this.getEncryptionAlgorithm(), this.getDigestAlgorithm(), this.getMaskGenerationFunction());
    }

    @Override
    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            CertificateValidity bestCandidate = this.getCandidatesForSigningCertificate().getTheBestCandidate();
            if (bestCandidate == null) {
                this.signatureCryptographicVerification.setErrorMessage("There is no signing certificate within the signature.");
                return;
            }
            boolean detachedSignature = CMSUtils.isDetachedSignature(this.cmsSignedData);
            SignerInformation signerInformationToCheck = null;
            if (detachedSignature && !this.isCounterSignature()) {
                if (Utils.isCollectionEmpty(this.detachedContents)) {
                    this.signatureCryptographicVerification.setErrorMessage("Detached file not found!");
                    this.getReferenceValidations(signerInformationToCheck);
                    return;
                }
                signerInformationToCheck = this.recreateSignerInformation();
            } else {
                signerInformationToCheck = this.signerInformation;
            }
            LOG.debug("CHECK SIGNATURE VALIDITY: ");
            if (bestCandidate.getCertificateToken() != null) {
                try {
                    JcaSimpleSignerInfoVerifierBuilder verifier = new JcaSimpleSignerInfoVerifierBuilder();
                    verifier.setProvider(DSSSecurityProvider.getSecurityProviderName());
                    CertificateToken certificateToken = bestCandidate.getCertificateToken();
                    PublicKey publicKey = certificateToken.getPublicKey();
                    SignerInformationVerifier signerInformationVerifier = verifier.build(publicKey);
                    LOG.debug(" - WITH SIGNING CERTIFICATE: {}", (Object)certificateToken.getAbbreviation());
                    boolean signatureIntact = signerInformationToCheck.verify(signerInformationVerifier);
                    this.signatureCryptographicVerification.setSignatureIntact(signatureIntact);
                }
                catch (CMSSignerDigestMismatchException e) {
                    LOG.warn("Unable to validate CMS Signature : {}", (Object)e.getMessage());
                    this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
                    this.signatureCryptographicVerification.setSignatureIntact(false);
                }
                catch (Exception e) {
                    LOG.error("Unable to validate CMS Signature : {}", (Object)e.getMessage(), (Object)e);
                    this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
                    this.signatureCryptographicVerification.setSignatureIntact(false);
                }
            }
            boolean referenceDataFound = true;
            boolean referenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations(signerInformationToCheck);
            for (ReferenceValidation referenceValidation : refValidations) {
                referenceDataFound = referenceDataFound && referenceValidation.isFound();
                referenceDataIntact = referenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(referenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(referenceDataIntact);
        }
        catch (IOException | CMSException e) {
            LOG.error(e.getMessage(), e);
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
        }
        LOG.debug(" - RESULT: {}", (Object)this.signatureCryptographicVerification);
    }

    public List<ReferenceValidation> getReferenceValidations(SignerInformation signerInformationToCheck) {
        if (this.referenceValidations == null) {
            this.referenceValidations = new ArrayList();
            DSSDocument originalDocument = null;
            try {
                originalDocument = this.getOriginalDocument();
            }
            catch (DSSException e) {
                LOG.warn("Original document not found");
            }
            ReferenceValidation validation = null;
            byte[] messageDigestValue = this.getMessageDigestValue();
            if (messageDigestValue == null) {
                LOG.warn("message-digest is not present in SignedData! Extracting digests from content SignatureValue...");
                validation = this.getContentReferenceValidation(originalDocument, signerInformationToCheck);
            } else {
                validation = new ReferenceValidation();
                validation.setType(DigestMatcherType.MESSAGE_DIGEST);
                Digest messageDigest = new Digest();
                messageDigest.setValue(messageDigestValue);
                validation.setDigest(messageDigest);
                Set<DigestAlgorithm> messageDigestAlgorithms = this.getMessageDigestAlgorithms();
                if (Utils.collectionSize(messageDigestAlgorithms) == 1) {
                    messageDigest.setAlgorithm(messageDigestAlgorithms.iterator().next());
                }
                if (originalDocument != null) {
                    validation.setFound(true);
                    validation.setIntact(this.verifyDigestAlgorithm(originalDocument, messageDigestAlgorithms, messageDigest));
                    validation.getDependentValidations().addAll(this.getManifestEntryValidation(originalDocument, messageDigest));
                } else {
                    LOG.warn("The original document is not found or cannot be extracted. Reference validation is not possible.");
                }
            }
            this.referenceValidations.add(validation);
        }
        return this.referenceValidations;
    }

    private boolean verifyDigestAlgorithm(DSSDocument originalDocument, Set<DigestAlgorithm> messageDigestAlgorithms, Digest messageDigest) {
        if (Utils.isCollectionNotEmpty(messageDigestAlgorithms)) {
            for (DigestAlgorithm digestAlgorithm : messageDigestAlgorithms) {
                String base64Digest = originalDocument.getDigest(digestAlgorithm);
                if (!Arrays.equals(messageDigest.getValue(), Utils.fromBase64(base64Digest))) continue;
                messageDigest.setAlgorithm(digestAlgorithm);
                return true;
            }
        } else {
            LOG.warn("Message DigestAlgorithms not found in SignedData! Reference validation is not possible.");
        }
        return false;
    }

    private List<ReferenceValidation> getManifestEntryValidation(DSSDocument originalDocument, Digest messageDigest) {
        ArrayList<ReferenceValidation> manifestEntryValidations = new ArrayList<ReferenceValidation>();
        ManifestFile manifest = this.getSignedManifest(originalDocument, messageDigest);
        if (manifest == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No related manifest file found for a signature with name [{}]", (Object)this.getSignatureFilename());
            }
            return manifestEntryValidations;
        }
        for (ManifestEntry entry : manifest.getEntries()) {
            ReferenceValidation entryValidation = new ReferenceValidation();
            entryValidation.setType(DigestMatcherType.MANIFEST_ENTRY);
            entryValidation.setName(entry.getFileName());
            entryValidation.setDigest(entry.getDigest());
            entryValidation.setFound(entry.isFound());
            entryValidation.setIntact(entry.isIntact());
            manifestEntryValidations.add(entryValidation);
        }
        return manifestEntryValidations;
    }

    private ManifestFile getSignedManifest(DSSDocument originalDocument, Digest messageDigest) {
        if (Utils.isCollectionNotEmpty(this.manifestFiles)) {
            DigestAlgorithm digestAlgorithm = messageDigest.getAlgorithm() != null ? messageDigest.getAlgorithm() : DigestAlgorithm.SHA256;
            String digestValue = originalDocument.getDigest(digestAlgorithm);
            for (ManifestFile manifestFile : this.manifestFiles) {
                if (!digestValue.equals(manifestFile.getDigestBase64String(digestAlgorithm))) continue;
                return manifestFile;
            }
        }
        return null;
    }

    @Override
    public List<ReferenceValidation> getReferenceValidations() {
        this.checkSignatureIntegrity();
        return this.referenceValidations;
    }

    private ReferenceValidation getContentReferenceValidation(DSSDocument originalDocument, SignerInformation signerInformation) {
        byte[] contentDigest;
        ReferenceValidation contentValidation = new ReferenceValidation();
        contentValidation.setType(DigestMatcherType.CONTENT_DIGEST);
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmForOID(signerInformation.getDigestAlgOID());
        if (originalDocument != null && digestAlgorithm != null && Utils.isArrayNotEmpty(contentDigest = signerInformation.getContentDigest())) {
            contentValidation.setFound(true);
            contentValidation.setDigest(new Digest(digestAlgorithm, contentDigest));
            if (Arrays.equals(contentDigest, Utils.fromBase64(originalDocument.getDigest(digestAlgorithm)))) {
                contentValidation.setIntact(true);
            }
        }
        return contentValidation;
    }

    @Override
    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] derEncodedSignerInfo = DSSASN1Utils.getDEREncoded(this.signerInformation.toASN1Structure());
        byte[] digestValue = DSSUtils.digest(digestAlgorithm, derEncodedSignerInfo);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    private SignerInformation recreateSignerInformation() throws CMSException, IOException {
        DSSDocument dssDocument = (DSSDocument)this.detachedContents.get(0);
        CMSSignedDataParser cmsSignedDataParser = null;
        if (dssDocument instanceof DigestDocument) {
            cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new PrecomputedDigestCalculatorProvider((DigestDocument)dssDocument), this.cmsSignedData.getEncoded());
        } else {
            try (InputStream inputStream = dssDocument.openStream();){
                CMSTypedStream signedContent = new CMSTypedStream(inputStream);
                cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), signedContent, this.cmsSignedData.getEncoded());
                cmsSignedDataParser.getSignedContent().drain();
            }
        }
        SignerId signerId = this.getSignerId();
        SignerInformation signerInformationToCheck = cmsSignedDataParser.getSignerInfos().get(signerId);
        return signerInformationToCheck;
    }

    public Set<DigestAlgorithm> getMessageDigestAlgorithms() {
        HashSet<DigestAlgorithm> result = new HashSet<DigestAlgorithm>();
        Set<AlgorithmIdentifier> digestAlgorithmIDs = this.cmsSignedData.getDigestAlgorithmIDs();
        for (AlgorithmIdentifier algorithmIdentifier : digestAlgorithmIDs) {
            String oid = algorithmIdentifier.getAlgorithm().getId();
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmForOID(oid);
            if (digestAlgorithm == null) continue;
            result.add(digestAlgorithm);
        }
        return result;
    }

    private DigestAlgorithm getDigestAlgorithmForOID(String oid) {
        try {
            return DigestAlgorithm.forOID(oid);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Not a digest algorithm {} : {}", (Object)oid, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public byte[] getMessageDigestValue() {
        Attribute messageDigestAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        if (messageDigestAttribute == null) {
            return null;
        }
        ASN1OctetString asn1OctetString = (ASN1OctetString)messageDigestAttribute.getAttrValues().getObjectAt(0);
        return asn1OctetString.getOctets();
    }

    @Override
    public String getContentType() {
        Attribute contentTypeAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_contentType);
        if (contentTypeAttribute == null) {
            return null;
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)contentTypeAttribute.getAttrValues().getObjectAt(0);
        return oid.getId();
    }

    @Override
    public String getMimeType() {
        Attribute mimeTypeAttribute = this.getSignedAttribute(OID.id_aa_ets_mimeType);
        if (mimeTypeAttribute == null) {
            return null;
        }
        return DSSASN1Utils.getString(mimeTypeAttribute.getAttrValues().getObjectAt(0));
    }

    @Override
    public String getContentIdentifier() {
        Attribute contentIdentifierAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_contentIdentifier);
        if (contentIdentifierAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentIdentifierAttribute.getAttrValues().getObjectAt(0);
        ContentIdentifier contentIdentifier = ContentIdentifier.getInstance(asn1Encodable);
        String contentIdentifierString = DSSASN1Utils.toString(contentIdentifier.getValue());
        return contentIdentifierString;
    }

    @Override
    public String getContentHints() {
        Attribute contentHintAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_contentHint);
        if (contentHintAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentHintAttribute.getAttrValues().getObjectAt(0);
        String contentHint = null;
        try {
            ContentHints contentHints = ContentHints.getInstance(asn1Encodable);
            if (contentHints != null) {
                contentHint = contentHints.getContentType().toString();
                if (contentHints.getContentDescription() != null) {
                    contentHint = contentHint + " [" + contentHints.getContentDescription().toString() + "]";
                }
            }
        }
        catch (Exception e) {
            String warningMessage = "Unable to parse ContentHints - [{}]. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(warningMessage, Utils.toBase64(DSSASN1Utils.getDEREncoded(asn1Encodable)), e.getMessage(), e);
            }
            LOG.warn(warningMessage, (Object)Utils.toBase64(DSSASN1Utils.getDEREncoded(asn1Encodable)), (Object)e.getMessage());
        }
        return contentHint;
    }

    public SignerInformation getSignerInformation() {
        return this.signerInformation;
    }

    @Override
    public byte[] getSignatureValue() {
        return this.signerInformation.getSignature();
    }

    @Override
    public boolean isCounterSignature() {
        return this.signerInformation.isCounterSignature();
    }

    @Override
    public List<AdvancedSignature> getCounterSignatures() {
        ArrayList<AdvancedSignature> countersignatures = new ArrayList<AdvancedSignature>();
        this.recursiveCollect(countersignatures, this.signerInformation, this);
        return countersignatures;
    }

    private void recursiveCollect(List<AdvancedSignature> collector, SignerInformation currentSignerInformation, AdvancedSignature master) {
        for (SignerInformation counterSignerInformation : currentSignerInformation.getCounterSignatures()) {
            CAdESSignature countersignature = new CAdESSignature(this.cmsSignedData, counterSignerInformation);
            countersignature.setMasterSignature(master);
            collector.add(countersignature);
            this.recursiveCollect(collector, counterSignerInformation, countersignature);
        }
    }

    public DSSDocument getOriginalDocument() throws DSSException {
        if (this.isCounterSignature()) {
            return new InMemoryDocument(this.getMasterSignature().getSignatureValue());
        }
        return CMSUtils.getOriginalDocument(this.cmsSignedData, this.detachedContents);
    }

    @Override
    protected SignatureIdentifier buildSignatureIdentifier() {
        return new CAdESSignatureIdentifier(this);
    }

    @Override
    public String getDAIdentifier() {
        return null;
    }

    private Attribute getSignedAttribute(ASN1ObjectIdentifier oid) {
        AttributeTable signedAttributes = this.signerInformation.getSignedAttributes();
        if (signedAttributes == null) {
            return null;
        }
        return signedAttributes.get(oid);
    }

    @Override
    public Set<CertificateIdentifier> getSignerInformationStoreInfos() {
        return this.getCertificateSource().getAllCertificateIdentifiers();
    }

    @Override
    public SignatureLevel getDataFoundUpToLevel() {
        if (!this.hasBProfile()) {
            return SignatureLevel.CMS_NOT_ETSI;
        }
        if (!this.hasTProfile()) {
            return SignatureLevel.CAdES_BASELINE_B;
        }
        if (this.hasLTProfile()) {
            if (this.hasLTAProfile()) {
                return SignatureLevel.CAdES_BASELINE_LTA;
            }
            return SignatureLevel.CAdES_BASELINE_LT;
        }
        if (this.hasCProfile()) {
            if (this.hasXProfile()) {
                return SignatureLevel.CAdES_101733_X;
            }
            return SignatureLevel.CAdES_101733_C;
        }
        return SignatureLevel.CAdES_BASELINE_T;
    }

    public boolean hasBProfile() {
        return this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_signingCertificate) != null || this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2) != null;
    }

    public boolean hasCProfile() {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(this.signerInformation);
        return unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certificateRefs) != null;
    }

    public boolean hasXProfile() {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(this.signerInformation);
        return unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp) != null || unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) != null;
    }

    public boolean hasAProfile() {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(this.signerInformation);
        return unsignedAttributes.get(OID.id_aa_ets_archiveTimestampV2) != null;
    }

    @Override
    public SignatureLevel[] getSignatureLevels() {
        return new SignatureLevel[]{SignatureLevel.CMS_NOT_ETSI, SignatureLevel.CAdES_BASELINE_B, SignatureLevel.CAdES_BASELINE_T, SignatureLevel.CAdES_101733_C, SignatureLevel.CAdES_101733_X, SignatureLevel.CAdES_BASELINE_LT, SignatureLevel.CAdES_101733_A, SignatureLevel.CAdES_BASELINE_LTA};
    }
}

