/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl.stream.impl;

import eu.europa.esig.dss.crl.stream.impl.BinaryFilteringInputStream;
import eu.europa.esig.dss.crl.stream.impl.CRLInfo;
import eu.europa.esig.dss.crl.stream.impl.DERUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509CRLEntry;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.jce.provider.X509CRLEntryObject;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRLParser {
    private static final Logger LOG = LoggerFactory.getLogger(CRLParser.class);

    CRLParser() {
    }

    public void getSignedData(BinaryFilteringInputStream is) throws IOException {
        is.on(false);
        this.consumeTagIntro(is);
        is.on(true);
        int tag = DERUtil.readTag(is);
        DERUtil.readTagNumber(is, tag);
        int tbsLength = DERUtil.readLength(is);
        this.readNbBytes(is, tbsLength);
        is.on(false);
    }

    public X509CRLEntry retrieveRevocationInfo(InputStream s2, BigInteger serialNumber) throws IOException {
        this.consumeTagIntro(s2);
        this.consumeTagIntro(s2);
        int tag = -1;
        int tagNo = 5;
        int length = -1;
        do {
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
            this.skip(s2, length);
        } while (!this.isDate(tagNo));
        tag = DERUtil.readTag(s2);
        tagNo = DERUtil.readTagNumber(s2, tag);
        length = DERUtil.readLength(s2);
        if (this.isDate(tagNo)) {
            this.skip(s2, length);
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        while (tagNo == 16) {
            tag = DERUtil.readTag(s2);
            if (tag < 0) {
                return null;
            }
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
            if (tagNo == 16) {
                byte[] entryArray = this.readNbBytes(s2, length);
                ByteArrayInputStream is = new ByteArrayInputStream(entryArray);
                try {
                    ASN1Integer asn1SerialNumber;
                    int entryTag = DERUtil.readTag(is);
                    int entryTagNo = DERUtil.readTagNumber(is, entryTag);
                    int entryLength = DERUtil.readLength(is);
                    if (2 != entryTagNo || !serialNumber.equals((asn1SerialNumber = this.rebuildASN1Integer(this.readNbBytes(is, entryLength))).getValue())) continue;
                    ASN1Sequence asn1Sequence = this.rebuildASN1Sequence(entryArray);
                    TBSCertList.CRLEntry crlEntry = TBSCertList.CRLEntry.getInstance(asn1Sequence);
                    X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(crlEntry);
                    return x509CRLEntryObject;
                }
                finally {
                    ((InputStream)is).close();
                    continue;
                }
            }
            LOG.debug("Should only contain SEQUENCEs : tagNo = {} (ignored)", (Object)tagNo);
            this.skip(s2, length);
        }
        return null;
    }

    public CRLInfo retrieveInfo(InputStream s2) throws IOException {
        boolean isTagged;
        Time time;
        byte[] array;
        if (!s2.markSupported()) {
            throw new IllegalArgumentException("The InputStream MUST support mark/reset methods !");
        }
        CRLInfo infos = new CRLInfo();
        this.consumeTagIntro(s2);
        this.consumeTagIntro(s2);
        int tag = DERUtil.readTag(s2);
        int tagNo = DERUtil.readTagNumber(s2, tag);
        int length = DERUtil.readLength(s2);
        if (tagNo == 2) {
            array = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TBSCertList -> version : {}", (Object)Hex.toHexString(array));
            }
            infos.setVersion(this.rebuildASN1Integer(array).getValue().intValue() + 1);
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        if (tagNo == 16) {
            array = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TBSCertList -> signatureAlgorithm : {}", (Object)Hex.toHexString(array));
            }
            AlgorithmIdentifier algoId = AlgorithmIdentifier.getInstance(this.rebuildASN1Sequence(array));
            ASN1ObjectIdentifier oid = algoId.getAlgorithm();
            infos.setCertificateListSignatureAlgorithmOid(oid.getId());
            ASN1Encodable parameters = algoId.getParameters();
            if (parameters != null && !DERNull.INSTANCE.equals(parameters)) {
                infos.setCertificateListSignatureAlgorithmParams(parameters.toASN1Primitive().getEncoded("DER"));
            }
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        if (tagNo == 16) {
            array = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TBSCertList -> issuer : {}", (Object)Hex.toHexString(array));
            }
            ASN1Sequence sequence = this.rebuildASN1Sequence(array);
            infos.setIssuer(new X500Principal(sequence.getEncoded()));
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        if (this.isDate(tagNo)) {
            array = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TBSCertList -> thisUpdate : {}", (Object)Hex.toHexString(array));
            }
            time = this.rebuildASN1Time(tagNo, array);
            infos.setThisUpdate(time.getDate());
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        if (this.isDate(tagNo)) {
            array = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TBSCertList -> nextUpdate : {}", (Object)Hex.toHexString(array));
            }
            time = this.rebuildASN1Time(tagNo, array);
            infos.setNextUpdate(time.getDate());
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        if (tagNo == 16) {
            if (length > 0) {
                s2.mark(10);
                int intraTag = DERUtil.readTag(s2);
                int intraTagNo = DERUtil.readTagNumber(s2, intraTag);
                s2.reset();
                if (intraTagNo == 16) {
                    this.skip(s2, length);
                    LOG.debug("TBSCertList -> revokedCertificates : skipped (length={})", (Object)length);
                    tag = DERUtil.readTag(s2);
                    tagNo = DERUtil.readTagNumber(s2, tag);
                    length = DERUtil.readLength(s2);
                }
            } else {
                LOG.debug("TBSCertList -> revokedCertificates : Empty sequence");
                tag = DERUtil.readTag(s2);
                tagNo = DERUtil.readTagNumber(s2, tag);
                length = DERUtil.readLength(s2);
            }
        }
        boolean bl = isTagged = (tag & 0x80) != 0;
        if (isTagged) {
            byte[] array2 = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TBSCertList -> crlExtensions : {}", (Object)Hex.toHexString(array2));
            }
            ASN1Sequence sequenceExtensions = (ASN1Sequence)ASN1Primitive.fromByteArray(array2);
            this.extractExtensions(sequenceExtensions, infos);
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        if (16 == tagNo) {
            byte[] array3 = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("CertificateList -> signatureAlgorithm : {}", (Object)Hex.toHexString(array3));
            }
            AlgorithmIdentifier algoId = AlgorithmIdentifier.getInstance(this.rebuildASN1Sequence(array3));
            infos.setTbsSignatureAlgorithmOid(algoId.getAlgorithm().getId());
            tag = DERUtil.readTag(s2);
            tagNo = DERUtil.readTagNumber(s2, tag);
            length = DERUtil.readLength(s2);
        }
        if (3 == tagNo) {
            byte[] array4 = this.readNbBytes(s2, length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("CertificateList -> signatureValue : {}", (Object)Hex.toHexString(array4));
            }
            infos.setSignatureValue(this.rebuildASN1BitString(array4).getOctets());
        }
        return infos;
    }

    private boolean isDate(int tagNo) {
        return tagNo == 23 || tagNo == 24;
    }

    private byte[] readNbBytes(InputStream s2, int length) throws IOException {
        byte[] array = new byte[length];
        if (Streams.readFully(s2, array) != length) {
            LOG.warn("Cannot read expected length!");
        }
        return array;
    }

    private void skip(InputStream s2, int length) throws IOException {
        long skip = -1L;
        for (long skipped = 0L; skipped < (long)length && skip != 0L; skipped += skip) {
            skip = s2.skip((long)length - skipped);
        }
    }

    private void extractExtensions(ASN1Sequence seq, CRLInfo infos) throws IOException {
        Enumeration enumSeq = seq.getObjects();
        while (enumSeq.hasMoreElements()) {
            ASN1Sequence extension = null;
            try {
                ASN1ObjectIdentifier oid;
                extension = (ASN1Sequence)enumSeq.nextElement();
                int seqSize = extension.size();
                if (seqSize == 2) {
                    oid = (ASN1ObjectIdentifier)extension.getObjectAt(0);
                    byte[] content = extension.getObjectAt(1).toASN1Primitive().getEncoded();
                    infos.addNonCriticalExtension(oid.getId(), content);
                    continue;
                }
                if (seqSize == 3) {
                    oid = (ASN1ObjectIdentifier)extension.getObjectAt(0);
                    ASN1Boolean isCritical = (ASN1Boolean)extension.getObjectAt(1);
                    byte[] content = extension.getObjectAt(2).toASN1Primitive().getEncoded();
                    if (isCritical.isTrue()) {
                        infos.addCriticalExtension(oid.getId(), content);
                        continue;
                    }
                    infos.addNonCriticalExtension(oid.getId(), content);
                    continue;
                }
                LOG.warn("Not supported format : {}", (Object)extension);
            }
            catch (Exception e) {
                LOG.warn("Cannot parse extension {} : {}", (Object)extension, (Object)e.getMessage());
            }
        }
    }

    private void consumeTagIntro(InputStream s2) throws IOException {
        int tag = DERUtil.readTag(s2);
        DERUtil.readTagNumber(s2, tag);
        DERUtil.readLength(s2);
    }

    private ASN1Sequence rebuildASN1Sequence(byte[] array) throws IOException {
        return (ASN1Sequence)this.rebuildASN1Primitive(48, array);
    }

    private ASN1BitString rebuildASN1BitString(byte[] array) throws IOException {
        return (ASN1BitString)this.rebuildASN1Primitive(3, array);
    }

    private ASN1Integer rebuildASN1Integer(byte[] array) throws IOException {
        return (ASN1Integer)this.rebuildASN1Primitive(2, array);
    }

    private Time rebuildASN1Time(int tagNo, byte[] array) throws IOException {
        return Time.getInstance(this.rebuildASN1Primitive(tagNo, array));
    }

    private ASN1Primitive rebuildASN1Primitive(int tagNo, byte[] array) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            baos.write(tagNo);
            DERUtil.writeLength(baos, array.length);
            baos.write(array);
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(baos.toByteArray());
            return aSN1Primitive;
        }
    }
}

