/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.OrphanCertificateWrapper;
import eu.europa.esig.dss.diagnostic.RelatedCertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundCertificates;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedCertificate;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import java.util.ArrayList;
import java.util.List;

public class FoundCertificatesProxy {
    private XmlFoundCertificates foundCertificates;

    public FoundCertificatesProxy(XmlFoundCertificates foundCertificates) {
        this.foundCertificates = foundCertificates;
    }

    private XmlFoundCertificates getFoundCertificates() {
        if (this.foundCertificates == null) {
            this.foundCertificates = new XmlFoundCertificates();
        }
        return this.foundCertificates;
    }

    public List<RelatedCertificateWrapper> getRelatedCertificates() {
        ArrayList<RelatedCertificateWrapper> certificateWrappers = new ArrayList<RelatedCertificateWrapper>();
        List<XmlRelatedCertificate> relatedCertificates = this.getFoundCertificates().getRelatedCertificates();
        for (XmlRelatedCertificate relatedCertificate : relatedCertificates) {
            certificateWrappers.add(new RelatedCertificateWrapper(relatedCertificate));
        }
        return certificateWrappers;
    }

    public List<OrphanCertificateWrapper> getOrphanCertificates() {
        ArrayList<OrphanCertificateWrapper> orphanTokens = new ArrayList<OrphanCertificateWrapper>();
        List<XmlOrphanCertificate> orphanCertificates = this.getFoundCertificates().getOrphanCertificates();
        for (XmlOrphanCertificate orphanCertificate : orphanCertificates) {
            orphanTokens.add(new OrphanCertificateWrapper(orphanCertificate));
        }
        return orphanTokens;
    }

    public List<RelatedCertificateWrapper> getRelatedCertificatesByOrigin(CertificateOrigin origin) {
        ArrayList<RelatedCertificateWrapper> certificateWrappers = new ArrayList<RelatedCertificateWrapper>();
        List<RelatedCertificateWrapper> relatedCertificates = this.getRelatedCertificates();
        for (RelatedCertificateWrapper relatedCertificate : relatedCertificates) {
            if (!relatedCertificate.getOrigins().contains((Object)origin)) continue;
            certificateWrappers.add(relatedCertificate);
        }
        return certificateWrappers;
    }

    public List<OrphanCertificateWrapper> getOrphanCertificatesByOrigin(CertificateOrigin origin) {
        ArrayList<OrphanCertificateWrapper> orphanCertificatesWrappers = new ArrayList<OrphanCertificateWrapper>();
        List<OrphanCertificateWrapper> orphanCertificates = this.getOrphanCertificates();
        for (OrphanCertificateWrapper orphanCertificate : orphanCertificates) {
            if (!orphanCertificate.getOrigins().contains((Object)origin)) continue;
            orphanCertificatesWrappers.add(orphanCertificate);
        }
        return orphanCertificatesWrappers;
    }

    public List<RelatedCertificateWrapper> getRelatedCertificatesByRefOrigin(CertificateRefOrigin refOrigin) {
        ArrayList<RelatedCertificateWrapper> certificateWrappers = new ArrayList<RelatedCertificateWrapper>();
        List<RelatedCertificateWrapper> relatedCertificates = this.getRelatedCertificates();
        block0: for (RelatedCertificateWrapper relatedCertificate : relatedCertificates) {
            for (CertificateRefWrapper certificateRef : relatedCertificate.getReferences()) {
                if (!refOrigin.equals((Object)certificateRef.getOrigin())) continue;
                certificateWrappers.add(relatedCertificate);
                continue block0;
            }
        }
        return certificateWrappers;
    }

    public List<OrphanCertificateWrapper> getOrphanCertificatesByRefOrigin(CertificateRefOrigin refOrigin) {
        ArrayList<OrphanCertificateWrapper> orphanCertificatesWrappers = new ArrayList<OrphanCertificateWrapper>();
        List<OrphanCertificateWrapper> orphanCertificates = this.getOrphanCertificates();
        block0: for (OrphanCertificateWrapper orphanCertificate : orphanCertificates) {
            for (CertificateRefWrapper certificateRef : orphanCertificate.getReferences()) {
                if (!refOrigin.equals((Object)certificateRef.getOrigin())) continue;
                orphanCertificatesWrappers.add(orphanCertificate);
                continue block0;
            }
        }
        return orphanCertificatesWrappers;
    }

    public List<CertificateRefWrapper> getRelatedCertificateRefs() {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        for (RelatedCertificateWrapper certificateWrapper : this.getRelatedCertificates()) {
            certificateRefs.addAll(certificateWrapper.getReferences());
        }
        return certificateRefs;
    }

    public List<CertificateRefWrapper> getOrphanCertificateRefs() {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        for (OrphanCertificateWrapper certificateWrapper : this.getOrphanCertificates()) {
            certificateRefs.addAll(certificateWrapper.getReferences());
        }
        return certificateRefs;
    }

    public List<CertificateRefWrapper> getRelatedCertificateRefsByRefOrigin(CertificateRefOrigin refOrigin) {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        for (CertificateRefWrapper ref : this.getRelatedCertificateRefs()) {
            if (!refOrigin.equals((Object)ref.getOrigin())) continue;
            certificateRefs.add(ref);
        }
        return certificateRefs;
    }

    public List<CertificateRefWrapper> getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin refOrigin) {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        for (CertificateRefWrapper ref : this.getOrphanCertificateRefs()) {
            if (!refOrigin.equals((Object)ref.getOrigin())) continue;
            certificateRefs.add(ref);
        }
        return certificateRefs;
    }
}

