/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import java.util.HashMap;
import java.util.Map;

public enum CertificateQualification {
    QCERT_FOR_ESIG_QSCD("QC for eSig with QSCD", "Qualified Certificate for Electronic Signatures with private key on QSCD", true, true, true),
    QCERT_FOR_ESEAL_QSCD("QC for eSeal with QSCD", "Qualified Certificate for Electronic Seals with private key on QSCD", true, false, true),
    QCERT_FOR_ESIG("QC for eSig", "Qualified Certificate for Electronic Signatures", true, true, false),
    QCERT_FOR_ESEAL("QC for eSeal", "Qualified Certificate for Electronic Seals", true, false, false),
    QCERT_FOR_WSA("QC for WSA", "Qualified Certificate for Web Site Authentications", true, false, false),
    CERT_FOR_ESIG("Cert for eSig", "Certificate for Electronic Signatures", false, true, false),
    CERT_FOR_ESEAL("Cert for eSeal", "Certificate for Electronic Seals", false, false, false),
    CERT_FOR_WSA("Cert for WSA", "Certificate for Web Site Authentications", false, false, false),
    NA("N/A", "Not applicable", false, false, false);

    private final String readable;
    private final String label;
    private final boolean qc;
    private final boolean forEsig;
    private final boolean qscd;

    private CertificateQualification(String readable, String label, boolean qc, boolean forEsig, boolean qscd) {
        this.readable = readable;
        this.label = label;
        this.qc = qc;
        this.forEsig = forEsig;
        this.qscd = qscd;
    }

    public String getReadable() {
        return this.readable;
    }

    public String getLabel() {
        return this.label;
    }

    public static CertificateQualification forName(String value) {
        if (value != null && !value.isEmpty()) {
            return CertificateQualification.valueOf(value);
        }
        return null;
    }

    public static CertificateQualification fromReadable(String readable) {
        if (readable != null && !readable.isEmpty()) {
            return (CertificateQualification)((Object)Registry.QUALIFS_BY_READABLE.get(readable));
        }
        return null;
    }

    public boolean isQc() {
        return this.qc;
    }

    public boolean isForEsig() {
        return this.forEsig;
    }

    public boolean isQscd() {
        return this.qscd;
    }

    private static class Registry {
        private static final Map<String, CertificateQualification> QUALIFS_BY_READABLE = Registry.registerByReadable();

        private Registry() {
        }

        private static Map<String, CertificateQualification> registerByReadable() {
            HashMap<String, CertificateQualification> map = new HashMap<String, CertificateQualification>();
            for (CertificateQualification qualification : CertificateQualification.values()) {
                map.put(qualification.readable, qualification);
            }
            return map;
        }
    }
}

