/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESTimestampDataBuilder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.validation.PdfRevision;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cms.SignerInformation;

public class PAdESTimestampDataBuilder
extends CAdESTimestampDataBuilder {
    private final List<PdfRevision> documentRevisions;
    private List<TimestampToken> signatureTimestamps = new ArrayList<TimestampToken>();

    public PAdESTimestampDataBuilder(List<PdfRevision> documentRevisions, SignerInformation signerInformation, List<DSSDocument> detacheDocuments) {
        super(signerInformation, detacheDocuments);
        this.documentRevisions = documentRevisions;
    }

    public void setSignatureTimestamps(List<TimestampToken> signatureTimestamps) {
        this.signatureTimestamps = signatureTimestamps;
    }

    @Override
    public DSSDocument getSignatureTimestampData(TimestampToken timestampToken) {
        DSSDocument signedData = this.getSignedDataInPDFRevisions(timestampToken);
        if (signedData != null) {
            return signedData;
        }
        if (this.signatureTimestamps.contains(timestampToken)) {
            return super.getSignatureTimestampData(timestampToken);
        }
        throw new DSSException("Timestamp Data not found");
    }

    @Override
    public DSSDocument getTimestampX1Data(TimestampToken timestampToken) {
        return null;
    }

    @Override
    public DSSDocument getTimestampX2Data(TimestampToken timestampToken) {
        return null;
    }

    @Override
    public DSSDocument getArchiveTimestampData(TimestampToken timestampToken) {
        DSSDocument signedData = this.getSignedDataInPDFRevisions(timestampToken);
        if (signedData != null) {
            return signedData;
        }
        throw new DSSException("Timestamp Data not found");
    }

    private DSSDocument getSignedDataInPDFRevisions(TimestampToken timestampToken) {
        for (PdfRevision signatureInfo : this.documentRevisions) {
            PdfDocTimestampRevision pdfTimestampInfo;
            if (!(signatureInfo instanceof PdfDocTimestampRevision) || !(pdfTimestampInfo = (PdfDocTimestampRevision)signatureInfo).getTimestampToken().equals(timestampToken)) continue;
            byte[] signedDocumentBytes = pdfTimestampInfo.getRevisionCoveredBytes();
            return new InMemoryDocument(signedDocumentBytes);
        }
        return null;
    }
}

