/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationException;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheCRLSource
extends JdbcRevocationSource<CRL>
implements CRLSource {
    private static final long serialVersionUID = 3007740140330998336L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheCRLSource.class);
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_CRL";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_CRL (ID CHAR(40), DATA BLOB, ISSUER LONGVARBINARY)";
    private static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_FIND_QUERY_ID = "ID";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_QUERY_ISSUER = "ISSUER";
    private static final String SQL_FIND_INSERT = "INSERT INTO CACHED_CRL (ID, DATA, ISSUER) VALUES (?, ?, ?)";
    private static final String SQL_FIND_UPDATE = "UPDATE CACHED_CRL SET DATA = ?, ISSUER = ?  WHERE ID = ?";
    private static final String SQL_FIND_REMOVE = "DELETE FROM CACHED_CRL WHERE ID = ?";
    private static final String SQL_DROP_TABLE = "DROP TABLE CACHED_CRL";

    @Override
    protected String getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    @Override
    protected String getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    @Override
    protected String getFindRevocationQuery() {
        return SQL_FIND_QUERY;
    }

    @Override
    protected String getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    @Override
    protected String getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    @Override
    public List<String> initRevocationTokenKey(CertificateToken certificateToken) {
        return DSSRevocationUtils.getCRLRevocationTokenKeys(certificateToken);
    }

    @Override
    protected RevocationToken<CRL> buildRevocationTokenFromResult(ResultSet rs, CertificateToken certificateToken, CertificateToken issuerCert) {
        try {
            CRLBinary crlBinary = CRLUtils.buildCRLBinary(rs.getBytes(SQL_FIND_QUERY_DATA));
            CertificateToken cachedIssuerCertificate = DSSUtils.loadCertificate(rs.getBytes(SQL_FIND_QUERY_ISSUER));
            CRLValidity cached = CRLUtils.buildCRLValidity(crlBinary, cachedIssuerCertificate);
            cached.setKey(rs.getString(SQL_FIND_QUERY_ID));
            cached.setIssuerToken(cachedIssuerCertificate);
            CRLToken crlToken = new CRLToken(certificateToken, cached);
            crlToken.setExternalOrigin(RevocationOrigin.CACHED);
            return crlToken;
        }
        catch (IOException | SQLException e) {
            throw new RevocationException(String.format("An error occurred during an attempt to get a revocation token. Reason : %s", e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertRevocation(RevocationToken<CRL> token) {
        Connection c = null;
        PreparedStatement s2 = null;
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        try {
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(SQL_FIND_INSERT);
            s2.setString(1, token.getRevocationTokenKey());
            s2.setBytes(2, crlValidity.getDerEncoded());
            s2.setBytes(3, crlValidity.getIssuerToken().getEncoded());
            s2.executeUpdate();
            c.commit();
            LOG.debug("CRL token with key '{}' successfully inserted in DB", (Object)token.getRevocationTokenKey());
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to insert CRL {} into the DB. Cause : '{}'", token, e.getMessage(), e);
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
            this.closeQuietly(c, s2, null);
        }
        this.closeQuietly(c, s2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateRevocation(RevocationToken<CRL> token) {
        Connection c = null;
        PreparedStatement s2 = null;
        CRLToken crlToken = (CRLToken)token;
        CRLValidity crlValidity = crlToken.getCrlValidity();
        try {
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(SQL_FIND_UPDATE);
            s2.setBytes(1, crlValidity.getDerEncoded());
            s2.setBytes(2, crlValidity.getIssuerToken().getEncoded());
            s2.setString(3, token.getRevocationTokenKey());
            s2.executeUpdate();
            c.commit();
            LOG.debug("CRL token with key '{}' successfully updated in DB", (Object)token.getRevocationTokenKey());
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to update CRL {} into the DB. Cause : '{}'", token, e.getMessage(), e);
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
            this.closeQuietly(c, s2, null);
        }
        this.closeQuietly(c, s2, null);
    }

    @Override
    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (CRLToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }
}

