/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import java.security.Provider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSSecurityProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DSSSecurityProvider.class);
    private static Provider securityProvider;

    private DSSSecurityProvider() {
    }

    public static Provider getSecurityProvider() {
        if (securityProvider == null) {
            securityProvider = new BouncyCastleProvider();
            LOG.debug("DSSSecurityProvider initialized with {}", (Object)BouncyCastleProvider.class);
        }
        return securityProvider;
    }

    public static String getSecurityProviderName() {
        return DSSSecurityProvider.getSecurityProvider().getName();
    }

    public static void setSecurityProvider(Provider provider) {
        LOG.debug("DSSSecurityProvider initialized with {}", (Object)provider.getClass());
        securityProvider = provider;
    }
}

