/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.alert.ExceptionOnStatusAlert;
import eu.europa.esig.dss.alert.LogOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ListRevocationSource;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CommonCertificateVerifier
implements CertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCertificateVerifier.class);
    private ListCertificateSource trustedCertSources = new ListCertificateSource();
    private ListCertificateSource adjunctCertSources = new ListCertificateSource();
    private RevocationSource<OCSP> ocspSource;
    private RevocationSource<CRL> crlSource;
    private DataLoader dataLoader;
    private ListRevocationSource<CRL> signatureCRLSource;
    private ListRevocationSource<OCSP> signatureOCSPSource;
    private ListCertificateSource signatureCertificateSource;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private StatusAlert alertOnInvalidTimestamp = new ExceptionOnStatusAlert();
    private StatusAlert alertOnMissingRevocationData = new ExceptionOnStatusAlert();
    private StatusAlert alertOnRevokedCertificate = new ExceptionOnStatusAlert();
    private StatusAlert alertOnNoRevocationAfterBestSignatureTime = new LogOnStatusAlert(Level.WARN);
    private StatusAlert alertOnUncoveredPOE = new LogOnStatusAlert(Level.WARN);
    private boolean checkRevocationForUntrustedChains = false;

    public CommonCertificateVerifier() {
        this(false);
    }

    public CommonCertificateVerifier(boolean simpleCreationOnly) {
        LOG.info("+ New CommonCertificateVerifier created.");
        if (!simpleCreationOnly) {
            this.dataLoader = new NativeHTTPDataLoader();
        }
    }

    public CommonCertificateVerifier(List<CertificateSource> trustedCertSources, CRLSource crlSource, OCSPSource ocspSource, DataLoader dataLoader) {
        LOG.info("+ New CommonCertificateVerifier created with parameters.");
        this.trustedCertSources = new ListCertificateSource(trustedCertSources);
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
        this.dataLoader = dataLoader;
        if (dataLoader == null) {
            LOG.warn("DataLoader is null. It's required to access AIA certificate source");
        }
    }

    @Override
    public ListCertificateSource getTrustedCertSources() {
        return this.trustedCertSources;
    }

    @Override
    public RevocationSource<OCSP> getOcspSource() {
        return this.ocspSource;
    }

    @Override
    public RevocationSource<CRL> getCrlSource() {
        return this.crlSource;
    }

    @Override
    public void setCrlSource(RevocationSource<CRL> crlSource) {
        this.crlSource = crlSource;
    }

    @Override
    public void setOcspSource(RevocationSource<OCSP> ocspSource) {
        this.ocspSource = ocspSource;
    }

    @Override
    @Deprecated
    public void setTrustedCertSource(CertificateSource trustedCertSource) {
        Objects.requireNonNull(trustedCertSource, "CertificateSource cannot be null!");
        this.setTrustedCertSources(trustedCertSource);
    }

    @Override
    public void setTrustedCertSources(CertificateSource ... certSources) {
        this.trustedCertSources = new ListCertificateSource();
        this.addTrustedCertSources(certSources);
    }

    @Override
    public void addTrustedCertSources(CertificateSource ... certSources) {
        for (CertificateSource certificateSource : certSources) {
            if (!certificateSource.getCertificateSourceType().isTrusted()) {
                throw new DSSException(String.format("The certificateSource with type [%s] is not allowed in the trustedCertSources. Please, use CertificateSource with a type TRUSTED_STORE or TRUSTED_LIST.", new Object[]{certificateSource.getCertificateSourceType()}));
            }
            this.trustedCertSources.add(certificateSource);
        }
    }

    @Override
    public void setTrustedCertSources(ListCertificateSource trustedListCertificateSource) {
        if (trustedListCertificateSource == null) {
            this.trustedCertSources = new ListCertificateSource();
        } else if (trustedListCertificateSource.areAllCertSourcesTrusted()) {
            this.trustedCertSources = trustedListCertificateSource;
        } else {
            throw new DSSException(String.format("The trusted ListCertificateSource must contain only trusted sources with a type TRUSTED_STORE or TRUSTED_LIST.", new Object[0]));
        }
    }

    @Override
    public ListCertificateSource getAdjunctCertSources() {
        return this.adjunctCertSources;
    }

    @Override
    @Deprecated
    public void setAdjunctCertSource(CertificateSource adjunctCertSource) {
        Objects.requireNonNull(adjunctCertSource, "CertificateSource cannot be null!");
        this.addAdjunctCertSources(adjunctCertSource);
    }

    @Override
    public void setAdjunctCertSources(CertificateSource ... certSources) {
        this.adjunctCertSources = new ListCertificateSource();
        this.addAdjunctCertSources(certSources);
    }

    @Override
    public void addAdjunctCertSources(CertificateSource ... certSources) {
        for (CertificateSource certificateSource : certSources) {
            this.assertNotTrusted(certificateSource);
            this.adjunctCertSources.add(certificateSource);
        }
    }

    @Override
    public void setAdjunctCertSources(ListCertificateSource adjunctListCertificateSource) {
        if (adjunctListCertificateSource == null) {
            adjunctListCertificateSource = new ListCertificateSource();
        }
        for (CertificateSource certificateSource : adjunctListCertificateSource.getSources()) {
            this.assertNotTrusted(certificateSource);
        }
        this.adjunctCertSources = adjunctListCertificateSource;
    }

    private void assertNotTrusted(CertificateSource adjunctCertificateSource) {
        if (adjunctCertificateSource.getCertificateSourceType().isTrusted()) {
            LOG.warn("Adjunct certificate sources shouldn't be trusted. An adjunct certificate source contains missing intermediate certificates");
        }
    }

    @Override
    public DataLoader getDataLoader() {
        return this.dataLoader;
    }

    @Override
    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    @Override
    public ListRevocationSource<CRL> getSignatureCRLSource() {
        return this.signatureCRLSource;
    }

    @Override
    public void setSignatureCRLSource(ListRevocationSource<CRL> signatureCRLSource) {
        this.signatureCRLSource = signatureCRLSource;
    }

    @Override
    public ListRevocationSource<OCSP> getSignatureOCSPSource() {
        return this.signatureOCSPSource;
    }

    @Override
    public void setSignatureOCSPSource(ListRevocationSource<OCSP> signatureOCSPSource) {
        this.signatureOCSPSource = signatureOCSPSource;
    }

    @Override
    public ListCertificateSource getSignatureCertificateSource() {
        return this.signatureCertificateSource;
    }

    @Override
    public void setSignatureCertificateSource(ListCertificateSource signatureCertificateSource) {
        this.signatureCertificateSource = signatureCertificateSource;
    }

    @Override
    public StatusAlert getAlertOnInvalidTimestamp() {
        return this.alertOnInvalidTimestamp;
    }

    @Override
    public void setAlertOnInvalidTimestamp(StatusAlert alertOnInvalidTimestamp) {
        Objects.requireNonNull(alertOnInvalidTimestamp);
        this.alertOnInvalidTimestamp = alertOnInvalidTimestamp;
    }

    @Override
    public StatusAlert getAlertOnMissingRevocationData() {
        return this.alertOnMissingRevocationData;
    }

    @Override
    public void setAlertOnMissingRevocationData(StatusAlert alertOnMissingRevocationData) {
        Objects.requireNonNull(alertOnMissingRevocationData);
        this.alertOnMissingRevocationData = alertOnMissingRevocationData;
    }

    @Override
    public StatusAlert getAlertOnUncoveredPOE() {
        return this.alertOnUncoveredPOE;
    }

    @Override
    public void setAlertOnUncoveredPOE(StatusAlert alertOnUncoveredPOE) {
        Objects.requireNonNull(alertOnUncoveredPOE);
        this.alertOnUncoveredPOE = alertOnUncoveredPOE;
    }

    @Override
    public StatusAlert getAlertOnRevokedCertificate() {
        return this.alertOnRevokedCertificate;
    }

    @Override
    public void setAlertOnRevokedCertificate(StatusAlert alertOnRevokedCertificate) {
        Objects.requireNonNull(alertOnRevokedCertificate);
        this.alertOnRevokedCertificate = alertOnRevokedCertificate;
    }

    @Override
    public StatusAlert getAlertOnNoRevocationAfterBestSignatureTime() {
        return this.alertOnNoRevocationAfterBestSignatureTime;
    }

    @Override
    public void setAlertOnNoRevocationAfterBestSignatureTime(StatusAlert alertOnNoRevocationAfterBestSignatureTime) {
        Objects.requireNonNull(alertOnNoRevocationAfterBestSignatureTime);
        this.alertOnNoRevocationAfterBestSignatureTime = alertOnNoRevocationAfterBestSignatureTime;
    }

    @Override
    public boolean isCheckRevocationForUntrustedChains() {
        return this.checkRevocationForUntrustedChains;
    }

    @Override
    public void setCheckRevocationForUntrustedChains(boolean checkRevocationForUntrustedChains) {
        this.checkRevocationForUntrustedChains = checkRevocationForUntrustedChains;
    }

    @Override
    public void setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.defaultDigestAlgorithm = digestAlgorithm;
    }

    @Override
    public DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }
}

