/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRevocationInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.OrphanCertificateWrapper;
import eu.europa.esig.dss.diagnostic.OrphanRevocationWrapper;
import eu.europa.esig.dss.diagnostic.OrphanTokenWrapper;
import eu.europa.esig.dss.diagnostic.RelatedCertificateWrapper;
import eu.europa.esig.dss.diagnostic.RelatedRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationRefWrappper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.SignerDataWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCommitmentTypeIndication;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignaturePolicyType;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.validationreport.enums.ConstraintStatus;
import eu.europa.esig.validationreport.enums.ObjectType;
import eu.europa.esig.validationreport.enums.SignatureValidationProcessID;
import eu.europa.esig.validationreport.enums.TypeOfProof;
import eu.europa.esig.validationreport.jaxb.AttributeBaseType;
import eu.europa.esig.validationreport.jaxb.CertificateChainType;
import eu.europa.esig.validationreport.jaxb.ConstraintStatusType;
import eu.europa.esig.validationreport.jaxb.CryptoInformationType;
import eu.europa.esig.validationreport.jaxb.IndividualValidationConstraintReportType;
import eu.europa.esig.validationreport.jaxb.ObjectFactory;
import eu.europa.esig.validationreport.jaxb.POEProvisioningType;
import eu.europa.esig.validationreport.jaxb.POEType;
import eu.europa.esig.validationreport.jaxb.RevocationStatusInformationType;
import eu.europa.esig.validationreport.jaxb.SACRLIDType;
import eu.europa.esig.validationreport.jaxb.SACertIDListType;
import eu.europa.esig.validationreport.jaxb.SACertIDType;
import eu.europa.esig.validationreport.jaxb.SACommitmentTypeIndicationType;
import eu.europa.esig.validationreport.jaxb.SAContactInfoType;
import eu.europa.esig.validationreport.jaxb.SACounterSignatureType;
import eu.europa.esig.validationreport.jaxb.SADSSType;
import eu.europa.esig.validationreport.jaxb.SADataObjectFormatType;
import eu.europa.esig.validationreport.jaxb.SAFilterType;
import eu.europa.esig.validationreport.jaxb.SAMessageDigestType;
import eu.europa.esig.validationreport.jaxb.SANameType;
import eu.europa.esig.validationreport.jaxb.SAOCSPIDType;
import eu.europa.esig.validationreport.jaxb.SAOneSignerRoleType;
import eu.europa.esig.validationreport.jaxb.SAReasonType;
import eu.europa.esig.validationreport.jaxb.SARevIDListType;
import eu.europa.esig.validationreport.jaxb.SASigPolicyIdentifierType;
import eu.europa.esig.validationreport.jaxb.SASignatureProductionPlaceType;
import eu.europa.esig.validationreport.jaxb.SASignerRoleType;
import eu.europa.esig.validationreport.jaxb.SASigningTimeType;
import eu.europa.esig.validationreport.jaxb.SASubFilterType;
import eu.europa.esig.validationreport.jaxb.SATimestampType;
import eu.europa.esig.validationreport.jaxb.SAVRIType;
import eu.europa.esig.validationreport.jaxb.SignatureAttributesType;
import eu.europa.esig.validationreport.jaxb.SignatureIdentifierType;
import eu.europa.esig.validationreport.jaxb.SignatureQualityType;
import eu.europa.esig.validationreport.jaxb.SignatureReferenceType;
import eu.europa.esig.validationreport.jaxb.SignatureValidationProcessType;
import eu.europa.esig.validationreport.jaxb.SignatureValidationReportType;
import eu.europa.esig.validationreport.jaxb.SignerInformationType;
import eu.europa.esig.validationreport.jaxb.SignersDocumentType;
import eu.europa.esig.validationreport.jaxb.VOReferenceType;
import eu.europa.esig.validationreport.jaxb.ValidationConstraintsEvaluationReportType;
import eu.europa.esig.validationreport.jaxb.ValidationObjectListType;
import eu.europa.esig.validationreport.jaxb.ValidationObjectRepresentationType;
import eu.europa.esig.validationreport.jaxb.ValidationObjectType;
import eu.europa.esig.validationreport.jaxb.ValidationReportDataType;
import eu.europa.esig.validationreport.jaxb.ValidationReportType;
import eu.europa.esig.validationreport.jaxb.ValidationStatusType;
import eu.europa.esig.validationreport.jaxb.ValidationTimeInfoType;
import eu.europa.esig.xades.jaxb.xades132.DigestAlgAndValueType;
import eu.europa.esig.xmldsig.jaxb.DigestMethodType;
import eu.europa.esig.xmldsig.jaxb.SignatureValueType;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;

public class ETSIValidationReportBuilder {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final Date currentTime;
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;

    public ETSIValidationReportBuilder(Date currentTime, DiagnosticData diagnosticData, DetailedReport detailedReport) {
        this.currentTime = currentTime;
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
    }

    public ValidationReportType build() {
        ValidationReportType result = this.objectFactory.createValidationReportType();
        if (!this.diagnosticData.getSignatures().isEmpty()) {
            for (SignatureWrapper sigWrapper : this.diagnosticData.getSignatures()) {
                result.getSignatureValidationReport().add(this.getSignatureValidationReport(sigWrapper));
            }
        } else {
            result.getSignatureValidationReport().add(this.noSignatureFoundReport());
        }
        ValidationObjectListType signatureValidationObjects = this.getSignatureValidationObjects();
        if (!signatureValidationObjects.getValidationObject().isEmpty()) {
            result.setSignatureValidationObjects(signatureValidationObjects);
        }
        return result;
    }

    private SignatureValidationReportType getSignatureValidationReport(SignatureWrapper sigWrapper) {
        SignatureValidationReportType signatureValidationReport = this.objectFactory.createSignatureValidationReportType();
        signatureValidationReport.setSignatureIdentifier(this.getSignatureIdentifier(sigWrapper));
        this.getSignersDocuments(signatureValidationReport, sigWrapper);
        SignatureAttributesType signatureAttributes = this.getSignatureAttributes(sigWrapper);
        if (!signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().isEmpty()) {
            signatureValidationReport.setSignatureAttributes(signatureAttributes);
        }
        signatureValidationReport.setSignerInformation(this.getSignerInformation(sigWrapper));
        signatureValidationReport.setSignatureQuality(this.getSignatureQuality(sigWrapper));
        signatureValidationReport.setSignatureValidationProcess(this.getSignatureValidationProcess(sigWrapper));
        signatureValidationReport.setSignatureValidationStatus(this.getSignatureValidationStatus(sigWrapper));
        signatureValidationReport.setValidationTimeInfo(this.getValidationTimeInfo(sigWrapper));
        signatureValidationReport.setValidationConstraintsEvaluationReport(this.getValidationConstraintsEvaluationReport(sigWrapper));
        return signatureValidationReport;
    }

    private SignatureValidationReportType noSignatureFoundReport() {
        SignatureValidationReportType signatureValidationReport = this.objectFactory.createSignatureValidationReportType();
        signatureValidationReport.setSignatureValidationStatus(this.noSignatureFoundValidationStatus());
        return signatureValidationReport;
    }

    private ValidationStatusType noSignatureFoundValidationStatus() {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        validationStatus.setMainIndication(Indication.NO_SIGNATURE_FOUND);
        return validationStatus;
    }

    private ValidationConstraintsEvaluationReportType getValidationConstraintsEvaluationReport(AbstractTokenProxy token) {
        ValidationConstraintsEvaluationReportType validationConstraintsEvaluationReport = this.objectFactory.createValidationConstraintsEvaluationReportType();
        XmlBasicBuildingBlocks bbbResults = this.detailedReport.getBasicBuildingBlockById(token.getId());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.FORMAT_CHECKING, bbbResults.getFC());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.IDENTIFICATION_OF_THE_SIGNING_CERTIFICATE, bbbResults.getISC());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.VALIDATION_CONTEXT_INITIALIZATION, bbbResults.getVCI());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.CRYPTOGRAPHIC_VERIFICATION, bbbResults.getCV());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.SIGNATURE_ACCEPTANCE_VALIDATION, bbbResults.getSAV());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.X509_CERTIFICATE_VALIDATION, bbbResults.getXCV());
        if (token instanceof SignatureWrapper || token instanceof TimestampWrapper) {
            this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.PAST_SIGNATURE_VALIDATION, bbbResults.getPSV());
            this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.PAST_CERTIFICATE_VALIDATION, bbbResults.getPCV());
            this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.VALIDATION_TIME_SLIDING, bbbResults.getVTS());
        }
        return validationConstraintsEvaluationReport;
    }

    private void addBBB(ValidationConstraintsEvaluationReportType validationConstraintsEvaluationReport, BasicBuildingBlockDefinition bbbUri, XmlConstraintsConclusion constraintConclusion) {
        if (constraintConclusion != null) {
            validationConstraintsEvaluationReport.getValidationConstraint().add(this.getIndividualValidationConstraintReport(bbbUri, constraintConclusion, this.applied()));
        } else {
            validationConstraintsEvaluationReport.getValidationConstraint().add(this.getIndividualValidationConstraintReport(bbbUri, constraintConclusion, this.disabled()));
        }
    }

    private IndividualValidationConstraintReportType getIndividualValidationConstraintReport(BasicBuildingBlockDefinition bbbUri, XmlConstraintsConclusion constraintConclusion, ConstraintStatusType constraintStatusType) {
        IndividualValidationConstraintReportType validationConstraint = this.objectFactory.createIndividualValidationConstraintReportType();
        validationConstraint.setValidationConstraintIdentifier(bbbUri.getUri());
        validationConstraint.setConstraintStatus(constraintStatusType);
        if (constraintConclusion != null) {
            validationConstraint.setValidationStatus(this.getValidationStatus(constraintConclusion.getConclusion()));
        }
        return validationConstraint;
    }

    private ConstraintStatusType applied() {
        return this.constraintStatus(ConstraintStatus.APPLIED);
    }

    private ConstraintStatusType disabled() {
        return this.constraintStatus(ConstraintStatus.DISABLED);
    }

    private ConstraintStatusType constraintStatus(ConstraintStatus status) {
        ConstraintStatusType constraintStatus = this.objectFactory.createConstraintStatusType();
        constraintStatus.setStatus(status);
        return constraintStatus;
    }

    private SignatureValidationReportType getValidationReport(AbstractTokenProxy token) {
        XmlBasicBuildingBlocks tokenBBB = this.detailedReport.getBasicBuildingBlockById(token.getId());
        if (tokenBBB == null) {
            return null;
        }
        SignatureValidationReportType signatureValidationReport = this.objectFactory.createSignatureValidationReportType();
        signatureValidationReport.setSignerInformation(this.getSignerInformation(token));
        signatureValidationReport.setSignatureValidationStatus(this.getValidationStatus(token));
        signatureValidationReport.setValidationConstraintsEvaluationReport(this.getValidationConstraintsEvaluationReport(token));
        TimestampQualification timestampQualification = this.detailedReport.getTimestampQualification(token.getId());
        if (timestampQualification != null) {
            SignatureQualityType signatureQualityType = this.objectFactory.createSignatureQualityType();
            signatureQualityType.getSignatureQualityInformation().add(timestampQualification.getUri());
            signatureValidationReport.setSignatureQuality(signatureQualityType);
        }
        return signatureValidationReport;
    }

    private ValidationTimeInfoType getValidationTimeInfo(SignatureWrapper sigWrapper) {
        ValidationTimeInfoType validationTimeInfoType = this.objectFactory.createValidationTimeInfoType();
        validationTimeInfoType.setValidationTime(this.currentTime);
        XmlProofOfExistence proofOfExistence = this.detailedReport.getBestProofOfExistence(sigWrapper.getId());
        POEType poeType = new POEType();
        poeType.setPOETime(proofOfExistence.getTime());
        poeType.setTypeOfProof(TypeOfProof.VALIDATION);
        String timestampId = proofOfExistence.getTimestampId();
        if (Utils.isStringNotEmpty(timestampId)) {
            poeType.setPOEObject(this.getVOReference(timestampId));
        }
        validationTimeInfoType.setBestSignatureTime(poeType);
        return validationTimeInfoType;
    }

    private SignerInformationType getSignerInformation(AbstractTokenProxy token) {
        CertificateWrapper signingCert = token.getSigningCertificate();
        if (signingCert == null) {
            return null;
        }
        SignerInformationType signerInfo = this.objectFactory.createSignerInformationType();
        XmlStatus pseudoUseStatus = this.getPseudoUseStatus(token);
        if (pseudoUseStatus != null) {
            signerInfo.setPseudonym(this.isPseudoUse(pseudoUseStatus));
        }
        signerInfo.setSigner(signingCert.getReadableCertificateName());
        signerInfo.setSignerCertificate(this.getVOReference(signingCert.getId()));
        return signerInfo;
    }

    private XmlStatus getPseudoUseStatus(AbstractTokenProxy token) {
        XmlSubXCV signingCertificateXCV = this.detailedReport.getSigningCertificate(token.getId());
        if (signingCertificateXCV != null) {
            List<XmlConstraint> constraints = signingCertificateXCV.getConstraint();
            for (XmlConstraint xmlConstraint : constraints) {
                if (!"BBB_XCV_PSEUDO_USE".equals(xmlConstraint.getName().getNameId())) continue;
                XmlStatus status = xmlConstraint.getStatus();
                return status;
            }
        }
        return null;
    }

    private Boolean isPseudoUse(XmlStatus status) {
        return XmlStatus.OK != status && XmlStatus.IGNORED != status;
    }

    private SignatureQualityType getSignatureQuality(SignatureWrapper signatureWrapper) {
        SignatureQualification signatureQualification = this.detailedReport.getSignatureQualification(signatureWrapper.getId());
        if (signatureQualification != null) {
            SignatureQualityType signatureQualityType = this.objectFactory.createSignatureQualityType();
            signatureQualityType.getSignatureQualityInformation().add(signatureQualification.getUri());
            return signatureQualityType;
        }
        return null;
    }

    private VOReferenceType getVOReference(String id) {
        return this.getVOReference(Arrays.asList(id));
    }

    private VOReferenceType getVOReference(List<String> ids) {
        VOReferenceType voRef = this.objectFactory.createVOReferenceType();
        for (String id : ids) {
            ValidationObjectType validationObject = this.objectFactory.createValidationObjectType();
            validationObject.setId(id);
            voRef.getVOReference().add(validationObject);
        }
        return voRef;
    }

    private SignatureValidationProcessType getSignatureValidationProcess(SignatureWrapper sigWrapper) {
        SignatureValidationProcessType validationProcess = this.objectFactory.createSignatureValidationProcessType();
        validationProcess.setSignatureValidationProcessID(this.getCurrentProcessId(sigWrapper));
        return validationProcess;
    }

    private SignatureValidationProcessID getCurrentProcessId(SignatureWrapper sigWrapper) {
        SignatureValidationProcessID processId = SignatureValidationProcessID.BASIC;
        Indication indicationLTA = this.detailedReport.getArchiveDataValidationIndication(sigWrapper.getId());
        Indication indicationLTVM = this.detailedReport.getLongTermValidationIndication(sigWrapper.getId());
        if (indicationLTA != null) {
            processId = SignatureValidationProcessID.LTA;
        } else if (indicationLTVM != null) {
            processId = SignatureValidationProcessID.LTVM;
        }
        return processId;
    }

    private ValidationObjectListType getSignatureValidationObjects() {
        ValidationObjectListType validationObjectListType = this.objectFactory.createValidationObjectListType();
        POEExtraction poeExtraction = new POEExtraction();
        poeExtraction.init(this.diagnosticData, this.currentTime);
        poeExtraction.collectAllPOE(this.diagnosticData.getTimestampSet());
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampSet()) {
            this.addTimestamp(validationObjectListType, timestamp);
        }
        for (CertificateWrapper certificate : this.diagnosticData.getUsedCertificates()) {
            this.addCertificate(validationObjectListType, certificate, poeExtraction);
        }
        for (OrphanCertificateWrapper orphanCertificate : this.diagnosticData.getAllOrphanCertificateObjects()) {
            this.addOrphanCertificate(validationObjectListType, orphanCertificate, poeExtraction);
        }
        for (RevocationWrapper revocationData : this.diagnosticData.getAllRevocationData()) {
            this.addRevocationData(validationObjectListType, revocationData, poeExtraction);
        }
        for (OrphanRevocationWrapper orphanRevocation : this.diagnosticData.getAllOrphanRevocationObjects()) {
            this.addOrphanRevocation(validationObjectListType, orphanRevocation, poeExtraction);
        }
        for (SignerDataWrapper signedData : this.diagnosticData.getOriginalSignerDocuments()) {
            this.addSignerData(validationObjectListType, signedData, poeExtraction);
        }
        return validationObjectListType;
    }

    private void addCertificate(ValidationObjectListType validationObjectListType, CertificateWrapper certificate, POEExtraction poeExtraction) {
        ValidationObjectType validationObject = this.objectFactory.createValidationObjectType();
        validationObject.setId(certificate.getId());
        validationObject.setObjectType(ObjectType.CERTIFICATE);
        ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
        if (Utils.isArrayNotEmpty(certificate.getBinaries())) {
            representation.setBase64(certificate.getBinaries());
        } else {
            representation.setDigestAlgAndValue(this.getDigestAlgAndValueType(certificate.getDigestAlgoAndValue()));
        }
        validationObject.setValidationObjectRepresentation(representation);
        validationObject.setPOE(this.getPOE(certificate.getId(), poeExtraction));
        validationObjectListType.getValidationObject().add(validationObject);
    }

    private DigestAlgAndValueType getDigestAlgAndValueType(XmlDigestAlgoAndValue xmlDigestAlgoAndValue) {
        return this.getDigestAlgAndValueType(xmlDigestAlgoAndValue.getDigestMethod(), xmlDigestAlgoAndValue.getDigestValue());
    }

    private DigestAlgAndValueType getDigestAlgAndValueType(DigestAlgorithm digestAlgo, byte[] digestValue) {
        DigestAlgAndValueType digestAlgAndValueType = new DigestAlgAndValueType();
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(digestAlgo.getUri());
        digestAlgAndValueType.setDigestMethod(digestMethodType);
        digestAlgAndValueType.setDigestValue(digestValue);
        return digestAlgAndValueType;
    }

    private POEType getPOE(String tokenId, POEExtraction poeExtraction) {
        POEType poeType = this.objectFactory.createPOEType();
        POE lowestPOE = poeExtraction.getLowestPOE(tokenId);
        poeType.setPOETime(lowestPOE.getTime());
        if (lowestPOE.isTimestampPoe()) {
            poeType.setPOEObject(this.getVOReference(lowestPOE.getTimestampId()));
        }
        poeType.setTypeOfProof(TypeOfProof.VALIDATION);
        return poeType;
    }

    private void addTimestamp(ValidationObjectListType validationObjectListType, TimestampWrapper timestamp) {
        ValidationObjectType validationObject = this.objectFactory.createValidationObjectType();
        validationObject.setId(timestamp.getId());
        validationObject.setObjectType(ObjectType.TIMESTAMP);
        ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
        if (Utils.isArrayNotEmpty(timestamp.getBinaries())) {
            representation.setBase64(timestamp.getBinaries());
        } else {
            representation.setDigestAlgAndValue(this.getDigestAlgAndValueType(timestamp.getDigestAlgoAndValue()));
        }
        validationObject.setValidationObjectRepresentation(representation);
        validationObject.setPOEProvisioning(this.getPOEProvisioningType(timestamp));
        validationObject.setValidationReport(this.getValidationReport(timestamp));
        validationObjectListType.getValidationObject().add(validationObject);
    }

    private POEProvisioningType getPOEProvisioningType(TimestampWrapper timestamp) {
        POEProvisioningType poeProvisioning = this.objectFactory.createPOEProvisioningType();
        poeProvisioning.setPOETime(timestamp.getProductionTime());
        for (CertificateWrapper certificateWrapper : timestamp.getTimestampedCertificates()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(certificateWrapper.getId()));
        }
        List<OrphanCertificateWrapper> allOrphanObjectCertificates = this.diagnosticData.getAllOrphanCertificateObjects();
        for (OrphanTokenWrapper orphanTokenWrapper : timestamp.getTimestampedOrphanCertificates()) {
            if (!allOrphanObjectCertificates.contains(orphanTokenWrapper)) continue;
            poeProvisioning.getValidationObject().add(this.getVOReference(orphanTokenWrapper.getId()));
        }
        for (RevocationWrapper revocationWrapper : timestamp.getTimestampedRevocations()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(revocationWrapper.getId()));
        }
        List<OrphanRevocationWrapper> list = this.diagnosticData.getAllOrphanRevocationObjects();
        for (OrphanTokenWrapper orphanRevocation : timestamp.getTimestampedOrphanRevocations()) {
            if (!list.contains(orphanRevocation)) continue;
            poeProvisioning.getValidationObject().add(this.getVOReference(orphanRevocation.getId()));
        }
        for (TimestampWrapper tst : timestamp.getTimestampedTimestamps()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(tst.getId()));
        }
        for (SignerDataWrapper signerData : timestamp.getTimestampedSignedData()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(signerData.getId()));
        }
        List<SignatureWrapper> list2 = timestamp.getTimestampedSignatures();
        for (SignatureWrapper timestampedSignature : list2) {
            poeProvisioning.getSignatureReference().add(this.getSignatureReference(timestampedSignature));
        }
        return poeProvisioning;
    }

    private SignatureReferenceType getSignatureReference(SignatureWrapper signature) {
        SignatureReferenceType signatureReference = this.objectFactory.createSignatureReferenceType();
        XmlSignatureDigestReference signatureDigestReference = signature.getSignatureDigestReference();
        if (signatureDigestReference != null) {
            signatureReference.setCanonicalizationMethod(signatureDigestReference.getCanonicalizationMethod());
            signatureReference.setDigestMethod(signatureDigestReference.getDigestMethod().getUri());
            signatureReference.setDigestValue(signatureDigestReference.getDigestValue());
        } else if (signature.getFirstFieldName() != null) {
            signatureReference.setPAdESFieldName(signature.getFirstFieldName());
        }
        return signatureReference;
    }

    private void addSignerData(ValidationObjectListType validationObjectListType, SignerDataWrapper signedData, POEExtraction poeExtraction) {
        ValidationObjectType validationObject = this.objectFactory.createValidationObjectType();
        validationObject.setId(signedData.getId());
        validationObject.setObjectType(ObjectType.SIGNED_DATA);
        ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
        representation.setDigestAlgAndValue(this.getDigestAlgAndValueType(signedData.getDigestAlgoAndValue()));
        validationObject.setValidationObjectRepresentation(representation);
        validationObject.setPOE(this.getPOE(signedData.getId(), poeExtraction));
        validationObjectListType.getValidationObject().add(validationObject);
    }

    private void addRevocationData(ValidationObjectListType validationObjectListType, RevocationWrapper revocationData, POEExtraction poeExtraction) {
        ValidationObjectType validationObject = this.objectFactory.createValidationObjectType();
        validationObject.setId(revocationData.getId());
        if (RevocationType.CRL.equals((Object)revocationData.getRevocationType())) {
            validationObject.setObjectType(ObjectType.CRL);
        } else {
            validationObject.setObjectType(ObjectType.OCSP_RESPONSE);
        }
        ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
        if (Utils.isArrayNotEmpty(revocationData.getBinaries())) {
            representation.setBase64(revocationData.getBinaries());
        } else {
            representation.setDigestAlgAndValue(this.getDigestAlgAndValueType(revocationData.getDigestAlgoAndValue()));
        }
        validationObject.setValidationObjectRepresentation(representation);
        validationObject.setPOE(this.getPOE(revocationData.getId(), poeExtraction));
        validationObject.setValidationReport(this.getValidationReport(revocationData));
        validationObjectListType.getValidationObject().add(validationObject);
    }

    private void addOrphanRevocation(ValidationObjectListType validationObjectListType, OrphanRevocationWrapper orphanRevocation, POEExtraction poeExtraction) {
        ValidationObjectType validationObject = this.createOrphanToken(orphanRevocation, poeExtraction);
        if (RevocationType.CRL.equals((Object)orphanRevocation.getRevocationType())) {
            validationObject.setObjectType(ObjectType.CRL);
        } else {
            validationObject.setObjectType(ObjectType.OCSP_RESPONSE);
        }
        validationObjectListType.getValidationObject().add(validationObject);
    }

    private void addOrphanCertificate(ValidationObjectListType validationObjectListType, OrphanCertificateWrapper orphanCertificate, POEExtraction poeExtraction) {
        ValidationObjectType orphanCertificateToken = this.createOrphanToken(orphanCertificate, poeExtraction);
        orphanCertificateToken.setObjectType(ObjectType.CERTIFICATE);
        validationObjectListType.getValidationObject().add(orphanCertificateToken);
    }

    private ValidationObjectType createOrphanToken(OrphanTokenWrapper orphanToken, POEExtraction poeExtraction) {
        ValidationObjectType validationObject = this.objectFactory.createValidationObjectType();
        validationObject.setId(orphanToken.getId());
        ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
        if (Utils.isArrayNotEmpty(orphanToken.getBinaries())) {
            representation.setBase64(orphanToken.getBinaries());
        } else {
            representation.setDigestAlgAndValue(this.getDigestAlgAndValueType(orphanToken.getDigestAlgoAndValue()));
        }
        validationObject.setValidationObjectRepresentation(representation);
        validationObject.setPOE(this.getPOE(orphanToken.getId(), poeExtraction));
        return validationObject;
    }

    private ValidationStatusType getSignatureValidationStatus(SignatureWrapper signature) {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        Indication indication = this.detailedReport.getHighestIndication(signature.getId());
        if (indication != null) {
            this.fillIndication(validationStatus, indication);
            SubIndication subIndication = this.detailedReport.getHighestSubIndication(signature.getId());
            if (subIndication != null) {
                validationStatus.getSubIndication().add(subIndication);
            }
        }
        this.addValidationReportData(validationStatus, signature);
        return validationStatus;
    }

    private void fillIndication(ValidationStatusType validationStatus, Indication indication) {
        switch (indication) {
            case PASSED: {
                validationStatus.setMainIndication(Indication.TOTAL_PASSED);
                break;
            }
            case FAILED: {
                validationStatus.setMainIndication(Indication.TOTAL_FAILED);
                break;
            }
            case INDETERMINATE: {
                validationStatus.setMainIndication(Indication.INDETERMINATE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported indication : " + indication);
            }
        }
    }

    private ValidationStatusType getValidationStatus(AbstractTokenProxy token) {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        this.fillIndicationSubIndication(validationStatus, this.detailedReport.getBasicBuildingBlocksIndication(token.getId()), this.detailedReport.getBasicBuildingBlocksSubIndication(token.getId()));
        this.addValidationReportData(validationStatus, token);
        return validationStatus;
    }

    private ValidationStatusType getValidationStatus(XmlConclusion conclusion) {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        this.fillIndicationSubIndication(validationStatus, conclusion.getIndication(), conclusion.getSubIndication());
        return validationStatus;
    }

    private void fillIndicationSubIndication(ValidationStatusType validationStatus, Indication indication, SubIndication subIndication) {
        if (indication != null) {
            validationStatus.setMainIndication(indication);
        }
        if (subIndication != null) {
            validationStatus.getSubIndication().add(subIndication);
        }
    }

    private void addValidationReportData(ValidationStatusType validationStatus, AbstractTokenProxy token) {
        XmlBasicBuildingBlocks basicBuildingBlock = this.detailedReport.getBasicBuildingBlockById(token.getId());
        XmlSubXCV signingCertificate = this.detailedReport.getSigningCertificate(token.getId());
        if (basicBuildingBlock != null || signingCertificate != null) {
            ValidationReportDataType validationReportData = this.objectFactory.createValidationReportDataType();
            if (basicBuildingBlock != null) {
                XmlSAV sav;
                XmlCertificateChain certificateChain = basicBuildingBlock.getCertificateChain();
                if (certificateChain != null) {
                    this.fillCertificateChainAndTrustAnchor(validationReportData, certificateChain);
                }
                if ((sav = basicBuildingBlock.getSAV()) != null && sav.getCryptographicInfo() != null) {
                    this.fillCryptographicInfo(validationReportData, token.getId(), sav.getCryptographicInfo());
                }
            }
            if (signingCertificate != null && signingCertificate.getRevocationInfo() != null) {
                this.fillRevocationInfo(validationReportData, signingCertificate.getRevocationInfo());
            }
            validationStatus.getAssociatedValidationReportData().add(validationReportData);
        }
    }

    private void fillCryptographicInfo(ValidationReportDataType validationReportData, String tokenId, XmlCryptographicInformation cryptographicInfo) {
        CryptoInformationType cryptoInformationType = this.objectFactory.createCryptoInformationType();
        cryptoInformationType.setValidationObjectId(this.getVOReference(tokenId));
        cryptoInformationType.setAlgorithm(cryptographicInfo.getAlgorithm());
        cryptoInformationType.setSecureAlgorithm(cryptographicInfo.isSecure());
        cryptoInformationType.setNotAfter(cryptographicInfo.getNotAfter());
        validationReportData.setCryptoInformation(cryptoInformationType);
    }

    private void fillRevocationInfo(ValidationReportDataType validationReportData, XmlRevocationInformation revocationInfo) {
        RevocationStatusInformationType revocationStatusInformationType = this.objectFactory.createRevocationStatusInformationType();
        revocationStatusInformationType.setRevocationTime(revocationInfo.getRevocationDate());
        revocationStatusInformationType.setRevocationObject(this.getVOReference(revocationInfo.getRevocationId()));
        revocationStatusInformationType.setValidationObjectId(this.getVOReference(revocationInfo.getCertificateId()));
        if (revocationInfo.getReason() != null) {
            revocationStatusInformationType.setRevocationReason(revocationInfo.getReason());
        }
        validationReportData.setRevocationStatusInformation(revocationStatusInformationType);
    }

    private void fillCertificateChainAndTrustAnchor(ValidationReportDataType validationReportData, XmlCertificateChain certificateChain) {
        List<XmlChainItem> chainItem = certificateChain.getChainItem();
        if (Utils.isCollectionEmpty(chainItem)) {
            return;
        }
        CertificateChainType certificateChainType = this.objectFactory.createCertificateChainType();
        VOReferenceType signingCert = null;
        VOReferenceType trustAnchor = null;
        for (int i = 0; i < chainItem.size(); ++i) {
            XmlChainItem currentChainItem = chainItem.get(i);
            VOReferenceType currentVORef = this.getVOReference(currentChainItem.getId());
            CertificateSourceType source = currentChainItem.getSource();
            boolean isSigningCert = i == 0;
            boolean isTrustAnchor = this.isTrustAnchor(source);
            if (isSigningCert || isTrustAnchor) {
                if (isSigningCert) {
                    signingCert = currentVORef;
                }
                if (!isTrustAnchor) continue;
                trustAnchor = currentVORef;
                break;
            }
            certificateChainType.getIntermediateCertificate().add(currentVORef);
        }
        certificateChainType.setSigningCertificate(signingCert);
        certificateChainType.setTrustAnchor(trustAnchor);
        validationReportData.setCertificateChain(certificateChainType);
        validationReportData.setTrustAnchor(trustAnchor);
    }

    private boolean isTrustAnchor(CertificateSourceType source) {
        return CertificateSourceType.TRUSTED_LIST.equals((Object)source) || CertificateSourceType.TRUSTED_STORE.equals((Object)source);
    }

    private SignatureIdentifierType getSignatureIdentifier(SignatureWrapper sigWrapper) {
        SignatureIdentifierType sigId = this.objectFactory.createSignatureIdentifierType();
        sigId.setId(sigWrapper.getId());
        sigId.setDAIdentifier(sigWrapper.getDAIdentifier());
        sigId.setDocHashOnly(sigWrapper.isDocHashOnly());
        sigId.setHashOnly(sigWrapper.isHashOnly());
        sigId.setDigestAlgAndValue(this.getDTBSRDigestAlgAndValue(sigWrapper.getDigestMatchers()));
        SignatureValueType sigValue = new SignatureValueType();
        sigValue.setValue(sigWrapper.getSignatureValue());
        sigId.setSignatureValue(sigValue);
        return sigId;
    }

    private DigestAlgAndValueType getDTBSRDigestAlgAndValue(List<XmlDigestMatcher> digestMatchers) {
        XmlDigestAlgoAndValue digestMatcher = null;
        if (Utils.isCollectionNotEmpty(digestMatchers)) {
            for (XmlDigestMatcher xmlDigestMatcher : digestMatchers) {
                if (digestMatcher != null && !DigestMatcherType.SIGNED_PROPERTIES.equals((Object)xmlDigestMatcher.getType()) && !DigestMatcherType.CONTENT_DIGEST.equals((Object)xmlDigestMatcher.getType()) || xmlDigestMatcher.getDigestMethod() == null || !Utils.isArrayNotEmpty(xmlDigestMatcher.getDigestValue())) continue;
                digestMatcher = xmlDigestMatcher;
            }
        }
        return digestMatcher == null ? null : this.getDigestAlgAndValueType(digestMatcher.getDigestMethod(), digestMatcher.getDigestValue());
    }

    private void getSignersDocuments(SignatureValidationReportType signatureValidationReport, SignatureWrapper sigWrapper) {
        List<XmlSignatureScope> signerData = sigWrapper.getSignatureScopes();
        for (XmlSignatureScope xmlSignatureScope : signerData) {
            SignersDocumentType signersDocumentType = this.objectFactory.createSignersDocumentType();
            signersDocumentType.setDigestAlgAndValue(this.getDigestAlgAndValueType(xmlSignatureScope.getSignerData().getDigestAlgoAndValue()));
            signersDocumentType.setSignersDocumentRef(this.getVOReference(xmlSignatureScope.getSignerData().getId()));
            signatureValidationReport.getSignersDocument().add(signersDocumentType);
        }
    }

    private SignatureAttributesType getSignatureAttributes(SignatureWrapper sigWrapper) {
        SignatureAttributesType sigAttributes = this.objectFactory.createSignatureAttributesType();
        this.addSigningTime(sigAttributes, sigWrapper);
        this.addSigningCertificate(sigAttributes, sigWrapper);
        this.addDataObjectFormat(sigAttributes, sigWrapper);
        this.addCommitmentTypeIndications(sigAttributes, sigWrapper);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.CONTENT_TIMESTAMP);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP);
        this.addSigPolicyIdentifier(sigAttributes, sigWrapper);
        this.addProductionPlace(sigAttributes, sigWrapper);
        this.addSignerRoles(sigAttributes, sigWrapper);
        this.addCounterSignatures(sigAttributes, sigWrapper);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.SIGNATURE_TIMESTAMP);
        this.addCompleteCertificateRefs(sigAttributes, sigWrapper.foundCertificates());
        this.addCompleteRevocationRefs(sigAttributes, sigWrapper.foundRevocations());
        this.addAttributeCertificateRefs(sigAttributes, sigWrapper.foundCertificates());
        this.addAttributeRevocationRefs(sigAttributes, sigWrapper.foundRevocations());
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.VALIDATION_DATA_TIMESTAMP);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
        this.addCertificateValues(sigAttributes, sigWrapper.foundCertificates());
        this.addRevocationValues(sigAttributes, sigWrapper.foundRevocations());
        this.addAttrAuthoritiesCertValues(sigAttributes, sigWrapper.foundCertificates());
        this.addAttributeRevocationValues(sigAttributes, sigWrapper.foundRevocations());
        this.addTimeStampValidationData(sigAttributes, sigWrapper.foundCertificates(), sigWrapper.foundRevocations());
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.ARCHIVE_TIMESTAMP);
        this.addMessageDigest(sigAttributes, sigWrapper);
        this.addDSS(sigAttributes, sigWrapper);
        this.addVRI(sigAttributes, sigWrapper);
        this.addTimestampsByLocation(sigAttributes, sigWrapper, TimestampLocation.DOC_TIMESTAMP);
        this.addReason(sigAttributes, sigWrapper);
        this.addSignerName(sigAttributes, sigWrapper);
        this.addContactInfo(sigAttributes, sigWrapper);
        this.addSubFilter(sigAttributes, sigWrapper);
        this.addSignatureByteRange(sigAttributes, sigWrapper);
        this.addFilter(sigAttributes, sigWrapper);
        return sigAttributes;
    }

    private void addAttrAuthoritiesCertValues(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        ArrayList<String> certIds = new ArrayList<String>();
        certIds.addAll(this.getRelatedCertsIds(foundCertificates.getRelatedCertificatesByOrigin(CertificateOrigin.ATTR_AUTORITIES_CERT_VALUES)));
        certIds.addAll(this.getOrphanCertsIds(foundCertificates.getOrphanCertificatesByOrigin(CertificateOrigin.ATTR_AUTORITIES_CERT_VALUES)));
        if (Utils.isCollectionNotEmpty(certIds)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttrAuthoritiesCertValues(this.buildTokenList(certIds)));
        }
    }

    private void addTimeStampValidationData(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates, FoundRevocationsProxy foundRevocations) {
        ArrayList<String> tokenIds = new ArrayList<String>();
        tokenIds.addAll(this.getRelatedCertsIds(foundCertificates.getRelatedCertificatesByOrigin(CertificateOrigin.TIMESTAMP_VALIDATION_DATA)));
        tokenIds.addAll(this.getOrphanCertsIds(foundCertificates.getOrphanCertificatesByOrigin(CertificateOrigin.TIMESTAMP_VALIDATION_DATA)));
        tokenIds.addAll(this.getRelatedRevocationIds(foundRevocations.getRelatedRevocationsByOrigin(RevocationOrigin.TIMESTAMP_VALIDATION_DATA)));
        tokenIds.addAll(this.getOrphanRevocationIds(foundRevocations.getOrphanRevocationsByOrigin(RevocationOrigin.TIMESTAMP_VALIDATION_DATA)));
        if (Utils.isCollectionNotEmpty(tokenIds)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeTimeStampValidationData(this.buildTokenList(tokenIds)));
        }
    }

    private void addCertificateValues(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        ArrayList<String> certIds = new ArrayList<String>();
        certIds.addAll(this.getRelatedCertsIds(foundCertificates.getRelatedCertificatesByOrigin(CertificateOrigin.CERTIFICATE_VALUES)));
        certIds.addAll(this.getOrphanCertsIds(foundCertificates.getOrphanCertificatesByOrigin(CertificateOrigin.CERTIFICATE_VALUES)));
        if (Utils.isCollectionNotEmpty(certIds)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCertificateValues(this.buildTokenList(certIds)));
        }
    }

    private List<String> getRelatedCertsIds(List<RelatedCertificateWrapper> certs) {
        return certs.stream().map(CertificateWrapper::getId).collect(Collectors.toList());
    }

    private List<String> getOrphanCertsIds(List<OrphanCertificateWrapper> certs) {
        return certs.stream().map(OrphanTokenWrapper::getId).collect(Collectors.toList());
    }

    private List<String> getRelatedRevocationIds(List<RelatedRevocationWrapper> revocations) {
        return revocations.stream().map(RevocationWrapper::getId).collect(Collectors.toList());
    }

    private List<String> getOrphanRevocationIds(List<OrphanRevocationWrapper> revocations) {
        return revocations.stream().map(OrphanTokenWrapper::getId).collect(Collectors.toList());
    }

    private void addAttributeCertificateRefs(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        List<RelatedCertificateWrapper> relatedCerts = foundCertificates.getRelatedCertificatesByRefOrigin(CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
        List<OrphanCertificateWrapper> orphanCerts = foundCertificates.getOrphanCertificatesByRefOrigin(CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
        sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttributeCertificateRefs(this.buildCertIDListType(relatedCerts, orphanCerts)));
    }

    private void addCompleteCertificateRefs(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        List<RelatedCertificateWrapper> relatedCerts = foundCertificates.getRelatedCertificatesByRefOrigin(CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
        List<OrphanCertificateWrapper> orphanCerts = foundCertificates.getOrphanCertificatesByRefOrigin(CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
        sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCompleteCertificateRefs(this.buildCertIDListType(relatedCerts, orphanCerts)));
    }

    private void addSigningCertificate(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        FoundCertificatesProxy foundCertificates = sigWrapper.foundCertificates();
        List<RelatedCertificateWrapper> relatedCerts = foundCertificates.getRelatedCertificatesByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        List<OrphanCertificateWrapper> orphanCerts = foundCertificates.getOrphanCertificatesByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        JAXBElement<SACertIDListType> signingCertAttribute = this.objectFactory.createSignatureAttributesTypeSigningCertificate(this.buildCertIDListType(relatedCerts, orphanCerts));
        if (sigWrapper.isBLevelTechnicallyValid()) {
            signingCertAttribute.getValue().setSigned(true);
        }
        sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(signingCertAttribute);
    }

    private AttributeBaseType buildTokenList(List<String> ids) {
        AttributeBaseType attributeBaseType = this.objectFactory.createAttributeBaseType();
        for (String id : ids) {
            attributeBaseType.getAttributeObject().add(this.getVOReference(id));
        }
        return attributeBaseType;
    }

    private SACertIDListType buildCertIDListType(List<RelatedCertificateWrapper> relatedCerts, List<OrphanCertificateWrapper> orphanCerts) {
        SACertIDListType certIdList = this.objectFactory.createSACertIDListType();
        ArrayList<String> validationObjectIds = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(relatedCerts)) {
            for (CertificateWrapper certificateWrapper : relatedCerts) {
                validationObjectIds.add(certificateWrapper.getId());
            }
        }
        if (Utils.isCollectionNotEmpty(orphanCerts)) {
            List<OrphanCertificateWrapper> allOrphanCertificates = this.diagnosticData.getAllOrphanCertificateObjects();
            for (OrphanCertificateWrapper orphanCert : orphanCerts) {
                if (orphanCert == null) continue;
                if (Utils.isCollectionNotEmpty(orphanCert.getReferences()) && !allOrphanCertificates.contains(orphanCert)) {
                    for (CertificateRefWrapper certRef : orphanCert.getReferences()) {
                        certIdList.getCertID().add(this.buildCertIDType(certRef.getDigestAlgoAndValue(), certRef.getIssuerSerial()));
                    }
                    continue;
                }
                validationObjectIds.add(orphanCert.getId());
            }
        }
        if (Utils.isCollectionNotEmpty(validationObjectIds)) {
            certIdList.getAttributeObject().add(this.getVOReference(validationObjectIds));
        }
        return certIdList;
    }

    private SACertIDType buildCertIDType(XmlDigestAlgoAndValue digestAlgoAndValue, byte[] issuerSerial) {
        SACertIDType certIDType = this.objectFactory.createSACertIDType();
        certIDType.setDigestMethod(this.getDigestMethodType(digestAlgoAndValue));
        certIDType.setDigestValue(digestAlgoAndValue.getDigestValue());
        if (issuerSerial != null) {
            certIDType.setX509IssuerSerial(issuerSerial);
        }
        return certIDType;
    }

    private void addCompleteRevocationRefs(SignatureAttributesType sigAttributes, FoundRevocationsProxy revocationsProxy) {
        List<RelatedRevocationWrapper> relatedRevs = revocationsProxy.getRelatedRevocationsByRefOrigin(RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        List<OrphanRevocationWrapper> orphanRevs = revocationsProxy.getOrphanRevocationsByRefOrigin(RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCompleteRevocationRefs(this.buildRevIDListType(relatedRevs, orphanRevs)));
    }

    private void addAttributeRevocationRefs(SignatureAttributesType sigAttributes, FoundRevocationsProxy revocationsProxy) {
        List<RelatedRevocationWrapper> relatedRevs = revocationsProxy.getRelatedRevocationsByRefOrigin(RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        List<OrphanRevocationWrapper> orphanRevs = revocationsProxy.getOrphanRevocationsByRefOrigin(RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttributeRevocationRefs(this.buildRevIDListType(relatedRevs, orphanRevs)));
    }

    private SARevIDListType buildRevIDListType(List<RelatedRevocationWrapper> relatedRevs, List<OrphanRevocationWrapper> orphanRevs) {
        SARevIDListType revIDListType = this.objectFactory.createSARevIDListType();
        ArrayList<String> validationObjectIds = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(relatedRevs)) {
            for (RevocationWrapper revocationWrapper : relatedRevs) {
                validationObjectIds.add(revocationWrapper.getId());
            }
        }
        if (Utils.isCollectionNotEmpty(orphanRevs)) {
            List<OrphanRevocationWrapper> allOrphanRevocations = this.diagnosticData.getAllOrphanRevocationObjects();
            for (OrphanRevocationWrapper orphanRev : orphanRevs) {
                if (orphanRev == null) continue;
                if (Utils.isCollectionNotEmpty(orphanRev.getReferences()) && !allOrphanRevocations.contains(orphanRev)) {
                    for (RevocationRefWrappper revRef : orphanRev.getReferences()) {
                        Serializable revID = RevocationType.CRL.equals((Object)orphanRev.getRevocationType()) ? this.buildCRLID(revRef.getDigestAlgoAndValue()) : this.buildOCSPID(revRef);
                        if (revID == null) continue;
                        revIDListType.getCRLIDOrOCSPID().add(revID);
                    }
                    continue;
                }
                validationObjectIds.add(orphanRev.getId());
            }
        }
        if (Utils.isCollectionNotEmpty(validationObjectIds)) {
            revIDListType.getAttributeObject().add(this.getVOReference(validationObjectIds));
        }
        return revIDListType;
    }

    private SACRLIDType buildCRLID(XmlDigestAlgoAndValue digestAlgoAndValue) {
        SACRLIDType sacrlidType = this.objectFactory.createSACRLIDType();
        sacrlidType.setDigestMethod(this.getDigestMethodType(digestAlgoAndValue));
        sacrlidType.setDigestValue(digestAlgoAndValue.getDigestValue());
        return sacrlidType;
    }

    private SAOCSPIDType buildOCSPID(RevocationRefWrappper revRef) {
        if (Utils.isStringNotEmpty(revRef.getResponderIdName()) || Utils.isArrayNotEmpty(revRef.getResponderIdKey())) {
            SAOCSPIDType saocspidType = this.objectFactory.createSAOCSPIDType();
            saocspidType.setProducedAt(revRef.getProductionTime());
            if (Utils.isStringNotEmpty(revRef.getResponderIdName())) {
                saocspidType.setResponderIDByName(revRef.getResponderIdName());
            } else {
                saocspidType.setResponderIDByKey(revRef.getResponderIdKey());
            }
            return saocspidType;
        }
        return null;
    }

    private DigestMethodType getDigestMethodType(XmlDigestAlgoAndValue digestAlgoAndValue) {
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(digestAlgoAndValue.getDigestMethod().getUri());
        return digestMethodType;
    }

    private void addRevocationValues(SignatureAttributesType sigAttributes, FoundRevocationsProxy foundRevocations) {
        ArrayList<String> revocationIds = new ArrayList<String>();
        revocationIds.addAll(this.getRelatedRevocationIds(foundRevocations.getRelatedRevocationsByOrigin(RevocationOrigin.REVOCATION_VALUES)));
        revocationIds.addAll(this.getOrphanRevocationIds(foundRevocations.getOrphanRevocationsByOrigin(RevocationOrigin.REVOCATION_VALUES)));
        if (Utils.isCollectionNotEmpty(revocationIds)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeRevocationValues(this.buildTokenList(revocationIds)));
        }
    }

    private void addAttributeRevocationValues(SignatureAttributesType sigAttributes, FoundRevocationsProxy foundRevocations) {
        ArrayList<String> revocationIds = new ArrayList<String>();
        revocationIds.addAll(this.getRelatedRevocationIds(foundRevocations.getRelatedRevocationsByOrigin(RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES)));
        revocationIds.addAll(this.getOrphanRevocationIds(foundRevocations.getOrphanRevocationsByOrigin(RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES)));
        if (Utils.isCollectionNotEmpty(revocationIds)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttributeRevocationValues(this.buildTokenList(revocationIds)));
        }
    }

    private void addMessageDigest(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        XmlDigestMatcher messageDigest = sigWrapper.getMessageDigest();
        if (messageDigest != null && messageDigest.getDigestValue() != null) {
            SAMessageDigestType messageDigestType = this.objectFactory.createSAMessageDigestType();
            messageDigestType.setDigest(messageDigest.getDigestValue());
            this.setSignedIfValid(sigWrapper, messageDigestType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeMessageDigest(messageDigestType));
        }
    }

    private void addTimestampsByType(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper, TimestampType timestampType) {
        List<TimestampWrapper> timestampListByType = sigWrapper.getTimestampListByType(timestampType);
        List<TimestampWrapper> docTimestamps = sigWrapper.getTimestampListByLocation(TimestampLocation.DOC_TIMESTAMP);
        timestampListByType.removeAll(docTimestamps);
        boolean isSigned = sigWrapper.isBLevelTechnicallyValid() && timestampType.isContentTimestamp();
        for (TimestampWrapper timestampWrapper : timestampListByType) {
            SATimestampType timestamp = this.getSATimestampType(timestampWrapper);
            JAXBElement<SATimestampType> wrap = this.wrap(timestampType, timestamp);
            if (isSigned) {
                wrap.getValue().setSigned(isSigned);
            }
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(wrap);
        }
    }

    private void addTimestampsByLocation(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper, TimestampLocation timestampLocation) {
        List<TimestampWrapper> timestampListByType = sigWrapper.getTimestampListByLocation(timestampLocation);
        for (TimestampWrapper timestampWrapper : timestampListByType) {
            SATimestampType timestamp = this.getSATimestampType(timestampWrapper);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.wrap(timestampLocation, timestamp));
        }
    }

    private SATimestampType getSATimestampType(TimestampWrapper timestampWrapper) {
        SATimestampType timestamp = this.objectFactory.createSATimestampType();
        timestamp.setTimeStampValue(timestampWrapper.getProductionTime());
        timestamp.getAttributeObject().add(this.getVOReference(timestampWrapper.getId()));
        return timestamp;
    }

    private JAXBElement<SATimestampType> wrap(TimestampType timestampType, SATimestampType timestamp) {
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeSignatureTimeStamp(timestamp);
            }
            case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeIndividualDataObjectsTimeStamp(timestamp);
            }
            case ALL_DATA_OBJECTS_TIMESTAMP: 
            case CONTENT_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeAllDataObjectsTimeStamp(timestamp);
            }
            case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeRefsOnlyTimeStamp(timestamp);
            }
            case VALIDATION_DATA_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeSigAndRefsTimeStamp(timestamp);
            }
            case ARCHIVE_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeArchiveTimeStamp(timestamp);
            }
        }
        throw new IllegalArgumentException("Unsupported timestamp type " + (Object)((Object)timestampType));
    }

    private JAXBElement<SATimestampType> wrap(TimestampLocation timestampLocation, SATimestampType timestamp) {
        switch (timestampLocation) {
            case DOC_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeDocTimeStamp(timestamp);
            }
        }
        throw new IllegalArgumentException("Unsupported timestamp type " + (Object)((Object)timestampLocation));
    }

    private void addSigPolicyIdentifier(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String policyId = sigWrapper.getPolicyId();
        if (Utils.isStringNotEmpty(policyId) && !SignaturePolicyType.IMPLICIT_POLICY.name().equals(policyId)) {
            SASigPolicyIdentifierType saSigPolicyIdentifierType = this.objectFactory.createSASigPolicyIdentifierType();
            saSigPolicyIdentifierType.setSigPolicyId(policyId);
            this.setSignedIfValid(sigWrapper, saSigPolicyIdentifierType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSigPolicyIdentifier(saSigPolicyIdentifierType));
        }
    }

    private void addDataObjectFormat(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String contentType = sigWrapper.getContentType();
        String mimeType = sigWrapper.getMimeType();
        if (Utils.isStringNotEmpty(contentType) || Utils.isStringNotEmpty(mimeType)) {
            SADataObjectFormatType dataObjectFormatType = this.objectFactory.createSADataObjectFormatType();
            if (Utils.isStringNotEmpty(contentType)) {
                dataObjectFormatType.setContentType(contentType);
            }
            if (Utils.isStringNotEmpty(mimeType)) {
                dataObjectFormatType.setMimeType(mimeType);
            }
            this.setSignedIfValid(sigWrapper, dataObjectFormatType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeDataObjectFormat(dataObjectFormatType));
        }
    }

    private void addCommitmentTypeIndications(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<XmlCommitmentTypeIndication> commitmentTypeIndications = sigWrapper.getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            for (XmlCommitmentTypeIndication commitmentTypeIndication : commitmentTypeIndications) {
                SACommitmentTypeIndicationType commitmentType = this.objectFactory.createSACommitmentTypeIndicationType();
                commitmentType.setCommitmentTypeIdentifier(commitmentTypeIndication.getIdentifier());
                this.setSignedIfValid(sigWrapper, commitmentType);
                sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCommitmentTypeIndication(commitmentType));
            }
        }
    }

    private void addSignerRoles(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<XmlSignerRole> signerRoles = sigWrapper.getSignerRoles();
        if (Utils.isCollectionNotEmpty(signerRoles)) {
            SASignerRoleType signerRoleType = this.objectFactory.createSASignerRoleType();
            for (XmlSignerRole role : signerRoles) {
                SAOneSignerRoleType oneSignerRole = this.objectFactory.createSAOneSignerRoleType();
                oneSignerRole.setRole(role.getRole());
                oneSignerRole.setEndorsementType(role.getCategory());
                signerRoleType.getRoleDetails().add(oneSignerRole);
            }
            this.setSignedIfValid(sigWrapper, signerRoleType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSignerRole(signerRoleType));
        }
    }

    private void addCounterSignatures(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        Set<SignatureWrapper> counterSignatures = this.diagnosticData.getAllCounterSignaturesForMasterSignature(sigWrapper);
        for (SignatureWrapper counterSignature : counterSignatures) {
            SACounterSignatureType saCounterSignatureType = this.objectFactory.createSACounterSignatureType();
            saCounterSignatureType.getAttributeObject().add(this.getVOReference(counterSignature.getId()));
            SignatureReferenceType signatureReference = this.getSignatureReference(counterSignature);
            saCounterSignatureType.setCounterSignature(signatureReference);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCounterSignature(saCounterSignatureType));
        }
    }

    private void addProductionPlace(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        if (sigWrapper.isSignatureProductionPlacePresent()) {
            String address = sigWrapper.getAddress();
            String city = sigWrapper.getCity();
            String stateOrProvince = sigWrapper.getStateOrProvince();
            String postalCode = sigWrapper.getPostalCode();
            String countryName = sigWrapper.getCountryName();
            if (Utils.areAllStringsEmpty(address, city, stateOrProvince, postalCode, countryName)) {
                return;
            }
            SASignatureProductionPlaceType sigProductionPlace = this.objectFactory.createSASignatureProductionPlaceType();
            if (Utils.isStringNotEmpty(address)) {
                sigProductionPlace.getAddressString().add(address);
            }
            if (Utils.isStringNotEmpty(city)) {
                sigProductionPlace.getAddressString().add(city);
            }
            if (Utils.isStringNotEmpty(stateOrProvince)) {
                sigProductionPlace.getAddressString().add(stateOrProvince);
            }
            if (Utils.isStringNotEmpty(postalCode)) {
                sigProductionPlace.getAddressString().add(postalCode);
            }
            if (Utils.isStringNotEmpty(countryName)) {
                sigProductionPlace.getAddressString().add(countryName);
            }
            this.setSignedIfValid(sigWrapper, sigProductionPlace);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSignatureProductionPlace(sigProductionPlace));
        }
    }

    private void addFilter(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String filter = sigWrapper.getFilter();
        if (Utils.isStringNotEmpty(filter)) {
            SAFilterType filterType = this.objectFactory.createSAFilterType();
            filterType.setFilter(filter);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeFilter(filterType));
        }
    }

    private void addSubFilter(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String subFilter = sigWrapper.getSubFilter();
        if (Utils.isStringNotEmpty(subFilter)) {
            SASubFilterType subFilterType = this.objectFactory.createSASubFilterType();
            subFilterType.setSubFilterElement(subFilter);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSubFilter(subFilterType));
        }
    }

    private void addContactInfo(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String contactInfo = sigWrapper.getContactInfo();
        if (Utils.isStringNotEmpty(contactInfo)) {
            SAContactInfoType contactInfoType = this.objectFactory.createSAContactInfoType();
            contactInfoType.setContactInfoElement(contactInfo);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeContactInfo(contactInfoType));
        }
    }

    private void addSignerName(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String signerName = sigWrapper.getSignerName();
        if (Utils.isStringNotEmpty(signerName)) {
            SANameType nameType = this.objectFactory.createSANameType();
            nameType.setNameElement(signerName);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeName(nameType));
        }
    }

    private void addReason(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String reason = sigWrapper.getReason();
        if (Utils.isStringNotEmpty(reason)) {
            SAReasonType reasonType = this.objectFactory.createSAReasonType();
            reasonType.setReasonElement(reason);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeReason(reasonType));
        }
    }

    private void addSignatureByteRange(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<BigInteger> signatureByteRange = sigWrapper.getSignatureByteRange();
        if (Utils.isCollectionNotEmpty(signatureByteRange)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeByteRange(signatureByteRange));
        }
    }

    private void addDSS(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<String> certIds = this.getRelatedCertsIds(sigWrapper.foundCertificates().getRelatedCertificatesByOrigin(CertificateOrigin.DSS_DICTIONARY));
        certIds.addAll(this.getOrphanCertsIds(sigWrapper.foundCertificates().getOrphanCertificatesByOrigin(CertificateOrigin.DSS_DICTIONARY)));
        List<String> crlIds = this.getRelatedRevocationIds(sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.DSS_DICTIONARY));
        crlIds.addAll(this.getOrphanRevocationIds(sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.DSS_DICTIONARY)));
        List<String> ocspIds = this.getRelatedRevocationIds(sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.DSS_DICTIONARY));
        ocspIds.addAll(this.getOrphanRevocationIds(sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.DSS_DICTIONARY)));
        if (Utils.isCollectionNotEmpty(certIds) || Utils.isCollectionNotEmpty(crlIds) || Utils.isCollectionNotEmpty(ocspIds)) {
            SADSSType dssType = this.objectFactory.createSADSSType();
            if (Utils.isCollectionNotEmpty(certIds)) {
                dssType.setCerts(this.getVOReference(certIds));
            }
            if (Utils.isCollectionNotEmpty(crlIds)) {
                dssType.setCRLs(this.getVOReference(crlIds));
            }
            if (Utils.isCollectionNotEmpty(ocspIds)) {
                dssType.setOCSPs(this.getVOReference(ocspIds));
            }
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeDSS(dssType));
        }
    }

    private void addVRI(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<String> certIds = this.getRelatedCertsIds(sigWrapper.foundCertificates().getRelatedCertificatesByOrigin(CertificateOrigin.VRI_DICTIONARY));
        certIds.addAll(this.getOrphanCertsIds(sigWrapper.foundCertificates().getOrphanCertificatesByOrigin(CertificateOrigin.VRI_DICTIONARY)));
        List<String> crlIds = this.getRelatedRevocationIds(sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.VRI_DICTIONARY));
        crlIds.addAll(this.getOrphanRevocationIds(sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.VRI_DICTIONARY)));
        List<String> ocspIds = this.getRelatedRevocationIds(sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.VRI_DICTIONARY));
        ocspIds.addAll(this.getOrphanRevocationIds(sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.VRI_DICTIONARY)));
        if (Utils.isCollectionNotEmpty(certIds) || Utils.isCollectionNotEmpty(crlIds) || Utils.isCollectionNotEmpty(ocspIds)) {
            SAVRIType vriType = this.objectFactory.createSAVRIType();
            if (Utils.isCollectionNotEmpty(certIds)) {
                vriType.setCerts(this.getVOReference(certIds));
            }
            if (Utils.isCollectionNotEmpty(crlIds)) {
                vriType.setCRLs(this.getVOReference(crlIds));
            }
            if (Utils.isCollectionNotEmpty(ocspIds)) {
                vriType.setOCSPs(this.getVOReference(ocspIds));
            }
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeVRI(vriType));
        }
    }

    private void addSigningTime(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        Date signingTime = sigWrapper.getClaimedSigningTime();
        if (signingTime != null) {
            SASigningTimeType saSigningTimeType = this.objectFactory.createSASigningTimeType();
            saSigningTimeType.setTime(signingTime);
            this.setSignedIfValid(sigWrapper, saSigningTimeType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSigningTime(saSigningTimeType));
        }
    }

    private void setSignedIfValid(SignatureWrapper sigWrapper, AttributeBaseType attribute) {
        if (sigWrapper.isBLevelTechnicallyValid()) {
            attribute.setSigned(true);
        }
    }
}

