/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AcceptableMimetypeFileContentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AcceptableZipCommentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ContainerTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FormatCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FullScopeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ManifestFilePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.MimeTypeFilePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignatureNotAmbiguousCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignedFilesPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignerInformationStoreCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ZipCommentPresentCheck;

public class FormatChecking
extends Chain<XmlFC> {
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;
    private final Context context;
    private final ValidationPolicy policy;

    public FormatChecking(I18nProvider i18nProvider, DiagnosticData diagnosticData, SignatureWrapper signature, Context context, ValidationPolicy policy) {
        super(i18nProvider, new XmlFC());
        this.diagnosticData = diagnosticData;
        this.signature = signature;
        this.context = context;
        this.policy = policy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.FORMAT_CHECKING;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlFC> item = this.firstItem = this.formatCheck();
        item = item.setNextItem(this.duplicateCheck());
        item = item.setNextItem(this.fullScopeCheck());
        if (this.signature.getPDFRevision() != null) {
            item = item.setNextItem(this.signerInformationStoreCheck());
        }
        if (this.diagnosticData.isContainerInfoPresent()) {
            item = item.setNextItem(this.containerTypeCheck());
            item = item.setNextItem(this.zipCommentPresentCheck());
            item = item.setNextItem(this.acceptableZipCommentCheck());
            item = item.setNextItem(this.mimetypeFilePresentCheck());
            item = item.setNextItem(this.mimetypeFileContentCheck());
            item = item.setNextItem(this.manifestFilePresentCheck());
            item = item.setNextItem(this.signedFilesPresentCheck());
        }
    }

    private ChainItem<XmlFC> formatCheck() {
        MultiValuesConstraint constraint = this.policy.getSignatureFormatConstraint(this.context);
        return new FormatCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> duplicateCheck() {
        LevelConstraint constraint = this.policy.getSignatureDuplicatedConstraint(this.context);
        return new SignatureNotAmbiguousCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> fullScopeCheck() {
        LevelConstraint constraint = this.policy.getFullScopeConstraint();
        return new FullScopeCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> signerInformationStoreCheck() {
        LevelConstraint constraint = this.policy.getSignerInformationStoreConstraint(this.context);
        return new SignerInformationStoreCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> containerTypeCheck() {
        MultiValuesConstraint constraint = this.policy.getAcceptedContainerTypesConstraint();
        return new ContainerTypeCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerType(), constraint);
    }

    private ChainItem<XmlFC> zipCommentPresentCheck() {
        LevelConstraint constraint = this.policy.getZipCommentPresentConstraint();
        return new ZipCommentPresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getZipComment(), constraint);
    }

    private ChainItem<XmlFC> acceptableZipCommentCheck() {
        MultiValuesConstraint constraint = this.policy.getAcceptedZipCommentsConstraint();
        return new AcceptableZipCommentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getZipComment(), constraint);
    }

    private ChainItem<XmlFC> mimetypeFilePresentCheck() {
        LevelConstraint constraint = this.policy.getMimeTypeFilePresentConstraint();
        return new MimeTypeFilePresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.isMimetypeFilePresent(), constraint);
    }

    private ChainItem<XmlFC> mimetypeFileContentCheck() {
        MultiValuesConstraint constraint = this.policy.getAcceptedMimeTypeContentsConstraint();
        return new AcceptableMimetypeFileContentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getMimetypeFileContent(), constraint);
    }

    private ChainItem<XmlFC> manifestFilePresentCheck() {
        LevelConstraint constraint = this.policy.getManifestFilePresentConstraint();
        return new ManifestFilePresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerInfo(), constraint);
    }

    private ChainItem<XmlFC> signedFilesPresentCheck() {
        LevelConstraint constraint = this.policy.getSignedFilesPresentConstraint();
        return new SignedFilesPresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerInfo(), constraint);
    }
}

