/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class SignedFilesPresentCheck
extends ChainItem<XmlFC> {
    private final XmlContainerInfo containerInfo;
    private MessageTag message;
    private MessageTag error;

    public SignedFilesPresentCheck(I18nProvider i18nProvider, XmlFC result, XmlContainerInfo containerInfo, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.containerInfo = containerInfo;
    }

    @Override
    protected boolean process() {
        if (ASiCContainerType.ASiC_S.equals((Object)this.containerInfo.getContainerType())) {
            this.message = MessageTag.BBB_FC_ISFP_ASICS;
            this.error = MessageTag.BBB_FC_ISFP_ASICS_ANS;
            List<String> contentFiles = this.containerInfo.getContentFiles();
            if (Utils.isCollectionNotEmpty(contentFiles) && contentFiles.size() == 1) {
                String fileName = contentFiles.iterator().next();
                return this.isRootDirectoryFile(fileName);
            }
            return false;
        }
        this.message = MessageTag.BBB_FC_ISFP_ASICE;
        this.error = MessageTag.BBB_FC_ISFP_ASICE_ANS;
        return Utils.isCollectionNotEmpty(this.containerInfo.getContentFiles());
    }

    private boolean isRootDirectoryFile(String fileName) {
        return !fileName.contains("/") && !fileName.contains("\\");
    }

    @Override
    protected MessageTag getMessageTag() {
        return this.message;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.error;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

