/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.validation.process.CertificatePolicyIdentifiers;
import eu.europa.esig.dss.validation.process.QCStatementPolicyIdentifiers;
import eu.europa.esig.dss.validation.process.qualification.certificate.QSCDStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;

class QSCDByCertificatePreEIDAS
implements QSCDStrategy {
    private final CertificateWrapper certificate;

    public QSCDByCertificatePreEIDAS(CertificateWrapper certificate) {
        this.certificate = certificate;
    }

    @Override
    public QSCDStatus getQSCDStatus() {
        boolean policyIdSupportedByQSCD = CertificatePolicyIdentifiers.isQCPPlus(this.certificate);
        boolean qcStatementSupportedByQSCD = QCStatementPolicyIdentifiers.isSupportedByQSCD(this.certificate);
        if (policyIdSupportedByQSCD || qcStatementSupportedByQSCD) {
            return QSCDStatus.QSCD;
        }
        return QSCDStatus.NOT_QSCD;
    }
}

