/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust;

import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public final class ServiceQualification {
    public static final String QC_STATEMENT = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCStatement";
    public static final String NOT_QUALIFIED = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/NotQualified";
    public static final String QC_WITH_SSCD = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD";
    public static final String QC_WITH_QSCD = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD";
    public static final String QC_NO_SSCD = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD";
    public static final String QC_NO_QSCD = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD";
    public static final String QC_SSCD_STATUS_AS_IN_CERT = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCSSCDStatusAsInCert";
    public static final String QC_QSCD_STATUS_AS_IN_CERT = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert";
    public static final String QC_QSCD_MANAGED_ON_BEHALF = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf";
    public static final String QC_FOR_LEGAL_PERSON = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForLegalPerson";
    public static final String QC_FOR_ESIG = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig";
    public static final String QC_FOR_ESEAL = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal";
    public static final String QC_FOR_WSA = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA";

    private ServiceQualification() {
    }

    public static boolean isQcStatement(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_STATEMENT);
    }

    public static boolean isNotQualified(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, NOT_QUALIFIED);
    }

    public static boolean isQcNoQSCD(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_NO_QSCD, QC_NO_SSCD);
    }

    public static boolean isQcForLegalPerson(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_LEGAL_PERSON);
    }

    public static boolean isQcQSCDStatusAsInCert(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_QSCD_STATUS_AS_IN_CERT, QC_SSCD_STATUS_AS_IN_CERT);
    }

    public static boolean isQcQSCDManagedOnBehalf(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_QSCD_MANAGED_ON_BEHALF);
    }

    public static boolean isQcWithQSCD(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_WITH_QSCD, QC_WITH_SSCD);
    }

    public static boolean isQcForEsig(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_ESIG);
    }

    public static boolean isQcForEseal(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_ESEAL);
    }

    public static boolean isQcForWSA(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_WSA);
    }

    public static List<String> getUsageQualifiers(List<String> qualifiers) {
        ArrayList<String> filteredQualifiers = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(qualifiers)) {
            if (qualifiers.contains(QC_FOR_ESIG)) {
                filteredQualifiers.add(QC_FOR_ESIG);
            }
            if (qualifiers.contains(QC_FOR_ESEAL)) {
                filteredQualifiers.add(QC_FOR_ESEAL);
            }
            if (qualifiers.contains(QC_FOR_WSA)) {
                filteredQualifiers.add(QC_FOR_WSA);
            }
        }
        return filteredQualifiers;
    }

    private static boolean listContains(List<String> qualifiers, String ... expecteds) {
        if (Utils.isCollectionNotEmpty(qualifiers)) {
            for (String expected : expecteds) {
                if (!qualifiers.contains(expected)) continue;
                return true;
            }
        }
        return false;
    }
}

