/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationConsistentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.AcceptableRevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.AcceptableBasicSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationBasicBuildingBlocksCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationDateAfterBestSignatureTimeCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.SigningTimeAttributePresentCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampCoherenceOrderCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampDelayCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationProcessForSignaturesWithLongTermValidationData
extends Chain<XmlValidationProcessLongTermData> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationProcessForSignaturesWithLongTermValidationData.class);
    private final XmlConstraintsConclusion basicSignatureValidation;
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper currentSignature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final List<XmlTimestamp> xmlTimestamps;
    private final ValidationPolicy policy;
    private final Date currentDate;

    public ValidationProcessForSignaturesWithLongTermValidationData(I18nProvider i18nProvider, XmlSignature signatureAnalysis, DiagnosticData diagnosticData, SignatureWrapper currentSignature, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentDate) {
        super(i18nProvider, new XmlValidationProcessLongTermData());
        this.basicSignatureValidation = signatureAnalysis.getValidationProcessBasicSignature();
        this.xmlTimestamps = signatureAnalysis.getTimestamp();
        this.diagnosticData = diagnosticData;
        this.currentSignature = currentSignature;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentDate = currentDate;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFLTVD;
    }

    @Override
    protected void initChain() {
        XmlConclusion xmlConclusion;
        Context currentContext = Context.SIGNATURE;
        if (this.currentSignature.isCounterSignature()) {
            currentContext = Context.COUNTER_SIGNATURE;
        }
        XmlProofOfExistence bestSignatureTime = this.getCurrentTime();
        ChainItem<XmlValidationProcessLongTermData> item = this.firstItem = this.isAcceptableBasicSignatureValidation();
        LinkedHashMap<CertificateRevocationWrapper, SubContext> revocationDataToUse = new LinkedHashMap<CertificateRevocationWrapper, SubContext>();
        for (CertificateWrapper certificateWrapper : this.currentSignature.getCertificateChain()) {
            if (certificateWrapper.isTrusted()) break;
            CertificateRevocationWrapper latestCertificateRevocation = null;
            for (CertificateRevocationWrapper revocationData : certificateWrapper.getCertificateRevocationData()) {
                item = item.setNextItem(this.revocationBasicBuildingBlocksValid(revocationData));
                XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(revocationData.getId());
                if (!ValidationProcessUtils.isAllowedBasicSignatureValidation(revocationBBB.getConclusion())) continue;
                item = item.setNextItem(this.revocationDataConsistent(certificateWrapper, revocationData));
                if (!this.isRevocationDataConsistent(certificateWrapper, revocationData) || latestCertificateRevocation != null && !revocationData.getProductionDate().after(latestCertificateRevocation.getProductionDate())) continue;
                latestCertificateRevocation = revocationData;
            }
            SubContext subContext = this.currentSignature.getSigningCertificate().getId().equals(certificateWrapper.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            item = item.setNextItem(this.revocationDataAvailable(latestCertificateRevocation, certificateWrapper, currentContext, subContext));
            if (latestCertificateRevocation == null) continue;
            revocationDataToUse.put(latestCertificateRevocation, subContext);
        }
        Set<TimestampWrapper> allowedTimestamps = this.filterValidSignatureTimestamps(this.currentSignature.getTimestampList());
        if (Utils.isCollectionNotEmpty(allowedTimestamps)) {
            for (TimestampWrapper timestampWrapper : allowedTimestamps) {
                Date productionTime = timestampWrapper.getProductionTime();
                if (!this.isAcceptableTimestampValidation(timestampWrapper) || !productionTime.before(bestSignatureTime.getTime())) continue;
                bestSignatureTime = this.getProofOfExistence(timestampWrapper);
            }
        }
        if (Indication.INDETERMINATE.equals((xmlConclusion = this.basicSignatureValidation.getConclusion()).getIndication()) && (SubIndication.REVOKED_NO_POE.equals(xmlConclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(xmlConclusion.getSubIndication()))) {
            item = this.revocationDateAfterBestSignatureDateValidation(item, revocationDataToUse, bestSignatureTime.getTime(), xmlConclusion.getSubIndication());
        }
        if (Indication.INDETERMINATE.equals(xmlConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals(xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime.getTime(), xmlConclusion.getIndication(), xmlConclusion.getSubIndication()));
        }
        if (this.isCryptoConstraintFailureNoPoe(xmlConclusion)) {
            item = item.setNextItem(this.algorithmReliableAtBestSignatureTime(bestSignatureTime.getTime()));
            item = this.certificateChainReliableAtBestSignatureTime(item, bestSignatureTime.getTime());
            item = this.revocationDataReliableAtBestSignatureTime(item, revocationDataToUse, bestSignatureTime.getTime());
        }
        if (Indication.INDETERMINATE.equals(xmlConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime.getTime()));
            item = item.setNextItem(this.bestSignatureTimeBeforeCertificateExpiration(bestSignatureTime.getTime()));
        }
        if (Utils.isCollectionNotEmpty(allowedTimestamps)) {
            item = item.setNextItem(this.timestampCoherenceOrder(this.currentSignature.getTimestampList()));
            List<TimestampWrapper> signatureTimestamps = this.currentSignature.getTimestampListByType(TimestampType.SIGNATURE_TIMESTAMP);
            if (!signatureTimestamps.isEmpty() && this.policy.getTimestampDelayConstraint() != null) {
                item = item.setNextItem(this.signingTimeAttributePresent());
                item = item.setNextItem(this.timestampDelay(bestSignatureTime.getTime()));
            }
        }
        if (Indication.INDETERMINATE.equals(xmlConclusion.getIndication()) && SubIndication.TRY_LATER.equals(xmlConclusion.getSubIndication())) {
            item = this.revocationIsFresh(item, revocationDataToUse, bestSignatureTime.getTime(), currentContext);
        }
        item = item.setNextItem(this.signatureIsAcceptable(bestSignatureTime.getTime(), currentContext));
        ((XmlValidationProcessLongTermData)this.result).setProofOfExistence(bestSignatureTime);
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationBasicBuildingBlocksValid(CertificateRevocationWrapper revocationData) {
        XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(revocationData.getId());
        if (revocationBBB == null) {
            throw new IllegalStateException(String.format("Missing Basic Building Blocks result for token '%s'", revocationData.getId()));
        }
        return new RevocationBasicBuildingBlocksCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.diagnosticData, revocationBBB, this.bbbs, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDataConsistent(CertificateWrapper certificate, CertificateRevocationWrapper revocationData) {
        return new RevocationConsistentCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, certificate, revocationData, this.getWarnLevelConstraint());
    }

    private boolean isRevocationDataConsistent(CertificateWrapper certificate, CertificateRevocationWrapper revocationData) {
        XmlBasicBuildingBlocks signatureBBB = this.bbbs.get(this.currentSignature.getId());
        if (signatureBBB.getXCV() != null) {
            for (XmlSubXCV subXCV : signatureBBB.getXCV().getSubXCV()) {
                if (!certificate.getId().equals(subXCV.getId()) || subXCV.getRFC() == null || !revocationData.getId().equals(subXCV.getRFC().getId())) continue;
                return true;
            }
        }
        return false;
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDataAvailable(RevocationWrapper revocationData, CertificateWrapper certificateWrapper, Context context, SubContext subContext) {
        LevelConstraint constraint = this.policy.getRevocationDataAvailableConstraint(context, subContext);
        return new AcceptableRevocationDataAvailableCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, certificateWrapper, revocationData, constraint);
    }

    private XmlProofOfExistence getCurrentTime() {
        XmlProofOfExistence xpoe = new XmlProofOfExistence();
        xpoe.setTime(this.currentDate);
        return xpoe;
    }

    private XmlProofOfExistence getProofOfExistence(TimestampWrapper timestampWrapper) {
        XmlProofOfExistence xpoe = new XmlProofOfExistence();
        xpoe.setTime(timestampWrapper.getProductionTime());
        xpoe.setTimestampId(timestampWrapper.getId());
        return xpoe;
    }

    private Set<TimestampWrapper> filterValidSignatureTimestamps(List<TimestampWrapper> allTimestamps) {
        HashSet<TimestampWrapper> result = new HashSet<TimestampWrapper>();
        for (TimestampWrapper timestampWrapper : allTimestamps) {
            if (!TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampWrapper.getType())) continue;
            XmlBasicBuildingBlocks bbbTST = this.bbbs.get(timestampWrapper.getId());
            if (bbbTST != null) {
                XmlCV cv = bbbTST.getCV();
                if (cv != null) {
                    XmlConclusion conclusion = cv.getConclusion();
                    if (!Indication.PASSED.equals(conclusion.getIndication())) continue;
                    result.add(timestampWrapper);
                    continue;
                }
                LOG.warn("Cryptographic validation (CV) for timestamp is required !");
                continue;
            }
            LOG.warn("Cannot find tsp validation info for tsp {}", (Object)timestampWrapper.getId());
        }
        return result;
    }

    private boolean isAcceptableTimestampValidation(TimestampWrapper timestamp) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!timestamp.getId().equals(xmlTimestamp.getId()) || !this.isValid(xmlTimestamp.getValidationProcessTimestamp())) continue;
            return true;
        }
        return false;
    }

    private ChainItem<XmlValidationProcessLongTermData> isAcceptableBasicSignatureValidation() {
        return new AcceptableBasicSignatureValidationCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.basicSignatureValidation, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationIsFresh(ChainItem<XmlValidationProcessLongTermData> item, Map<CertificateRevocationWrapper, SubContext> revocationDataMap, Date bestSignatureTime, Context currentContext) {
        for (Map.Entry<CertificateRevocationWrapper, SubContext> revocationEntry : revocationDataMap.entrySet()) {
            CertificateRevocationWrapper revocationData = revocationEntry.getKey();
            SubContext subContext = revocationEntry.getValue();
            RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, revocationData, bestSignatureTime, currentContext, subContext, this.policy);
            item = item.setNextItem(this.checkRevocationFreshnessCheckerResult((XmlRFC)rfc.execute(), currentContext, subContext));
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult, Context context, SubContext subContext) {
        LevelConstraint constraint = this.policy.getCertificateRevocationFreshnessConstraint(context, subContext);
        return new RevocationFreshnessCheckerResultCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, rfcResult, constraint){

            @Override
            protected Indication getFailedIndicationForConclusion() {
                return Indication.INDETERMINATE;
            }

            @Override
            protected SubIndication getFailedSubIndicationForConclusion() {
                return SubIndication.TRY_LATER;
            }
        };
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDateAfterBestSignatureDateValidation(ChainItem<XmlValidationProcessLongTermData> item, Map<CertificateRevocationWrapper, SubContext> revocationDataMap, Date bestSignatureTime, SubIndication subIndication) {
        LevelConstraint constraint = this.policy.getRevocationTimeAgainstBestSignatureTime();
        for (Map.Entry<CertificateRevocationWrapper, SubContext> revocationMapEntry : revocationDataMap.entrySet()) {
            CertificateRevocationWrapper revocationData = revocationMapEntry.getKey();
            SubContext subContext = revocationMapEntry.getValue();
            if ((!SubContext.SIGNING_CERT.equals((Object)subContext) || !SubIndication.REVOKED_NO_POE.equals(subIndication)) && (!SubContext.CA_CERTIFICATE.equals((Object)subContext) || !SubIndication.REVOKED_CA_NO_POE.equals(subIndication))) continue;
            item = item.setNextItem(new RevocationDateAfterBestSignatureTimeCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, revocationData, bestSignatureTime, constraint, subContext));
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, Indication currentIndication, SubIndication currentSubIndication) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, currentIndication, currentSubIndication, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeBeforeCertificateExpiration(Date bestSignatureTime) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        return new BestSignatureTimeBeforeCertificateExpirationCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, this.policy.getBestSignatureTimeBeforeExpirationDateOfSigningCertificateConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampCoherenceOrder(List<TimestampWrapper> timestamps) {
        return new TimestampCoherenceOrderCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, timestamps, this.policy.getTimestampCoherenceConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> signingTimeAttributePresent() {
        return new SigningTimeAttributePresentCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.currentSignature, this.policy.getSigningTimeConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampDelay(Date bestSignatureTime) {
        return new TimestampDelayCheck(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.currentSignature, bestSignatureTime, this.policy.getTimestampDelayConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> algorithmReliableAtBestSignatureTime(Date bestSignatureTime) {
        return new CryptographicCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, this.currentSignature, bestSignatureTime, this.policy.getSignatureCryptographicConstraint(Context.SIGNATURE));
    }

    private ChainItem<XmlValidationProcessLongTermData> signatureIsAcceptable(Date bestSignatureTime, Context context) {
        SignatureAcceptanceValidation sav = new SignatureAcceptanceValidation(this.i18nProvider, this.diagnosticData, bestSignatureTime, this.currentSignature, context, this.policy);
        return new SignatureAcceptanceValidationResultCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, (XmlSAV)sav.execute(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> certificateChainReliableAtBestSignatureTime(ChainItem<XmlValidationProcessLongTermData> item, Date bestSignatureTime) {
        for (CertificateWrapper certificate : this.currentSignature.getCertificateChain()) {
            if (certificate.isTrusted()) break;
            SubContext subContext = this.currentSignature.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            item = item.setNextItem(new CryptographicCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, certificate, bestSignatureTime, this.policy.getCertificateCryptographicConstraint(Context.SIGNATURE, subContext)));
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDataReliableAtBestSignatureTime(ChainItem<XmlValidationProcessLongTermData> item, Map<CertificateRevocationWrapper, SubContext> revocationDataToUse, Date bestSignatureTime) {
        ArrayList<String> checkedTokenIds = new ArrayList<String>();
        for (CertificateRevocationWrapper revocationData : revocationDataToUse.keySet()) {
            item = this.checkRevocationAgainstBestSignatureTime(item, revocationData, bestSignatureTime, checkedTokenIds);
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> checkRevocationAgainstBestSignatureTime(ChainItem<XmlValidationProcessLongTermData> item, RevocationWrapper revocationData, Date bestSignatureTime, List<String> checkedTokenIds) {
        XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(revocationData.getId());
        if (!checkedTokenIds.contains(revocationData.getId()) && revocationBBB != null && this.isCryptoConstraintFailureNoPoe(revocationBBB.getConclusion())) {
            item = item.setNextItem(new CryptographicCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, revocationData, bestSignatureTime, this.policy.getSignatureCryptographicConstraint(Context.REVOCATION)));
            checkedTokenIds.add(revocationData.getId());
            XmlXCV xcv = revocationBBB.getXCV();
            if (xcv != null && this.isCryptoConstraintFailureNoPoe(xcv.getConclusion())) {
                for (XmlSubXCV subXCV : xcv.getSubXCV()) {
                    if (checkedTokenIds.contains(subXCV.getId()) || !this.isCryptoConstraintFailureNoPoe(subXCV.getConclusion())) continue;
                    CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateById(subXCV.getId());
                    SubContext subContext = revocationData.getSigningCertificate().getId().equals(certificateWrapper.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
                    item = item.setNextItem(new CryptographicCheck<XmlValidationProcessLongTermData>(this.i18nProvider, (XmlValidationProcessLongTermData)this.result, certificateWrapper, bestSignatureTime, this.policy.getCertificateCryptographicConstraint(Context.REVOCATION, subContext)));
                    if (subXCV.getRFC() == null || !this.isCryptoConstraintFailureNoPoe(subXCV.getRFC().getConclusion())) continue;
                    RevocationWrapper revocationWrapper = this.diagnosticData.getRevocationById(subXCV.getRFC().getId());
                    item = this.checkRevocationAgainstBestSignatureTime(item, revocationWrapper, bestSignatureTime, checkedTokenIds);
                }
            }
        }
        return item;
    }

    private boolean isCryptoConstraintFailureNoPoe(XmlConclusion conclusion) {
        return Indication.INDETERMINATE.equals(conclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication());
    }
}

