/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class POEComparator
implements Comparator<POE>,
Serializable {
    private static final long serialVersionUID = -4256501779628944917L;

    @Override
    public int compare(POE poe1, POE poe2) {
        int result = poe1.getTime().compareTo(poe2.getTime());
        if (result == 0) {
            if (poe1.isTimestampPoe() && !poe2.isTimestampPoe()) {
                result = -1;
            } else if (!poe1.isTimestampPoe() && poe2.isTimestampPoe()) {
                result = 1;
            }
        }
        if (result == 0) {
            TimestampType poe1TstType = poe1.getTimestampType();
            TimestampType poe2TstType = poe2.getTimestampType();
            if (poe1TstType != null && poe2TstType != null) {
                result = poe1TstType.compare(poe2TstType);
            }
        }
        if (result == 0) {
            List<XmlTimestampedObject> poe1References = poe1.getTimestampedObjects();
            List<XmlTimestampedObject> poe2References = poe2.getTimestampedObjects();
            if (poe1References != null && poe2References != null) {
                if (poe1References.size() < poe2References.size()) {
                    result = -1;
                } else if (poe1References.size() > poe2References.size()) {
                    result = 1;
                }
            }
        }
        return result;
    }

    public boolean before(POE poeOne, POE poeTwo) {
        return this.compare(poeOne, poeTwo) == -1;
    }
}

