/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpftsp.checks.TimestampBasicBuildingBlocksCheck;
import java.util.Map;

public class ValidationProcessForTimeStamp
extends Chain<XmlValidationProcessTimestamp> {
    private final DiagnosticData diagnosticData;
    private final TimestampWrapper timestamp;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;

    public ValidationProcessForTimeStamp(I18nProvider i18nProvider, DiagnosticData diagnosticData, TimestampWrapper timestamp, Map<String, XmlBasicBuildingBlocks> bbbs) {
        super(i18nProvider, new XmlValidationProcessTimestamp());
        this.diagnosticData = diagnosticData;
        this.timestamp = timestamp;
        this.bbbs = bbbs;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFTSP;
    }

    @Override
    protected void initChain() {
        this.firstItem = this.timestampBasicBuildingBlocksValid();
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationProcessTimestamp)this.result).setType(this.timestamp.getType().name());
        ((XmlValidationProcessTimestamp)this.result).setProductionTime(this.timestamp.getProductionTime());
    }

    private ChainItem<XmlValidationProcessTimestamp> timestampBasicBuildingBlocksValid() {
        XmlBasicBuildingBlocks timestampBBB = this.bbbs.get(this.timestamp.getId());
        if (timestampBBB == null) {
            throw new IllegalStateException(String.format("Missing Basic Building Blocks result for token '%s'", this.timestamp.getId()));
        }
        return new TimestampBasicBuildingBlocksCheck(this.i18nProvider, (XmlValidationProcessTimestamp)this.result, this.diagnosticData, timestampBBB, this.bbbs, this.getFailLevelConstraint());
    }
}

