/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESTimestampParameters;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.TimestampContainerForm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteMultipleDocumentsSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTimestampParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMultipleDocumentsSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteMultipleDocumentsSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMultipleDocumentsSignatureServiceImpl.class);
    private MultipleDocumentsSignatureService<XAdESSignatureParameters, XAdESTimestampParameters> xadesService;
    private MultipleDocumentsSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters> asicWithCAdESService;
    private MultipleDocumentsSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> asicWithXAdESService;

    public void setXadesService(MultipleDocumentsSignatureService<XAdESSignatureParameters, XAdESTimestampParameters> xadesService) {
        this.xadesService = xadesService;
    }

    public void setAsicWithCAdESService(MultipleDocumentsSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters> asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    public void setAsicWithXAdESService(MultipleDocumentsSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    private MultipleDocumentsSignatureService getServiceForSignature(SignatureForm signatureForm, ASiCContainerType asicContainerType) {
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + (Object)((Object)signatureForm));
        }
        if (SignatureForm.XAdES == signatureForm) {
            return this.xadesService;
        }
        throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC or XAdES) : " + (Object)((Object)signatureForm));
    }

    private MultipleDocumentsSignatureService getServiceForTimestamp(TimestampContainerForm timestampContainerForm) {
        if (timestampContainerForm != null) {
            switch (timestampContainerForm) {
                case ASiC_E: 
                case ASiC_S: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException(String.format("The format is not recognized or not allowed (only ASiC-E and ASiC-S are allowed for a multiple document timestamping)", timestampContainerForm.getReadable()));
        }
        throw new DSSException("The timestampContainerForm must be defined!");
    }

    @Override
    public ToBeSignedDTO getDataToSign(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("GetDataToSign in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toSignDocuments);
        ToBeSigned dataToSign = service.getDataToSign(dssDocuments, parameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO(dataToSign);
    }

    @Override
    public RemoteDocument signDocument(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters, SignatureValueDTO signatureValueDTO) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("SignDocument in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toSignDocuments);
        DSSDocument signDocument = service.signDocument(dssDocuments, parameters, this.toSignatureValue(signatureValueDTO));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(signDocument);
    }

    @Override
    public RemoteDocument extendDocument(RemoteDocument toExtendDocument, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(toExtendDocument, "toSignDocuments must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("ExtendDocument in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(toExtendDocument);
        DSSDocument extendDocument = service.extendDocument(dssDocument, parameters);
        LOG.info("ExtendDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(extendDocument);
    }

    @Override
    public RemoteDocument timestamp(List<RemoteDocument> toTimestampDocuments, RemoteTimestampParameters remoteParameters) {
        Objects.requireNonNull(toTimestampDocuments, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getTimestampContainerForm(), "timestampContainerForm must be defined!");
        LOG.info("Timestamp document in process...");
        TimestampParameters parameters = this.toTimestampParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForTimestamp(remoteParameters.getTimestampContainerForm());
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toTimestampDocuments);
        DSSDocument timestampedDocument = service.timestamp(dssDocuments, parameters);
        LOG.info("Timestamp document is finished");
        return RemoteDocumentConverter.toRemoteDocument(timestampedDocument);
    }
}

