/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;

public class AllDataObjectsTimeStampBuilder {
    private final TSPSource tspSource;
    private final XAdESTimestampParameters timestampParameters;

    public AllDataObjectsTimeStampBuilder(TSPSource tspSource, XAdESTimestampParameters timestampParameters) {
        this.tspSource = tspSource;
        this.timestampParameters = timestampParameters;
    }

    public TimestampToken build(DSSDocument document) {
        return this.build(Arrays.asList(document));
    }

    public TimestampToken build(List<DSSDocument> documents) {
        byte[] dataToBeDigested = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (DSSDocument document : documents) {
                byte[] binaries = DSSUtils.toByteArray(document);
                if (DomUtils.isDOM(binaries)) {
                    binaries = DSSXMLUtils.canonicalize(this.timestampParameters.getCanonicalizationMethod(), binaries);
                }
                baos.write(binaries);
            }
            dataToBeDigested = baos.toByteArray();
        }
        catch (IOException e) {
            throw new DSSException("Unable to compute the data to be digested", e);
        }
        byte[] digestToTimestamp = DSSUtils.digest(this.timestampParameters.getDigestAlgorithm(), dataToBeDigested);
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(this.timestampParameters.getDigestAlgorithm(), digestToTimestamp);
        try {
            TimestampToken token = new TimestampToken(timeStampResponse.getBytes(), TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
            token.setCanonicalizationMethod(this.timestampParameters.getCanonicalizationMethod());
            return token;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot build an AllDataObjectsTimestamp", e);
        }
    }
}

