/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestValidator.class);
    private final Element signatureElement;
    private final Node manifestNode;
    private final List<DSSDocument> detachedContents;

    ManifestValidator(Element signatureElement, Node manifestNode, List<DSSDocument> detachedContents) {
        this.signatureElement = signatureElement;
        this.manifestNode = manifestNode;
        this.detachedContents = detachedContents;
    }

    List<ReferenceValidation> validate() {
        LOG.info("Validation of the manifest references ...");
        ArrayList<ReferenceValidation> result = new ArrayList<ReferenceValidation>();
        NodeList nodeList = DomUtils.getNodeList(this.manifestNode, XMLDSigPaths.REFERENCE_PATH);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element refNode = (Element)nodeList.item(i);
                String uri = refNode.getAttribute("URI");
                if (DomUtils.isElementReference(uri)) {
                    result.add(this.getInternalReferenceValidation(refNode, uri));
                    continue;
                }
                result.add(this.getDetachedReferenceValidation(refNode, uri));
            }
        }
        return result;
    }

    private List<String> getTransformNames(Element refNode) {
        ArrayList<String> transfromNames = new ArrayList<String>();
        NodeList nodeList = DomUtils.getNodeList(refNode, XMLDSigPaths.TRANSFORMS_TRANSFORM_PATH);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                Element transformElement = (Element)nodeList.item(ii);
                String algorithm = transformElement.getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
                if (!Utils.isStringNotBlank(algorithm)) continue;
                transfromNames.add(algorithm);
            }
        }
        return transfromNames;
    }

    private ReferenceValidation getInternalReferenceValidation(Element refNode, String uri) {
        ReferenceValidation refValidation = this.getReferenceValidationWithDigest(refNode, uri);
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement.getOwnerDocument().getDocumentElement(), "//*" + DomUtils.getXPathByIdAttribute(uri));
        if (nodeList != null && nodeList.getLength() == 1) {
            refValidation.setFound(true);
            refValidation.setIntact(this.isIntact(refValidation, nodeList.item(0)));
        } else {
            refValidation.setFound(false);
        }
        return refValidation;
    }

    private ReferenceValidation getDetachedReferenceValidation(Element refNode, String uri) {
        ReferenceValidation refValidation = this.getReferenceValidationWithDigest(refNode, uri);
        DSSDocument doc = this.findByFilename(uri);
        if (doc != null) {
            refValidation.setFound(true);
            refValidation.setIntact(this.isIntact(refValidation, doc));
        } else {
            refValidation.setFound(false);
        }
        return refValidation;
    }

    private ReferenceValidation getReferenceValidationWithDigest(Element refNode, String uri) {
        ReferenceValidation refValidation = new ReferenceValidation();
        refValidation.setType(DigestMatcherType.MANIFEST_ENTRY);
        refValidation.setName(uri);
        Digest digest = this.getReferenceDigest(refNode);
        refValidation.setDigest(digest);
        refValidation.setTransformationNames(this.getTransformNames(refNode));
        return refValidation;
    }

    private Digest getReferenceDigest(Element refNode) {
        try {
            String digestAlgoUri = DomUtils.getValue(refNode, XMLDSigPaths.DIGEST_METHOD_ALGORITHM_PATH);
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML(digestAlgoUri);
            String digestValueB64 = DomUtils.getValue(refNode, XMLDSigPaths.DIGEST_VALUE_PATH);
            return new Digest(digestAlgorithm, Utils.fromBase64(digestValueB64));
        }
        catch (Exception e) {
            LOG.warn("Unable to extract the digest combination : {}", (Object)e.getMessage());
            return null;
        }
    }

    private DSSDocument findByFilename(String filename) {
        if (this.detachedContents != null) {
            for (DSSDocument dssDocument : this.detachedContents) {
                if (!Utils.areStringsEqual(filename, dssDocument.getName())) continue;
                return dssDocument;
            }
        }
        return null;
    }

    private boolean isIntact(ReferenceValidation referenceValidation, DSSDocument doc) {
        Digest digest = referenceValidation.getDigest();
        if (digest == null) {
            return false;
        }
        try {
            if (Utils.isCollectionNotEmpty(referenceValidation.getTransformationNames())) {
                Document documentDOM = DomUtils.buildDOM(doc);
                return this.isIntact(referenceValidation, documentDOM);
            }
            String documentDigestB64 = doc.getDigest(digest.getAlgorithm());
            return Arrays.equals(digest.getValue(), Utils.fromBase64(documentDigestB64));
        }
        catch (Exception e) {
            LOG.warn("Unable to verify integrity for document '{}' : {}", (Object)doc.getName(), (Object)e.getMessage());
            return false;
        }
    }

    private boolean isIntact(ReferenceValidation referenceValidation, Node node) {
        Digest digest = referenceValidation.getDigest();
        if (digest == null) {
            return false;
        }
        try {
            List<Transform> transforms = this.getTransforms(referenceValidation.getTransformationNames());
            byte[] bytesAfterTransforms = this.getBytesAfterTransforms(node, transforms);
            return Arrays.equals(digest.getValue(), DSSUtils.digest(digest.getAlgorithm(), bytesAfterTransforms));
        }
        catch (Exception e) {
            LOG.warn("Unable to verify integrity for element '{}' : {}", (Object)node.getLocalName(), (Object)e.getMessage());
            return false;
        }
    }

    private List<Transform> getTransforms(List<String> transformNames) throws InvalidTransformException {
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        for (String algorithm : transformNames) {
            transforms.add(new Transform(this.signatureElement.getOwnerDocument(), algorithm));
        }
        return transforms;
    }

    private byte[] getBytesAfterTransforms(Node nodeToTransform, List<Transform> transforms) throws DSSException {
        try {
            XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(nodeToTransform);
            for (Transform transform : transforms) {
                xmlSignatureInput = transform.performTransform(xmlSignatureInput);
            }
            return xmlSignatureInput.getBytes();
        }
        catch (Exception e) {
            throw new DSSException("An error occurred during applying of transformations. Transforms cannot be performed!", e);
        }
    }
}

