/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSignatureParameters<TP extends SerializableTimestampParameters>
extends AbstractSerializableSignatureParameters<TP> {
    private String deterministicId;
    private List<DSSDocument> detachedContents;
    private CertificateToken signingCertificate;
    private byte[] signedData;
    private List<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
    private List<TimestampToken> contentTimestamps;

    public List<TimestampToken> getContentTimestamps() {
        return this.contentTimestamps;
    }

    public void setContentTimestamps(List<TimestampToken> contentTimestamps) {
        this.contentTimestamps = contentTimestamps;
    }

    public String getDeterministicId() {
        if (this.deterministicId == null) {
            TokenIdentifier identifier = this.signingCertificate == null ? null : this.signingCertificate.getDSSId();
            this.deterministicId = DSSUtils.getDeterministicId(this.bLevel().getSigningDate(), identifier);
        }
        return this.deterministicId;
    }

    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public CertificateToken getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(CertificateToken signingCertificate) {
        this.signingCertificate = signingCertificate;
        this.setEncryptionAlgorithm(EncryptionAlgorithm.forKey(signingCertificate.getPublicKey()));
    }

    public byte[] getSignedData() {
        return this.signedData;
    }

    public void setSignedData(byte[] signedData) {
        this.signedData = signedData;
    }

    public List<CertificateToken> getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(List<CertificateToken> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void setCertificateChain(CertificateToken ... certificateChainArray) {
        for (CertificateToken certificate : certificateChainArray) {
            if (certificate == null || this.certificateChain.contains(certificate)) continue;
            this.certificateChain.add(certificate);
        }
    }

    public void reinitDeterministicId() {
        this.deterministicId = null;
    }
}

