/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asics;

import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.AbstractGetDataToSignASiCSWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCSWithCAdESFromArchive
extends AbstractGetDataToSignASiCSWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final List<DSSDocument> embeddedSignatures;
    private final List<DSSDocument> embeddedTimestamps;
    private final List<DSSDocument> embeddedSignedFiles;
    private final ASiCParameters asicParameters;

    public DataToSignASiCSWithCAdESFromArchive(ASiCExtractResult result, ASiCParameters asicParameters) {
        this.embeddedSignatures = result.getSignatureDocuments();
        this.embeddedTimestamps = result.getTimestampDocuments();
        this.embeddedSignedFiles = result.getSignedDocuments();
        this.asicParameters = asicParameters;
    }

    @Override
    public String getSignatureFilename() {
        return this.getSignatureFileName(this.asicParameters);
    }

    @Override
    public String getTimestampFilename() {
        return this.getTimestampFileName();
    }

    @Override
    public DSSDocument getToBeSigned() {
        int nbEmbeddedSignatures = Utils.collectionSize(this.embeddedSignatures);
        if (nbEmbeddedSignatures != 1) {
            throw new DSSException("Unable to select the embedded signature (nb found:" + nbEmbeddedSignatures + ")");
        }
        return this.embeddedSignatures.get(0);
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.getSignedDocuments();
    }

    @Override
    public List<DSSDocument> getSignedDocuments() {
        int nbSignedFiles = Utils.collectionSize(this.embeddedSignedFiles);
        if (nbSignedFiles != 1) {
            throw new DSSException("Unable to select the document to be signed (nb found:" + nbSignedFiles + ")");
        }
        return this.embeddedSignedFiles;
    }

    @Override
    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getSignatures() {
        return this.embeddedSignatures;
    }

    @Override
    public List<DSSDocument> getArchiveManifestFiles() {
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getTimestamps() {
        return this.embeddedTimestamps;
    }
}

