/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import java.util.Collection;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;

public final class CAdESSignatureIdentifier
extends SignatureIdentifier {
    private static final long serialVersionUID = -26714442410369595L;

    public CAdESSignatureIdentifier(CAdESSignature cadesSignature) {
        super(CAdESSignatureIdentifier.buildBinaries(cadesSignature));
    }

    private static byte[] buildBinaries(CAdESSignature cadesSignature) {
        CertificateToken certificateToken = cadesSignature.getSigningCertificateToken();
        TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
        Integer uniqueInteger = CAdESSignatureIdentifier.getUniqueIntegerIfNeeded(cadesSignature);
        if (uniqueInteger == 0) {
            uniqueInteger = null;
        }
        String masterSignatureId = CAdESSignatureIdentifier.getMasterSignatureId(cadesSignature);
        String fileName = cadesSignature.getSignatureFilename();
        return SignatureIdentifier.buildSignatureIdentifier(cadesSignature.getSigningTime(), identifier, uniqueInteger, masterSignatureId, fileName);
    }

    private static int getUniqueIntegerIfNeeded(CAdESSignature cadesSignature) {
        SignerId signerId = cadesSignature.getSignerId();
        Collection<SignerInformation> signerInformations = cadesSignature.isCounterSignature() ? cadesSignature.getSignerInformation().getCounterSignatures().getSigners(signerId) : cadesSignature.getCmsSignedData().getSignerInfos().getSigners(signerId);
        int counter = 0;
        for (SignerInformation currentSignerInformation : signerInformations) {
            if (cadesSignature.getSignerInformation() == currentSignerInformation) break;
            ++counter;
        }
        return counter;
    }

    private static String getMasterSignatureId(CAdESSignature cadesSignature) {
        AdvancedSignature masterSignature = cadesSignature.getMasterSignature();
        if (masterSignature != null) {
            return masterSignature.getId();
        }
        return null;
    }
}

