/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.i18n;

import eu.europa.esig.dss.i18n.MessageTag;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nProvider {
    private static final Logger LOG = LoggerFactory.getLogger(I18nProvider.class);
    private static final String MESSAGES = "dss-messages";
    private final ResourceBundle bundle;
    private final Set<String> keySet;

    public I18nProvider() {
        this(Locale.getDefault());
    }

    public I18nProvider(Locale locale) {
        this.bundle = ResourceBundle.getBundle(MESSAGES, locale);
        this.keySet = this.bundle.keySet();
    }

    public String getMessage(MessageTag messageTag) {
        if (messageTag == null) {
            throw new IllegalArgumentException("messageTag cannot be null!");
        }
        if (this.keySet.contains(messageTag.getId())) {
            String patternString = this.bundle.getString(messageTag.getId());
            return MessageFormat.format(patternString, this.getArgs(messageTag));
        }
        LOG.warn("A value for the MessageTag [{}] not defined!", (Object)messageTag.getId());
        return messageTag.getId();
    }

    private Object[] getArgs(MessageTag messageTag) {
        Object[] args = null;
        if (messageTag.getArgs() != null) {
            args = (Object[])messageTag.getArgs().clone();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof MessageTag)) continue;
                args[i] = this.getMessage((MessageTag)((Object)args[i]));
            }
        }
        return args;
    }
}

