/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESCertificateSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESSignatureIdentifier;
import eu.europa.esig.dss.pades.validation.PAdESTimestampSource;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.PdfRevision;
import eu.europa.esig.dss.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PAdESSignature
extends CAdESSignature {
    private static final long serialVersionUID = 3818555396958720967L;
    private final PdfSignatureRevision pdfSignatureRevision;
    private final List<PdfRevision> documentRevisions;

    protected PAdESSignature(PdfSignatureRevision pdfSignatureRevision, List<PdfRevision> documentRevisions) {
        super(pdfSignatureRevision.getCMSSignedData(), DSSASN1Utils.getFirstSignerInformation(pdfSignatureRevision.getCMSSignedData()));
        this.pdfSignatureRevision = pdfSignatureRevision;
        this.documentRevisions = documentRevisions;
        this.detachedContents = Arrays.asList(new InMemoryDocument(pdfSignatureRevision.getRevisionCoveredBytes()));
    }

    @Override
    public SignatureForm getSignatureForm() {
        if (this.hasPKCS7SubFilter()) {
            return SignatureForm.PKCS7;
        }
        return SignatureForm.PAdES;
    }

    @Override
    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new PAdESCertificateSource(this.pdfSignatureRevision, this.getSignerInformation());
        }
        return this.offlineCertificateSource;
    }

    @Override
    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new PAdESCRLSource(this.pdfSignatureRevision.getDssDictionary(), this.getVRIKey(), this.getSignerInformation().getSignedAttributes());
        }
        return this.signatureCRLSource;
    }

    @Override
    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new PAdESOCSPSource(this.pdfSignatureRevision.getDssDictionary(), this.getVRIKey(), this.getSignerInformation().getSignedAttributes());
        }
        return this.signatureOCSPSource;
    }

    @Override
    public PAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new PAdESTimestampSource(this, this.documentRevisions);
        }
        return (PAdESTimestampSource)this.signatureTimestampSource;
    }

    @Override
    public Date getSigningTime() {
        return this.pdfSignatureRevision.getSigningDate();
    }

    @Override
    public SignatureProductionPlace getSignatureProductionPlace() {
        String location = this.pdfSignatureRevision.getPdfSigDictInfo().getLocation();
        if (Utils.isStringBlank(location)) {
            return super.getSignatureProductionPlace();
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        signatureProductionPlace.setCountryName(location);
        return signatureProductionPlace;
    }

    @Override
    public String getContentIdentifier() {
        return null;
    }

    @Override
    public String getContentHints() {
        return null;
    }

    @Override
    public List<AdvancedSignature> getCounterSignatures() {
        return Collections.emptyList();
    }

    @Override
    public SignatureIdentifier buildSignatureIdentifier() {
        return new PAdESSignatureIdentifier(this);
    }

    @Override
    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] contents = this.getPdfSignatureDictionary().getContents();
        byte[] digestValue = DSSUtils.digest(digestAlgorithm, contents);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    @Override
    public SignatureLevel getDataFoundUpToLevel() {
        if (this.hasCAdESDetachedSubFilter()) {
            if (this.hasLTProfile() && this.hasDSSDictionary()) {
                if (this.hasLTAProfile()) {
                    return SignatureLevel.PAdES_BASELINE_LTA;
                }
                if (this.hasTProfile()) {
                    return SignatureLevel.PAdES_BASELINE_LT;
                }
            }
            if (this.hasTProfile()) {
                return SignatureLevel.PAdES_BASELINE_T;
            }
            return SignatureLevel.PAdES_BASELINE_B;
        }
        if (this.hasPKCS7SubFilter()) {
            if (this.hasLTProfile()) {
                if (this.hasLTAProfile()) {
                    return SignatureLevel.PKCS7_LTA;
                }
                if (this.hasTProfile()) {
                    return SignatureLevel.PKCS7_LT;
                }
            }
            if (this.hasTProfile()) {
                return SignatureLevel.PKCS7_T;
            }
            return SignatureLevel.PKCS7_B;
        }
        return SignatureLevel.PDF_NOT_ETSI;
    }

    private boolean hasDSSDictionary() {
        return this.getDssDictionary() != null;
    }

    public PdfDssDict getDssDictionary() {
        return this.pdfSignatureRevision.getDssDictionary();
    }

    private boolean hasCAdESDetachedSubFilter() {
        return this.pdfSignatureRevision != null && "ETSI.CAdES.detached".equals(this.pdfSignatureRevision.getPdfSigDictInfo().getSubFilter());
    }

    private boolean hasPKCS7SubFilter() {
        return this.pdfSignatureRevision != null && "adbe.pkcs7.detached".equals(this.pdfSignatureRevision.getPdfSigDictInfo().getSubFilter());
    }

    @Override
    public SignatureLevel[] getSignatureLevels() {
        return new SignatureLevel[]{SignatureLevel.PDF_NOT_ETSI, SignatureLevel.PAdES_BASELINE_B, SignatureLevel.PKCS7_B, SignatureLevel.PAdES_BASELINE_T, SignatureLevel.PKCS7_T, SignatureLevel.PAdES_BASELINE_LT, SignatureLevel.PKCS7_LT, SignatureLevel.PAdES_BASELINE_LTA, SignatureLevel.PKCS7_LTA};
    }

    @Override
    public PdfSignatureRevision getPdfRevision() {
        return this.pdfSignatureRevision;
    }

    public PdfSignatureDictionary getPdfSignatureDictionary() {
        return this.pdfSignatureRevision.getPdfSigDictInfo();
    }

    public String getVRIKey() {
        byte[] digest = DSSUtils.digest(DigestAlgorithm.SHA1, this.getPdfSignatureDictionary().getContents());
        String vriId = Utils.toHex(digest);
        return vriId.toUpperCase();
    }
}

