/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ImageMerger.class);

    private ImageMerger() {
    }

    public static BufferedImage mergeOnTop(BufferedImage bottom, BufferedImage top, Color bgColor, SignerTextHorizontalAlignment imageHorizontalAlignment) {
        if (bottom == null) {
            return top;
        }
        if (top == null) {
            return bottom;
        }
        int newImageWidth = Math.max(bottom.getWidth(), top.getWidth());
        int newImageHeigth = bottom.getHeight() + top.getHeight();
        int imageType = ImageMerger.getImageType(bottom, top);
        BufferedImage combined = new BufferedImage(newImageWidth, newImageHeigth, imageType);
        Graphics2D g2 = combined.createGraphics();
        CommonDrawerUtils.initRendering(g2);
        ImageMerger.fillBackground(g2, newImageWidth, newImageHeigth, bgColor);
        switch (imageHorizontalAlignment) {
            case LEFT: {
                g2.drawImage(bottom, 0, top.getHeight(), bottom.getWidth(), bottom.getHeight(), null);
                g2.drawImage(top, 0, 0, top.getWidth(), top.getHeight(), null);
                break;
            }
            case CENTER: {
                g2.drawImage(bottom, (newImageWidth - bottom.getWidth()) / 2, top.getHeight(), bottom.getWidth(), bottom.getHeight(), null);
                g2.drawImage(top, (newImageWidth - top.getWidth()) / 2, 0, top.getWidth(), top.getHeight(), null);
                break;
            }
            case RIGHT: {
                g2.drawImage(bottom, newImageWidth - bottom.getWidth(), top.getHeight(), bottom.getWidth(), bottom.getHeight(), null);
                g2.drawImage(top, newImageWidth - top.getWidth(), 0, top.getWidth(), top.getHeight(), null);
                break;
            }
            default: {
                throw new DSSException("Unsupported SignerTextImageVerticalAlignment : " + (Object)((Object)imageHorizontalAlignment));
            }
        }
        return combined;
    }

    public static BufferedImage mergeOnRight(BufferedImage left, BufferedImage right, Color bgColor, SignerTextVerticalAlignment imageVerticalAlignment) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        int newImageWidth = left.getWidth() + right.getWidth();
        int newImageHeigth = Math.max(left.getHeight(), right.getHeight());
        int imageType = ImageMerger.getImageType(left, right);
        BufferedImage combined = new BufferedImage(newImageWidth, newImageHeigth, imageType);
        Graphics2D g2 = combined.createGraphics();
        CommonDrawerUtils.initRendering(g2);
        ImageMerger.fillBackground(g2, newImageWidth, newImageHeigth, bgColor);
        switch (imageVerticalAlignment) {
            case TOP: {
                g2.drawImage(left, 0, 0, left.getWidth(), left.getHeight(), null);
                g2.drawImage(right, left.getWidth(), 0, right.getWidth(), right.getHeight(), null);
                break;
            }
            case MIDDLE: {
                g2.drawImage(left, 0, (newImageHeigth - left.getHeight()) / 2, left.getWidth(), left.getHeight(), null);
                g2.drawImage(right, left.getWidth(), (newImageHeigth - right.getHeight()) / 2, right.getWidth(), right.getHeight(), null);
                break;
            }
            case BOTTOM: {
                g2.drawImage(left, 0, newImageHeigth - left.getHeight(), left.getWidth(), left.getHeight(), null);
                g2.drawImage(right, left.getWidth(), newImageHeigth - right.getHeight(), right.getWidth(), right.getHeight(), null);
                break;
            }
            default: {
                throw new DSSException("Unsupported SignerTextImageVerticalAlignment : " + (Object)((Object)imageVerticalAlignment));
            }
        }
        return combined;
    }

    private static void fillBackground(Graphics g2, int width, int heigth, Color bgColor) {
        g2.setColor(bgColor);
        g2.fillRect(0, 0, width, heigth);
    }

    private static int getImageType(BufferedImage image1, BufferedImage image2) {
        int imageType = 1;
        if (ImageUtils.isTransparent(image1) || ImageUtils.isTransparent(image2)) {
            LOG.warn("Transparency detected and enabled (Be aware: not valid with PDF/A !)");
            imageType = 2;
        }
        return imageType;
    }
}

