/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCertificateLoader
implements Serializable {
    private static final long serialVersionUID = -2560386894555266018L;
    private static final Logger LOG = LoggerFactory.getLogger(SSLCertificateLoader.class);
    private static final String PEER_CERTIFICATES = "PEER_CERTIFICATES";
    private CommonsDataLoader commonsDataLoader;

    public void setCommonsDataLoader(CommonsDataLoader commonsDataLoader) {
        this.commonsDataLoader = commonsDataLoader;
    }

    private CommonsDataLoader getCommonsDataLoader() {
        if (this.commonsDataLoader == null) {
            this.commonsDataLoader = new CommonsDataLoader();
        }
        return this.commonsDataLoader;
    }

    public List<CertificateToken> getCertificates(String urlString) throws DSSException {
        if (Protocol.isHttpUrl(urlString)) {
            Certificate[] httpGetCertificates = this.httpGetCertificates(urlString);
            return this.toCertificateTokens(httpGetCertificates);
        }
        throw new DSSException("DSS framework only supports HTTP(S) certificate extraction");
    }

    private Certificate[] httpGetCertificates(String url) throws DSSException {
        HttpGet httpRequest = null;
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient client = null;
        try {
            httpRequest = this.getCommonsDataLoader().getHttpRequest(url);
            client = this.getHttpClient(url);
            HttpHost targetHost = this.getCommonsDataLoader().getHttpHost(httpRequest);
            HttpContext localContext = this.getCommonsDataLoader().getHttpContext(targetHost);
            httpResponse = client.execute(targetHost, (HttpRequest)httpRequest, localContext);
            Certificate[] certificateArray = this.readCertificates(localContext);
            this.getCommonsDataLoader().closeQuietly(httpRequest, httpResponse, client);
            return certificateArray;
        }
        catch (IOException | URISyntaxException e) {
            try {
                throw new DSSExternalResourceException(String.format("Unable to process GET call for url [%s]. Reason : [%s]", url, DSSUtils.getExceptionMessage(e)), e);
            }
            catch (Throwable throwable) {
                this.getCommonsDataLoader().closeQuietly(httpRequest, httpResponse, client);
                throw throwable;
            }
        }
    }

    private List<CertificateToken> toCertificateTokens(Certificate[] certificates) {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        for (Certificate certificate : certificates) {
            try {
                certificateTokens.add(DSSUtils.loadCertificate(certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOG.warn("Cannot read and/or create an instance of a CertificateToken for a certificate : '{}'. The entry is skipped. Reason : {}", (Object)certificate, (Object)e.getMessage());
            }
        }
        return certificateTokens;
    }

    private Certificate[] readCertificates(HttpContext context) {
        Object attribute = context.getAttribute(PEER_CERTIFICATES);
        if (attribute instanceof Certificate[]) {
            return (Certificate[])attribute;
        }
        return new Certificate[0];
    }

    private synchronized CloseableHttpClient getHttpClient(String url) {
        HttpClientBuilder httpClientBuilder = this.getCommonsDataLoader().getHttpClientBuilder(url);
        httpClientBuilder.addInterceptorLast(this.getHttpResponseInterceptor());
        return httpClientBuilder.build();
    }

    private HttpResponseInterceptor getHttpResponseInterceptor() {
        return new HttpResponseInterceptor(){

            @Override
            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                ManagedHttpClientConnection routedConnection = (ManagedHttpClientConnection)context.getAttribute("http.connection");
                SSLSession sslSession = routedConnection.getSSLSession();
                if (sslSession != null) {
                    Certificate[] certificates = sslSession.getPeerCertificates();
                    context.setAttribute(SSLCertificateLoader.PEER_CERTIFICATES, certificates);
                }
            }
        };
    }
}

