/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.security.Security;
import java.util.Date;
import java.util.Objects;

public abstract class AbstractSignatureService<SP extends SerializableSignatureParameters, TP extends SerializableTimestampParameters>
implements DocumentSignatureService<SP, TP> {
    protected TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;

    protected AbstractSignatureService(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier cannot be null !");
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void assertSigningDateInCertificateValidityRange(SP parameters) {
        if (parameters.getSigningCertificate() == null) {
            if (parameters.isGenerateTBSWithoutCertificate()) {
                return;
            }
            throw new DSSException("Signing Certificate is not defined!");
        }
        if (parameters.isSignWithExpiredCertificate()) {
            return;
        }
        CertificateToken signingCertificate = parameters.getSigningCertificate();
        Date notAfter = signingCertificate.getNotAfter();
        Date notBefore = signingCertificate.getNotBefore();
        Date signingDate = parameters.bLevel().getSigningDate();
        if (signingDate.after(notAfter) || signingDate.before(notBefore)) {
            throw new DSSException(String.format("Signing Date (%s) is not in certificate validity range (%s, %s).", signingDate.toString(), notBefore.toString(), notAfter.toString()));
        }
    }

    protected String getFinalArchiveName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level, MimeType containerMimeType) {
        String extension;
        StringBuilder finalName = new StringBuilder();
        String originalName = null;
        originalName = containerMimeType != null ? "container" : originalFile.getName();
        if (Utils.isStringNotEmpty(originalName)) {
            int dotPosition = originalName.lastIndexOf(46);
            if (dotPosition > 0) {
                finalName.append(originalName.substring(0, dotPosition));
            } else {
                finalName.append(originalName);
            }
        } else {
            finalName.append("document");
        }
        if (SigningOperation.SIGN.equals((Object)operation)) {
            finalName.append("-signed");
        } else if (SigningOperation.TIMESTAMP.equals((Object)operation)) {
            finalName.append("-timestamped");
        } else if (SigningOperation.EXTEND.equals((Object)operation)) {
            finalName.append("-extended");
        }
        if (level != null) {
            finalName.append('-');
            finalName.append(Utils.lowerCase(level.name().replace("_", "-")));
        }
        if ((extension = this.getFileExtensionString(level, containerMimeType)) != null) {
            finalName.append('.');
            finalName.append(extension);
        }
        return finalName.toString();
    }

    private String getFileExtensionString(SignatureLevel level, MimeType containerMimeType) {
        if (containerMimeType != null) {
            return MimeType.getExtension(containerMimeType);
        }
        if (level != null) {
            SignatureForm signatureForm = level.getSignatureForm();
            switch (signatureForm) {
                case XAdES: {
                    return "xml";
                }
                case CAdES: {
                    return "pkcs7";
                }
                case PAdES: {
                    return "pdf";
                }
            }
            throw new DSSException("Unable to generate a full document name");
        }
        return "pdf";
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level) {
        return this.getFinalArchiveName(originalFile, operation, level, null);
    }

    @Override
    public DSSDocument timestamp(DSSDocument toTimestampDocument, TP parameters) {
        throw new UnsupportedOperationException("Unsupported operation for this file format");
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

