/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;

public class ResponderId {
    private X500Principal subjectX500Principal;
    private byte[] ski;

    public ResponderId(X500Principal subjectX500Principal, byte[] ski) {
        this.subjectX500Principal = subjectX500Principal;
        this.ski = ski;
    }

    public X500Principal getX500Principal() {
        return this.subjectX500Principal;
    }

    public void setX500Principal(X500Principal subjectX500Principal) {
        this.subjectX500Principal = subjectX500Principal;
    }

    public byte[] getSki() {
        return this.ski;
    }

    public void setSki(byte[] ski) {
        this.ski = ski;
    }

    public boolean isRelatedToCertificate(CertificateToken certificateToken) {
        if (this.subjectX500Principal != null) {
            return DSSASN1Utils.x500PrincipalAreEquals(certificateToken.getSubject().getPrincipal(), this.subjectX500Principal);
        }
        return DSSASN1Utils.isSkiEqual(this.ski, certificateToken);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.ski);
        result = 31 * result + (this.subjectX500Principal == null ? 0 : this.subjectX500Principal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponderId other = (ResponderId)obj;
        if (!Arrays.equals(this.ski, other.ski)) {
            return false;
        }
        return !(this.subjectX500Principal == null ? other.subjectX500Principal != null : !this.subjectX500Principal.equals(other.subjectX500Principal));
    }
}

