/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.RevocationTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.util.Arrays;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPTokenRefMatcher
implements RevocationTokenRefMatcher<OCSP> {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPTokenRefMatcher.class);

    @Override
    public boolean match(RevocationToken<OCSP> token, RevocationRef<OCSP> reference) {
        OCSPToken ocspToken = (OCSPToken)token;
        OCSPRef ocspRef = (OCSPRef)reference;
        if (ocspRef.getDigest() != null) {
            return this.matchByDigest(ocspToken, ocspRef.getDigest());
        }
        return this.matchByProperties(ocspToken, ocspRef);
    }

    @Override
    public boolean match(EncapsulatedRevocationTokenIdentifier identifier, RevocationRef<OCSP> reference) {
        if (identifier instanceof OCSPResponseBinary) {
            OCSPResponseBinary ocspResponseBinary = (OCSPResponseBinary)identifier;
            OCSPRef ocspRef = (OCSPRef)reference;
            if (ocspRef.getDigest() != null) {
                return this.matchByDigest(ocspResponseBinary, ocspRef.getDigest());
            }
            return this.matchByProperties(ocspResponseBinary, ocspRef);
        }
        return false;
    }

    private boolean matchByDigest(OCSPToken ocspToken, Digest digestToFind) {
        return Arrays.equals(digestToFind.getValue(), ocspToken.getDigest(digestToFind.getAlgorithm()));
    }

    private boolean matchByDigest(OCSPResponseBinary ocspResponseBinary, Digest digestToFind) {
        return Arrays.equals(digestToFind.getValue(), ocspResponseBinary.getDigestValue(digestToFind.getAlgorithm()));
    }

    private boolean matchByProperties(OCSPToken ocspToken, OCSPRef ocspRef) {
        ResponderId refResponderId;
        ResponderID tokenResponderId;
        return ocspRef.getProducedAt().equals(ocspToken.getProductionDate()) && (this.matchByKeyHash(tokenResponderId = ocspToken.getBasicOCSPResp().getResponderId().toASN1Primitive(), refResponderId = ocspRef.getResponderId()) || this.matchByName(tokenResponderId, refResponderId));
    }

    private boolean matchByProperties(OCSPResponseBinary ocspResponseBinary, OCSPRef ocspRef) {
        try {
            ResponderId refResponderId;
            ResponderID tokenResponderId;
            BasicOCSPResp basicOCSPResp = ocspResponseBinary.getBasicOCSPResp();
            if (ocspRef.getProducedAt().equals(basicOCSPResp.getProducedAt()) && (this.matchByKeyHash(tokenResponderId = basicOCSPResp.getResponderId().toASN1Primitive(), refResponderId = ocspRef.getResponderId()) || this.matchByName(tokenResponderId, refResponderId))) {
                return true;
            }
        }
        catch (Exception e) {
            String errorMessage = "An exception occurred during an attempt to compare the OCSP binaries with a reference: {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
        return false;
    }

    private boolean matchByKeyHash(ResponderID tokenResponderId, ResponderId refResponderId) {
        return refResponderId.getSki() != null && Arrays.equals(refResponderId.getSki(), tokenResponderId.getKeyHash());
    }

    private boolean matchByName(ResponderID tokenResponderId, ResponderId refResponderId) {
        return refResponderId.getX500Principal() != null && tokenResponderId.getName() != null && refResponderId.getX500Principal().equals(DSSASN1Utils.toX500Principal(tokenResponderId.getName()));
    }
}

