/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.alerts.detections;

import eu.europa.esig.dss.alert.detector.AlertDetector;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.PivotInfo;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public class LOTLLocationChangeDetection
implements AlertDetector<LOTLInfo> {
    private final LOTLSource lotlSource;

    public LOTLLocationChangeDetection(LOTLSource lotlSource) {
        this.lotlSource = lotlSource;
    }

    @Override
    public boolean detect(LOTLInfo info) {
        List<PivotInfo> pivotInfos;
        if (Utils.areStringsEqual(this.lotlSource.getUrl(), info.getUrl()) && this.lotlSource.isPivotSupport() && Utils.isCollectionNotEmpty(pivotInfos = info.getPivotInfos())) {
            for (PivotInfo pivotInfo : pivotInfos) {
                if (Utils.areStringsEqual(pivotInfo.getLOTLLocation(), this.lotlSource.getUrl())) continue;
                return true;
            }
        }
        return false;
    }
}

