/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache;

import eu.europa.esig.dss.spi.DSSUtils;
import java.util.Objects;

public class CacheKey {
    private final String key;

    public CacheKey(String url) {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.key = DSSUtils.getNormalizedString(url);
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return String.format("CacheKey with the key [%s]", this.key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

