/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.alert.SilentOnStatusAlert;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CommonCertificateVerifier;

public class CertificateVerifierBuilder {
    private final CertificateVerifier certificateVerifier;

    public CertificateVerifierBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public CertificateVerifier buildCompleteCopy() {
        CommonCertificateVerifier copy = new CommonCertificateVerifier(true);
        if (this.certificateVerifier != null) {
            copy.setDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
            copy.setDataLoader(this.certificateVerifier.getDataLoader());
            copy.setCrlSource(this.certificateVerifier.getCrlSource());
            copy.setOcspSource(this.certificateVerifier.getOcspSource());
            copy.setCheckRevocationForUntrustedChains(this.certificateVerifier.isCheckRevocationForUntrustedChains());
            copy.setAdjunctCertSources(this.certificateVerifier.getAdjunctCertSources());
            copy.setTrustedCertSources(this.certificateVerifier.getTrustedCertSources());
            copy.setAlertOnInvalidTimestamp(this.certificateVerifier.getAlertOnInvalidTimestamp());
            copy.setAlertOnMissingRevocationData(this.certificateVerifier.getAlertOnMissingRevocationData());
            copy.setAlertOnNoRevocationAfterBestSignatureTime(this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime());
            copy.setAlertOnRevokedCertificate(this.certificateVerifier.getAlertOnRevokedCertificate());
            copy.setAlertOnUncoveredPOE(this.certificateVerifier.getAlertOnUncoveredPOE());
        }
        return copy;
    }

    public CertificateVerifier buildOfflineAndSilentCopy() {
        CommonCertificateVerifier offlineCertificateVerifier = new CommonCertificateVerifier(true);
        if (this.certificateVerifier != null) {
            offlineCertificateVerifier.setDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
            offlineCertificateVerifier.setAdjunctCertSources(this.certificateVerifier.getAdjunctCertSources());
            offlineCertificateVerifier.setTrustedCertSources(this.certificateVerifier.getTrustedCertSources());
        }
        offlineCertificateVerifier.setAlertOnInvalidTimestamp(new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnMissingRevocationData(new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnNoRevocationAfterBestSignatureTime(new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnRevokedCertificate(new SilentOnStatusAlert());
        offlineCertificateVerifier.setAlertOnUncoveredPOE(new SilentOnStatusAlert());
        return offlineCertificateVerifier;
    }
}

