/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCommitmentTypeIndication;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDistinguishedName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundCertificates;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundRevocations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlIssuerSerial;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificateToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocationToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanTokens;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPSD2Info;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPSD2Role;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocationRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureProductionPlace;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerDocumentRepresentations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.OidDescription;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.RoleOfPspOid;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.enumerations.TokenExtractionStategy;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.TokenComparator;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.spi.tsl.ConditionForQualifiers;
import eu.europa.esig.dss.spi.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.spi.tsl.TrustProperties;
import eu.europa.esig.dss.spi.tsl.TrustServiceProvider;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateIdentifier;
import eu.europa.esig.dss.spi.x509.CertificatePolicy;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.PSD2QcType;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.RoleOfPSP;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CommitmentTypeIndication;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DSSPKUtils;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.OidRepository;
import eu.europa.esig.dss.validation.PdfRevision;
import eu.europa.esig.dss.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.policy.BasicASNSignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampTokenComparator;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticDataBuilder.class);
    private DSSDocument signedDocument;
    private ContainerInfo containerInfo;
    private List<AdvancedSignature> signatures;
    private Set<CertificateToken> usedCertificates;
    private Map<CertificateToken, Set<CertificateSourceType>> certificateSourceTypes;
    private Set<RevocationToken<Revocation>> usedRevocations;
    private Set<TimestampToken> usedTimestamps;
    private ListCertificateSource trustedCertSources = new ListCertificateSource();
    private Date validationDate;
    private ListRevocationSource<CRL> commonCRLSource = new ListRevocationSource();
    private ListRevocationSource<OCSP> commonOCSPSource = new ListRevocationSource();
    private TokenExtractionStategy tokenExtractionStategy = TokenExtractionStategy.NONE;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private Map<String, XmlCertificate> xmlCertsMap = new HashMap<String, XmlCertificate>();
    private Map<String, XmlRevocation> xmlRevocationsMap = new HashMap<String, XmlRevocation>();
    private Map<String, XmlSignature> xmlSignaturesMap = new HashMap<String, XmlSignature>();
    private Map<String, XmlTimestamp> xmlTimestampsMap = new HashMap<String, XmlTimestamp>();
    private Map<String, XmlSignerData> xmlSignedDataMap = new HashMap<String, XmlSignerData>();
    private Map<String, XmlOrphanCertificateToken> xmlOrphanCertificateTokensMap = new HashMap<String, XmlOrphanCertificateToken>();
    private Map<String, XmlOrphanRevocationToken> xmlOrphanRevocationTokensMap = new HashMap<String, XmlOrphanRevocationToken>();
    private Map<String, XmlTrustedList> xmlTrustedListsMap = new HashMap<String, XmlTrustedList>();
    private Map<String, String> referenceMap = new HashMap<String, String>();
    private Map<String, CertificateToken> signingCertificateMap = new HashMap<String, CertificateToken>();

    public DiagnosticDataBuilder document(DSSDocument signedDocument) {
        this.signedDocument = signedDocument;
        return this;
    }

    public DiagnosticDataBuilder containerInfo(ContainerInfo containerInfo) {
        this.containerInfo = containerInfo;
        return this;
    }

    public DiagnosticDataBuilder foundSignatures(List<AdvancedSignature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public DiagnosticDataBuilder usedCertificates(Set<CertificateToken> usedCertificates) {
        this.usedCertificates = usedCertificates;
        return this;
    }

    public DiagnosticDataBuilder certificateSourceTypes(Map<CertificateToken, Set<CertificateSourceType>> certificateSourceTypes) {
        this.certificateSourceTypes = certificateSourceTypes;
        return this;
    }

    public DiagnosticDataBuilder usedRevocations(Set<RevocationToken<Revocation>> usedRevocations) {
        this.usedRevocations = usedRevocations;
        return this;
    }

    public DiagnosticDataBuilder usedTimestamps(Set<TimestampToken> usedTimestamps) {
        this.usedTimestamps = usedTimestamps;
        return this;
    }

    public DiagnosticDataBuilder tokenExtractionStategy(TokenExtractionStategy tokenExtractionStategy) {
        this.tokenExtractionStategy = tokenExtractionStategy;
        return this;
    }

    public DiagnosticDataBuilder setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.defaultDigestAlgorithm = digestAlgorithm;
        return this;
    }

    public DiagnosticDataBuilder trustedCertificateSources(ListCertificateSource trustedCertSources) {
        if (!trustedCertSources.areAllCertSourcesTrusted()) {
            throw new DSSException("Trusted CertificateSource must contain only sources of type TRUSTED_STORE or TRUSTED_LIST!");
        }
        this.trustedCertSources = trustedCertSources;
        return this;
    }

    public DiagnosticDataBuilder validationDate(Date validationDate) {
        this.validationDate = validationDate;
        return this;
    }

    public DiagnosticDataBuilder completeCRLSource(ListRevocationSource<CRL> completeCRLSource) {
        this.commonCRLSource = completeCRLSource;
        return this;
    }

    public DiagnosticDataBuilder completeOCSPSource(ListRevocationSource<OCSP> completeOCSPSource) {
        this.commonOCSPSource = completeOCSPSource;
        return this;
    }

    public XmlDiagnosticData build() {
        XmlDiagnosticData diagnosticData = new XmlDiagnosticData();
        if (this.signedDocument != null) {
            diagnosticData.setDocumentName(this.removeSpecialCharsForXml(this.signedDocument.getName()));
        }
        diagnosticData.setValidationDate(this.validationDate);
        diagnosticData.setContainerInfo(this.getXmlContainerInfo());
        Collection<XmlCertificate> xmlCertificates = this.buildXmlCertificates(this.usedCertificates);
        diagnosticData.getUsedCertificates().addAll(xmlCertificates);
        this.linkSigningCertificateAndChains(this.usedCertificates);
        Collection<XmlRevocation> xmlRevocations = this.buildXmlRevocations(this.usedRevocations);
        diagnosticData.getUsedRevocations().addAll(xmlRevocations);
        this.linkCertificatesAndRevocations(this.usedCertificates);
        Collection<XmlSignerData> xmlSignerData = this.buildXmlSignerDataList(this.signatures, this.usedTimestamps);
        diagnosticData.getOriginalDocuments().addAll(xmlSignerData);
        if (Utils.isCollectionNotEmpty(this.signatures)) {
            Collection<XmlSignature> xmlSignatures = this.buildXmlSignatures(this.signatures);
            diagnosticData.getSignatures().addAll(xmlSignatures);
            this.attachCounterSignatures(this.signatures);
        }
        if (Utils.isCollectionNotEmpty(this.usedTimestamps)) {
            List<XmlTimestamp> builtTimestamps = this.buildXmlTimestamps(this.usedTimestamps);
            diagnosticData.getUsedTimestamps().addAll(builtTimestamps);
            this.linkSignaturesAndTimestamps(this.signatures);
        }
        if (Utils.isMapNotEmpty(this.xmlOrphanCertificateTokensMap) || Utils.isMapNotEmpty(this.xmlOrphanRevocationTokensMap)) {
            diagnosticData.setOrphanTokens(this.buildXmlOrphanTokens());
        }
        if (Utils.isCollectionNotEmpty(this.usedTimestamps)) {
            this.linkTimestampsAndTimestampsObjects(this.usedTimestamps);
        }
        if (this.isUseTrustedLists()) {
            Collection<XmlTrustedList> trustedLists = this.buildXmlTrustedLists(this.trustedCertSources);
            diagnosticData.getTrustedLists().addAll(trustedLists);
            this.linkCertificatesAndTrustServices(this.usedCertificates);
        }
        return diagnosticData;
    }

    private boolean isUseTrustedLists() {
        if (!this.trustedCertSources.isEmpty()) {
            for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
                if (!(certificateSource instanceof TrustedListsCertificateSource)) continue;
                return true;
            }
        }
        return false;
    }

    private void linkTimestampsAndTimestampsObjects(Set<TimestampToken> timestamps) {
        for (TimestampToken timestampToken : timestamps) {
            XmlTimestamp xmlTimestampToken = this.xmlTimestampsMap.get(timestampToken.getDSSIdAsString());
            xmlTimestampToken.setTimestampedObjects(this.getXmlTimestampedObjects(timestampToken));
        }
    }

    private Collection<XmlCertificate> buildXmlCertificates(Set<CertificateToken> certificates) {
        ArrayList<XmlCertificate> builtCertificates = new ArrayList<XmlCertificate>();
        if (Utils.isCollectionNotEmpty(certificates)) {
            ArrayList<CertificateToken> tokens = new ArrayList<CertificateToken>(certificates);
            Collections.sort(tokens, new TokenComparator());
            for (CertificateToken certificateToken : tokens) {
                String id = certificateToken.getDSSIdAsString();
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(id);
                if (xmlCertificate == null) {
                    xmlCertificate = this.buildDetachedXmlCertificate(certificateToken);
                    this.xmlCertsMap.put(id, xmlCertificate);
                }
                builtCertificates.add(xmlCertificate);
            }
        }
        return builtCertificates;
    }

    private void linkSigningCertificateAndChains(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(certificateToken.getDSSIdAsString());
                xmlCertificate.setSigningCertificate(this.getXmlSigningCertificate(certificateToken));
                xmlCertificate.setCertificateChain(this.getXmlForCertificateChain(certificateToken));
            }
        }
    }

    private void linkCertificatesAndTrustServices(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(certificateToken.getDSSIdAsString());
                xmlCertificate.setTrustedServiceProviders(this.getXmlTrustedServiceProviders(certificateToken));
            }
        }
    }

    private Collection<XmlRevocation> buildXmlRevocations(Set<RevocationToken<Revocation>> revocations) {
        ArrayList<XmlRevocation> builtRevocations = new ArrayList<XmlRevocation>();
        if (Utils.isCollectionNotEmpty(revocations)) {
            ArrayList<RevocationToken<Revocation>> tokens = new ArrayList<RevocationToken<Revocation>>(revocations);
            Collections.sort(tokens, new TokenComparator());
            ArrayList<String> uniqueIds = new ArrayList<String>();
            for (RevocationToken revocationToken : tokens) {
                String id = revocationToken.getDSSIdAsString();
                if (uniqueIds.contains(id)) continue;
                XmlRevocation xmlRevocation = this.xmlRevocationsMap.get(id);
                if (xmlRevocation == null) {
                    xmlRevocation = this.buildDetachedXmlRevocation(revocationToken);
                    this.xmlRevocationsMap.put(id, xmlRevocation);
                    builtRevocations.add(xmlRevocation);
                }
                uniqueIds.add(id);
            }
        }
        return builtRevocations;
    }

    private void linkCertificatesAndRevocations(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(certificateToken.getDSSIdAsString());
                Set<RevocationToken<Revocation>> revocationsForCert = this.getRevocationsForCert(certificateToken);
                for (RevocationToken<Revocation> revocationToken : revocationsForCert) {
                    XmlRevocation xmlRevocation = this.xmlRevocationsMap.get(revocationToken.getDSSIdAsString());
                    XmlCertificateRevocation xmlCertificateRevocation = new XmlCertificateRevocation();
                    xmlCertificateRevocation.setRevocation(xmlRevocation);
                    xmlCertificateRevocation.setStatus(revocationToken.getStatus());
                    xmlCertificateRevocation.setRevocationDate(revocationToken.getRevocationDate());
                    xmlCertificateRevocation.setReason(revocationToken.getReason());
                    xmlCertificate.getRevocations().add(xmlCertificateRevocation);
                }
            }
        }
    }

    private Collection<XmlSignerData> buildXmlSignerDataList(Collection<AdvancedSignature> signatures, Collection<TimestampToken> timestamps) {
        XmlSignerData xmlSignerData;
        ArrayList<String> addedSignedDataIds = new ArrayList<String>();
        ArrayList<XmlSignerData> signerDataList = new ArrayList<XmlSignerData>();
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (AdvancedSignature signature : signatures) {
                if (!Utils.isCollectionNotEmpty(signature.getSignatureScopes())) continue;
                for (SignatureScope signatureScope : signature.getSignatureScopes()) {
                    if (addedSignedDataIds.contains(signatureScope.getDSSIdAsString())) continue;
                    xmlSignerData = this.buildXmlSignerData(signatureScope);
                    signerDataList.add(xmlSignerData);
                    addedSignedDataIds.add(signatureScope.getDSSIdAsString());
                }
            }
        }
        if (Utils.isCollectionNotEmpty(timestamps)) {
            for (TimestampToken timestampToken : timestamps) {
                if (!Utils.isCollectionNotEmpty(timestampToken.getTimestampScopes())) continue;
                for (SignatureScope signatureScope : timestampToken.getTimestampScopes()) {
                    if (addedSignedDataIds.contains(signatureScope.getDSSIdAsString())) continue;
                    xmlSignerData = this.buildXmlSignerData(signatureScope);
                    signerDataList.add(xmlSignerData);
                    addedSignedDataIds.add(signatureScope.getDSSIdAsString());
                }
            }
        }
        return signerDataList;
    }

    private XmlSignerData buildXmlSignerData(SignatureScope signatureScope) {
        String id = signatureScope.getDSSIdAsString();
        XmlSignerData xmlSignerData = this.xmlSignedDataMap.get(id);
        if (xmlSignerData == null) {
            xmlSignerData = this.getXmlSignerData(signatureScope);
            this.xmlSignedDataMap.put(id, xmlSignerData);
        }
        return xmlSignerData;
    }

    private Collection<XmlSignature> buildXmlSignatures(List<AdvancedSignature> signatures) {
        ArrayList<XmlSignature> builtSignatures = new ArrayList<XmlSignature>();
        for (AdvancedSignature advancedSignature : signatures) {
            String id = advancedSignature.getId();
            XmlSignature xmlSignature = this.xmlSignaturesMap.get(id);
            if (xmlSignature != null) continue;
            xmlSignature = this.buildDetachedXmlSignature(advancedSignature);
            this.xmlSignaturesMap.put(id, xmlSignature);
            builtSignatures.add(xmlSignature);
        }
        return builtSignatures;
    }

    private void attachCounterSignatures(List<AdvancedSignature> signatures) {
        for (AdvancedSignature advancedSignature : signatures) {
            if (!advancedSignature.isCounterSignature()) continue;
            XmlSignature currentSignature = this.xmlSignaturesMap.get(advancedSignature.getId());
            AdvancedSignature masterSignature = advancedSignature.getMasterSignature();
            XmlSignature xmlMasterSignature = this.xmlSignaturesMap.get(masterSignature.getId());
            currentSignature.setCounterSignature(true);
            currentSignature.setParent(xmlMasterSignature);
        }
    }

    private void linkSignaturesAndTimestamps(List<AdvancedSignature> signatures) {
        for (AdvancedSignature advancedSignature : signatures) {
            XmlSignature currentSignature = this.xmlSignaturesMap.get(advancedSignature.getId());
            currentSignature.setFoundTimestamps(this.getXmlFoundTimestamps(advancedSignature));
        }
    }

    private Collection<XmlTrustedList> buildXmlTrustedLists(ListCertificateSource trustedCertificateSources) {
        ArrayList<XmlTrustedList> trustedLists = new ArrayList<XmlTrustedList>();
        HashMap<Identifier, XmlTrustedList> mapTrustedLists = new HashMap<Identifier, XmlTrustedList>();
        HashMap mapListOfTrustedLists = new HashMap();
        for (CertificateSource certificateSource : trustedCertificateSources.getSources()) {
            if (!(certificateSource instanceof TrustedListsCertificateSource)) continue;
            TrustedListsCertificateSource tlCertSource = (TrustedListsCertificateSource)certificateSource;
            TLValidationJobSummary summary = tlCertSource.getSummary();
            if (summary != null) {
                Set<Identifier> tlIdentifiers = this.getTLIdentifiers(tlCertSource);
                for (Identifier tlId : tlIdentifiers) {
                    TLInfo tlInfoById;
                    if (mapTrustedLists.containsKey(tlId) || (tlInfoById = summary.getTLInfoById(tlId)) == null) continue;
                    mapTrustedLists.put(tlId, this.getXmlTrustedList(tlInfoById));
                }
                Set<Identifier> lotlIdentifiers = this.getLOTLIdentifiers(tlCertSource);
                for (Identifier lotlId : lotlIdentifiers) {
                    LOTLInfo lotlInfoById;
                    if (mapListOfTrustedLists.containsKey(lotlId) || (lotlInfoById = summary.getLOTLInfoById(lotlId)) == null) continue;
                    mapTrustedLists.put(lotlId, this.getXmlTrustedList(lotlInfoById));
                }
                continue;
            }
            LOG.warn("The TrustedListsCertificateSource does not contain TLValidationJobSummary. TLValidationJob is not performed!");
        }
        trustedLists.addAll(mapTrustedLists.values());
        trustedLists.addAll(mapListOfTrustedLists.values());
        return trustedLists;
    }

    private Set<Identifier> getTLIdentifiers(TrustedListsCertificateSource tlCS) {
        HashSet<Identifier> tlIdentifiers = new HashSet<Identifier>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            List<TrustProperties> trustServices = tlCS.getTrustServices(certificateToken);
            for (TrustProperties trustProperties : trustServices) {
                tlIdentifiers.add(trustProperties.getTLIdentifier());
            }
        }
        return tlIdentifiers;
    }

    private Set<Identifier> getLOTLIdentifiers(TrustedListsCertificateSource tlCS) {
        HashSet<Identifier> lotlIdentifiers = new HashSet<Identifier>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            List<TrustProperties> trustServices = tlCS.getTrustServices(certificateToken);
            for (TrustProperties trustProperties : trustServices) {
                Identifier lotlUrl = trustProperties.getLOTLIdentifier();
                if (lotlUrl == null) continue;
                lotlIdentifiers.add(lotlUrl);
            }
        }
        return lotlIdentifiers;
    }

    private XmlTrustedList getXmlTrustedList(TLInfo tlInfo) {
        String id = tlInfo.getIdentifier().asXmlId();
        XmlTrustedList result = this.xmlTrustedListsMap.get(id);
        if (result == null) {
            ValidationInfoRecord validationCacheInfo;
            DownloadInfoRecord downloadCacheInfo;
            result = new XmlTrustedList();
            if (tlInfo instanceof LOTLInfo) {
                result.setLOTL(true);
            }
            result.setId(id);
            result.setUrl(tlInfo.getUrl());
            ParsingInfoRecord parsingCacheInfo = tlInfo.getParsingCacheInfo();
            if (parsingCacheInfo != null) {
                result.setCountryCode(parsingCacheInfo.getTerritory());
                result.setIssueDate(parsingCacheInfo.getIssueDate());
                result.setNextUpdate(parsingCacheInfo.getNextUpdateDate());
                result.setSequenceNumber(parsingCacheInfo.getSequenceNumber());
                result.setVersion(parsingCacheInfo.getVersion());
            }
            if ((downloadCacheInfo = tlInfo.getDownloadCacheInfo()) != null) {
                result.setLastLoading(downloadCacheInfo.getLastSuccessSynchronizationTime());
            }
            if ((validationCacheInfo = tlInfo.getValidationCacheInfo()) != null) {
                result.setWellSigned(validationCacheInfo.isValid());
            }
            this.xmlTrustedListsMap.put(id, result);
        }
        return result;
    }

    private XmlContainerInfo getXmlContainerInfo() {
        if (this.containerInfo != null) {
            XmlContainerInfo xmlContainerInfo = new XmlContainerInfo();
            xmlContainerInfo.setContainerType(this.containerInfo.getContainerType());
            String zipComment = this.containerInfo.getZipComment();
            if (Utils.isStringNotBlank(zipComment)) {
                xmlContainerInfo.setZipComment(zipComment);
            }
            xmlContainerInfo.setMimeTypeFilePresent(this.containerInfo.isMimeTypeFilePresent());
            xmlContainerInfo.setMimeTypeContent(this.containerInfo.getMimeTypeContent());
            xmlContainerInfo.setContentFiles(this.containerInfo.getSignedDocumentFilenames());
            xmlContainerInfo.setManifestFiles(this.getXmlManifests(this.containerInfo.getManifestFiles()));
            return xmlContainerInfo;
        }
        return null;
    }

    private List<XmlManifestFile> getXmlManifests(List<ManifestFile> manifestFiles) {
        if (Utils.isCollectionNotEmpty(manifestFiles)) {
            ArrayList<XmlManifestFile> xmlManifests = new ArrayList<XmlManifestFile>();
            for (ManifestFile manifestFile : manifestFiles) {
                XmlManifestFile xmlManifest = new XmlManifestFile();
                xmlManifest.setFilename(manifestFile.getFilename());
                xmlManifest.setSignatureFilename(manifestFile.getSignatureFilename());
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    xmlManifest.getEntries().add(entry.getFileName());
                }
                xmlManifests.add(xmlManifest);
            }
            return xmlManifests;
        }
        return null;
    }

    private XmlSignature buildDetachedXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = new XmlSignature();
        if (this.hasDuplicate(signature)) {
            xmlSignature.setDuplicated(true);
        }
        xmlSignature.setSignatureFilename(this.removeSpecialCharsForXml(signature.getSignatureFilename()));
        xmlSignature.setId(signature.getId());
        xmlSignature.setDAIdentifier(signature.getDAIdentifier());
        xmlSignature.setClaimedSigningTime(signature.getSigningTime());
        xmlSignature.setStructuralValidation(this.getXmlStructuralValidation(signature));
        xmlSignature.setSignatureFormat(signature.getDataFoundUpToLevel());
        xmlSignature.setSignatureProductionPlace(this.getXmlSignatureProductionPlace(signature.getSignatureProductionPlace()));
        xmlSignature.getCommitmentTypeIndications().addAll(this.getXmlCommitmentTypeIndications(signature.getCommitmentTypeIndications()));
        xmlSignature.getSignerRole().addAll(this.getXmlSignerRoles(signature.getSignerRoles()));
        xmlSignature.setContentType(signature.getContentType());
        xmlSignature.setMimeType(signature.getMimeType());
        xmlSignature.setContentIdentifier(signature.getContentIdentifier());
        xmlSignature.setContentHints(signature.getContentHints());
        CandidatesForSigningCertificate candidatesForSigningCertificate = signature.getCandidatesForSigningCertificate();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        PublicKey signingCertificatePublicKey = null;
        if (theCertificateValidity != null) {
            xmlSignature.setSigningCertificate(this.getXmlSigningCertificate(signature.getDSSId(), theCertificateValidity));
            signingCertificatePublicKey = theCertificateValidity.getPublicKey();
            xmlSignature.setCertificateChain(this.getXmlForCertificateChain(signingCertificatePublicKey));
        }
        xmlSignature.setBasicSignature(this.getXmlBasicSignature(signature, signingCertificatePublicKey));
        xmlSignature.setDigestMatchers(this.getXmlDigestMatchers(signature));
        xmlSignature.setPolicy(this.getXmlPolicy(signature));
        xmlSignature.setSignerInformationStore(this.getXmlSignerInformationStore(signature.getSignerInformationStoreInfos()));
        xmlSignature.setPDFRevision(this.getXmlPDFRevision(signature.getPdfRevision()));
        xmlSignature.setSignatureDigestReference(this.getXmlSignatureDigestReference(signature));
        xmlSignature.setSignerDocumentRepresentations(this.getXmlSignerDocumentRepresentations(signature));
        xmlSignature.setFoundCertificates(this.getXmlFoundCertificates(signature.getDSSId(), signature.getCertificateSource()));
        xmlSignature.setFoundRevocations(this.getXmlFoundRevocations(signature.getCRLSource(), signature.getOCSPSource()));
        xmlSignature.setSignatureScopes(this.getXmlSignatureScopes(signature.getSignatureScopes()));
        xmlSignature.setSignatureValue(signature.getSignatureValue());
        return xmlSignature;
    }

    private boolean hasDuplicate(AdvancedSignature currentSignature) {
        for (AdvancedSignature signature : this.signatures) {
            if (currentSignature == signature || !currentSignature.getId().equals(signature.getId())) continue;
            return true;
        }
        return false;
    }

    private XmlPDFRevision getXmlPDFRevision(PdfRevision pdfRevision) {
        if (pdfRevision != null) {
            XmlPDFRevision xmlPDFRevision = new XmlPDFRevision();
            xmlPDFRevision.getSignatureFieldName().addAll(pdfRevision.getFieldNames());
            xmlPDFRevision.setPDFSignatureDictionary(this.getXmlPDFSignatureDictionary(pdfRevision.getPdfSigDictInfo()));
            return xmlPDFRevision;
        }
        return null;
    }

    private List<XmlSignerInfo> getXmlSignerInformationStore(Set<CertificateIdentifier> certificateIdentifiers) {
        if (Utils.isCollectionNotEmpty(certificateIdentifiers)) {
            ArrayList<XmlSignerInfo> signerInfos = new ArrayList<XmlSignerInfo>();
            for (CertificateIdentifier certificateIdentifier : certificateIdentifiers) {
                signerInfos.add(this.getXmlSignerInfo(certificateIdentifier));
            }
            return signerInfos;
        }
        return null;
    }

    private XmlSignerInfo getXmlSignerInfo(CertificateIdentifier certificateIdentifier) {
        XmlSignerInfo xmlSignerInfo = new XmlSignerInfo();
        if (certificateIdentifier.getIssuerName() != null) {
            xmlSignerInfo.setIssuerName(certificateIdentifier.getIssuerName().toString());
        }
        xmlSignerInfo.setSerialNumber(certificateIdentifier.getSerialNumber());
        xmlSignerInfo.setSki(certificateIdentifier.getSki());
        if (certificateIdentifier.isCurrent()) {
            xmlSignerInfo.setCurrent(certificateIdentifier.isCurrent());
        }
        return xmlSignerInfo;
    }

    private XmlSignerInfo getXmlSignerInfo(ResponderId responderId) {
        XmlSignerInfo xmlSignerInfo = new XmlSignerInfo();
        if (responderId.getX500Principal() != null) {
            xmlSignerInfo.setIssuerName(responderId.getX500Principal().toString());
        }
        xmlSignerInfo.setSki(responderId.getSki());
        return xmlSignerInfo;
    }

    private XmlPDFSignatureDictionary getXmlPDFSignatureDictionary(PdfSignatureDictionary pdfSigDict) {
        if (pdfSigDict != null) {
            XmlPDFSignatureDictionary pdfSignatureDictionary = new XmlPDFSignatureDictionary();
            pdfSignatureDictionary.setSignerName(this.emptyToNull(pdfSigDict.getSignerName()));
            pdfSignatureDictionary.setType(this.emptyToNull(pdfSigDict.getType()));
            pdfSignatureDictionary.setFilter(this.emptyToNull(pdfSigDict.getFilter()));
            pdfSignatureDictionary.setSubFilter(this.emptyToNull(pdfSigDict.getSubFilter()));
            pdfSignatureDictionary.setContactInfo(this.emptyToNull(pdfSigDict.getContactInfo()));
            pdfSignatureDictionary.setReason(this.emptyToNull(pdfSigDict.getReason()));
            pdfSignatureDictionary.getSignatureByteRange().addAll(pdfSigDict.getByteRange().toBigIntegerList());
            return pdfSignatureDictionary;
        }
        return null;
    }

    private XmlSignatureDigestReference getXmlSignatureDigestReference(AdvancedSignature signature) {
        SignatureDigestReference signatureDigestReference = signature.getSignatureDigestReference(this.defaultDigestAlgorithm);
        if (signatureDigestReference != null) {
            XmlSignatureDigestReference xmlDigestReference = new XmlSignatureDigestReference();
            xmlDigestReference.setCanonicalizationMethod(signatureDigestReference.getCanonicalizationMethod());
            xmlDigestReference.setDigestMethod(signatureDigestReference.getDigestAlgorithm());
            xmlDigestReference.setDigestValue(signatureDigestReference.getDigestValue());
            return xmlDigestReference;
        }
        return null;
    }

    private XmlSignerDocumentRepresentations getXmlSignerDocumentRepresentations(AdvancedSignature signature) {
        if (signature.getDetachedContents() == null) {
            return null;
        }
        XmlSignerDocumentRepresentations signerDocumentRepresentation = new XmlSignerDocumentRepresentations();
        signerDocumentRepresentation.setDocHashOnly(signature.isDocHashOnlyValidation());
        signerDocumentRepresentation.setHashOnly(signature.isHashOnlyValidation());
        return signerDocumentRepresentation;
    }

    private XmlSignerData getXmlSignerData(SignatureScope signatureScope) {
        XmlSignerData xmlSignedData = new XmlSignerData();
        xmlSignedData.setId(signatureScope.getDSSIdAsString());
        xmlSignedData.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(signatureScope.getDigest().getAlgorithm(), signatureScope.getDigest().getValue()));
        xmlSignedData.setReferencedName(signatureScope.getName());
        return xmlSignedData;
    }

    private XmlStructuralValidation getXmlStructuralValidation(AdvancedSignature signature) {
        String structureValidationResult = signature.getStructureValidationResult();
        XmlStructuralValidation xmlStructuralValidation = new XmlStructuralValidation();
        xmlStructuralValidation.setValid(Utils.isStringEmpty(structureValidationResult));
        if (Utils.isStringNotEmpty(structureValidationResult)) {
            xmlStructuralValidation.setMessage(structureValidationResult);
        }
        return xmlStructuralValidation;
    }

    private String removeSpecialCharsForXml(String text) {
        if (Utils.isStringNotEmpty(text)) {
            return text.replace("&", "");
        }
        return "";
    }

    private List<XmlTimestamp> buildXmlTimestamps(Set<TimestampToken> timestamps) {
        ArrayList<XmlTimestamp> xmlTimestampsList = new ArrayList<XmlTimestamp>();
        if (Utils.isCollectionNotEmpty(timestamps)) {
            ArrayList<TimestampToken> tokens = new ArrayList<TimestampToken>(timestamps);
            Collections.sort(tokens, new TimestampTokenComparator());
            for (TimestampToken timestampToken : tokens) {
                String id = timestampToken.getDSSIdAsString();
                XmlTimestamp xmlTimestamp = this.buildDetachedXmlTimestamp(timestampToken);
                this.xmlTimestampsMap.put(id, xmlTimestamp);
                xmlTimestampsList.add(xmlTimestamp);
            }
        }
        return xmlTimestampsList;
    }

    private XmlOrphanTokens buildXmlOrphanTokens() {
        XmlOrphanTokens xmlOrphanTokens = new XmlOrphanTokens();
        if (Utils.isMapNotEmpty(this.xmlOrphanCertificateTokensMap)) {
            xmlOrphanTokens.getOrphanCertificates().addAll(this.xmlOrphanCertificateTokensMap.values());
        }
        this.buildOrphanRevocationTokensFromCommonSources();
        if (Utils.isMapNotEmpty(this.xmlOrphanRevocationTokensMap)) {
            xmlOrphanTokens.getOrphanRevocations().addAll(this.xmlOrphanRevocationTokensMap.values());
        }
        return xmlOrphanTokens;
    }

    private void buildOrphanRevocationTokensFromCommonSources() {
        String id;
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : this.commonCRLSource.getAllRevocationBinaries()) {
            id = revocationIdentifier.asXmlId();
            if (this.xmlRevocationsMap.containsKey(id) || this.xmlOrphanRevocationTokensMap.containsKey(id)) continue;
            this.createOrphanTokenFromRevocationIdentifier(revocationIdentifier);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : this.commonOCSPSource.getAllRevocationBinaries()) {
            id = revocationIdentifier.asXmlId();
            if (this.xmlRevocationsMap.containsKey(id) || this.xmlOrphanRevocationTokensMap.containsKey(id)) continue;
            this.createOrphanTokenFromRevocationIdentifier(revocationIdentifier);
        }
    }

    private XmlRevocation buildDetachedXmlRevocation(RevocationToken<Revocation> revocationToken) {
        XmlRevocation xmlRevocation = new XmlRevocation();
        xmlRevocation.setId(revocationToken.getDSSIdAsString());
        if (revocationToken.isInternal()) {
            xmlRevocation.setOrigin(RevocationOrigin.INPUT_DOCUMENT);
        } else {
            xmlRevocation.setOrigin(revocationToken.getExternalOrigin());
        }
        xmlRevocation.setType(revocationToken.getRevocationType());
        xmlRevocation.setProductionDate(revocationToken.getProductionDate());
        xmlRevocation.setThisUpdate(revocationToken.getThisUpdate());
        xmlRevocation.setNextUpdate(revocationToken.getNextUpdate());
        xmlRevocation.setExpiredCertsOnCRL(revocationToken.getExpiredCertsOnCRL());
        xmlRevocation.setArchiveCutOff(revocationToken.getArchiveCutOff());
        String sourceURL = revocationToken.getSourceURL();
        if (Utils.isStringNotEmpty(sourceURL)) {
            xmlRevocation.setSourceAddress(sourceURL);
        }
        xmlRevocation.setBasicSignature(this.getXmlBasicSignature(revocationToken));
        xmlRevocation.setSigningCertificate(this.getXmlSigningCertificate(revocationToken));
        xmlRevocation.setCertificateChain(this.getXmlForCertificateChain(revocationToken));
        xmlRevocation.setCertHashExtensionPresent(revocationToken.isCertHashPresent());
        xmlRevocation.setCertHashExtensionMatch(revocationToken.isCertHashMatch());
        if (revocationToken.getCertificateSource() != null) {
            xmlRevocation.setFoundCertificates(this.getXmlFoundCertificates(revocationToken.getDSSId(), revocationToken.getCertificateSource()));
        }
        if (this.tokenExtractionStategy.isRevocationData()) {
            xmlRevocation.setBase64Encoded(revocationToken.getEncoded());
        } else {
            byte[] revocationDigest = revocationToken.getDigest(this.defaultDigestAlgorithm);
            xmlRevocation.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, revocationDigest));
        }
        return xmlRevocation;
    }

    private List<XmlChainItem> getXmlForCertificateChain(PublicKey publicKey) {
        CertificateToken certificateByPubKey;
        if (publicKey != null && (certificateByPubKey = this.getCertificateByPubKey(publicKey)) != null) {
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            certChainTokens.add(this.getXmlChainItem(certificateByPubKey));
            List<XmlChainItem> certChain = this.getXmlForCertificateChain(certificateByPubKey);
            if (Utils.isCollectionNotEmpty(certChain)) {
                certChainTokens.addAll(certChain);
            }
            return certChainTokens;
        }
        return null;
    }

    private List<XmlChainItem> getXmlForCertificateChain(Token token) {
        if (token != null) {
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            HashSet<CertificateToken> processedTokens = new HashSet<CertificateToken>();
            CertificateToken issuerToken = this.getIssuerCertificate(token);
            while (issuerToken != null) {
                certChainTokens.add(this.getXmlChainItem(issuerToken));
                if (issuerToken.isSelfSigned() || processedTokens.contains(issuerToken)) break;
                processedTokens.add(issuerToken);
                issuerToken = this.getIssuerCertificate(issuerToken);
            }
            return certChainTokens;
        }
        return null;
    }

    private XmlChainItem getXmlChainItem(CertificateToken token) {
        XmlChainItem chainItem = new XmlChainItem();
        chainItem.setCertificate(this.xmlCertsMap.get(token.getDSSIdAsString()));
        return chainItem;
    }

    private XmlSigningCertificate getXmlSigningCertificate(Token token) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken certificateByPubKey = this.getIssuerCertificate(token);
        if (certificateByPubKey != null) {
            xmlSignCertType.setCertificate(this.xmlCertsMap.get(certificateByPubKey.getDSSIdAsString()));
            this.signingCertificateMap.put(token.getDSSIdAsString(), certificateByPubKey);
        } else if (token.getPublicKeyOfTheSigner() != null) {
            xmlSignCertType.setPublicKey(token.getPublicKeyOfTheSigner().getEncoded());
        } else {
            return null;
        }
        return xmlSignCertType;
    }

    private CertificateToken getIssuerCertificate(Token token) {
        if (token != null && token.getPublicKeyOfTheSigner() != null) {
            CertificateToken issuer;
            if (token instanceof OCSPToken && (issuer = this.getIssuerForOCSPToken((OCSPToken)token)) != null) {
                return issuer;
            }
            if (token instanceof TimestampToken && (issuer = this.getIssuerForTimestampToken((TimestampToken)token)) != null) {
                return issuer;
            }
            List<CertificateToken> issuers = this.getCertsWithPublicKey(token.getPublicKeyOfTheSigner(), this.usedCertificates);
            if (Utils.isCollectionNotEmpty(issuers)) {
                for (CertificateToken cert : issuers) {
                    if (!cert.isValidOn(token.getCreationDate())) continue;
                    return cert;
                }
                return issuers.iterator().next();
            }
        }
        return null;
    }

    private CertificateToken getIssuerForOCSPToken(OCSPToken token) {
        List<CertificateToken> issuers = this.getCertsWithPublicKey(token.getPublicKeyOfTheSigner(), token.getCertificateSource().getCertificates());
        if (Utils.isCollectionNotEmpty(issuers)) {
            for (CertificateToken cert : issuers) {
                if (!cert.isValidOn(token.getCreationDate())) continue;
                return cert;
            }
        }
        return null;
    }

    private CertificateToken getIssuerForTimestampToken(TimestampToken token) {
        List<CertificateToken> issuers = this.getCertsWithPublicKey(token.getPublicKeyOfTheSigner(), token.getCertificateSource().getCertificates());
        if (Utils.isCollectionNotEmpty(issuers)) {
            for (CertificateToken cert : issuers) {
                if (!cert.isValidOn(token.getCreationDate())) continue;
                return cert;
            }
        }
        return null;
    }

    private CertificateToken getCertificateByPubKey(PublicKey publicKey) {
        List<CertificateToken> issuers;
        if (publicKey != null && Utils.isCollectionNotEmpty(issuers = this.getCertsWithPublicKey(publicKey, this.usedCertificates))) {
            return issuers.iterator().next();
        }
        return null;
    }

    private List<CertificateToken> getCertsWithPublicKey(PublicKey publicKey, Collection<CertificateToken> candidates) {
        ArrayList<CertificateToken> founds = new ArrayList<CertificateToken>();
        if (publicKey != null) {
            for (CertificateToken cert : candidates) {
                if (!publicKey.equals(cert.getPublicKey())) continue;
                founds.add(cert);
                if (!this.trustedCertSources.isTrusted(cert)) continue;
                return Arrays.asList(cert);
            }
        }
        return founds;
    }

    private CertificateToken getCertificateByCertificateIdentifier(CertificateIdentifier certificateIdentifier) {
        if (certificateIdentifier == null) {
            return null;
        }
        ArrayList<CertificateToken> founds = new ArrayList<CertificateToken>();
        for (CertificateToken cert : this.usedCertificates) {
            if (!certificateIdentifier.isRelatedToCertificate(cert)) continue;
            founds.add(cert);
            if (!this.trustedCertSources.isTrusted(cert)) continue;
            return cert;
        }
        if (Utils.isCollectionNotEmpty(founds)) {
            return (CertificateToken)founds.iterator().next();
        }
        return null;
    }

    private XmlSigningCertificate getXmlSigningCertificate(Identifier tokenIdentifier, CertificateValidity certificateValidity) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken signingCertificate = this.getSigningCertificate(certificateValidity);
        if (signingCertificate != null) {
            xmlSignCertType.setCertificate(this.xmlCertsMap.get(signingCertificate.getDSSIdAsString()));
            this.signingCertificateMap.put(tokenIdentifier.asXmlId(), signingCertificate);
        } else if (certificateValidity.getPublicKey() != null) {
            xmlSignCertType.setPublicKey(certificateValidity.getPublicKey().getEncoded());
        } else if (certificateValidity.getSignerInfo() != null) {
            // empty if block
        }
        return xmlSignCertType;
    }

    private CertificateToken getSigningCertificate(CertificateValidity certificateValidity) {
        CertificateToken signingCertificateToken = certificateValidity.getCertificateToken();
        if (signingCertificateToken != null) {
            return signingCertificateToken;
        }
        if (certificateValidity.getPublicKey() != null) {
            return this.getCertificateByPubKey(certificateValidity.getPublicKey());
        }
        if (certificateValidity.getSignerInfo() != null) {
            return this.getCertificateByCertificateIdentifier(certificateValidity.getSignerInfo());
        }
        return null;
    }

    private XmlSignatureProductionPlace getXmlSignatureProductionPlace(SignatureProductionPlace signatureProductionPlace) {
        if (signatureProductionPlace != null) {
            XmlSignatureProductionPlace xmlSignatureProductionPlace = new XmlSignatureProductionPlace();
            xmlSignatureProductionPlace.setCountryName(this.emptyToNull(signatureProductionPlace.getCountryName()));
            xmlSignatureProductionPlace.setStateOrProvince(this.emptyToNull(signatureProductionPlace.getStateOrProvince()));
            xmlSignatureProductionPlace.setPostalCode(this.emptyToNull(signatureProductionPlace.getPostalCode()));
            xmlSignatureProductionPlace.setAddress(this.emptyToNull(signatureProductionPlace.getStreetAddress()));
            xmlSignatureProductionPlace.setCity(this.emptyToNull(signatureProductionPlace.getCity()));
            return xmlSignatureProductionPlace;
        }
        return null;
    }

    private List<XmlSignerRole> getXmlSignerRoles(Collection<SignerRole> signerRoles) {
        ArrayList<XmlSignerRole> xmlSignerRoles = new ArrayList<XmlSignerRole>();
        if (Utils.isCollectionNotEmpty(signerRoles)) {
            for (SignerRole signerRole : signerRoles) {
                XmlSignerRole xmlSignerRole = new XmlSignerRole();
                xmlSignerRole.setRole(signerRole.getRole());
                xmlSignerRole.setCategory(signerRole.getCategory());
                xmlSignerRole.setNotBefore(signerRole.getNotBefore());
                xmlSignerRole.setNotAfter(signerRole.getNotAfter());
                xmlSignerRoles.add(xmlSignerRole);
            }
        }
        return xmlSignerRoles;
    }

    private List<XmlCommitmentTypeIndication> getXmlCommitmentTypeIndications(List<CommitmentTypeIndication> commitmentTypeIndications) {
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            ArrayList<XmlCommitmentTypeIndication> xmlCommitmentTypeIndications = new ArrayList<XmlCommitmentTypeIndication>();
            for (CommitmentTypeIndication commitmentTypeIndication : commitmentTypeIndications) {
                xmlCommitmentTypeIndications.add(this.getXmlCommitmentTypeIndication(commitmentTypeIndication));
            }
            return xmlCommitmentTypeIndications;
        }
        return Collections.emptyList();
    }

    private XmlCommitmentTypeIndication getXmlCommitmentTypeIndication(CommitmentTypeIndication commitmentTypeIndication) {
        XmlCommitmentTypeIndication xmlCommitmentTypeIndication = new XmlCommitmentTypeIndication();
        xmlCommitmentTypeIndication.setIdentifier(commitmentTypeIndication.getIdentifier());
        xmlCommitmentTypeIndication.setDescription(commitmentTypeIndication.getDescription());
        xmlCommitmentTypeIndication.setDocumentationReferences(commitmentTypeIndication.getDocumentReferences());
        return xmlCommitmentTypeIndication;
    }

    private XmlDistinguishedName getXmlDistinguishedName(String x500PrincipalFormat, String value) {
        XmlDistinguishedName xmlDistinguishedName = new XmlDistinguishedName();
        xmlDistinguishedName.setFormat(x500PrincipalFormat);
        xmlDistinguishedName.setValue(value);
        return xmlDistinguishedName;
    }

    private List<String> getCleanedUrls(List<String> urls) {
        ArrayList<String> cleanedUrls = new ArrayList<String>();
        for (String url : urls) {
            cleanedUrls.add(DSSUtils.removeControlCharacters(url));
        }
        return cleanedUrls;
    }

    private XmlFoundCertificates getXmlFoundCertificates(Identifier tokenIdentifier, TokenCertificateSource certificateSource) {
        XmlFoundCertificates xmlFoundCertificates = new XmlFoundCertificates();
        if (CertificateSourceType.OCSP_RESPONSE.equals((Object)certificateSource.getCertificateSourceType())) {
            xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificates((OCSPCertificateSource)certificateSource));
        } else {
            xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificates((SignatureCertificateSource)certificateSource));
        }
        xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificateForOrphanReferences(certificateSource));
        CertificateToken signingCertificate = this.signingCertificateMap.get(tokenIdentifier.asXmlId());
        xmlFoundCertificates.getOrphanCertificates().addAll(this.getOrphanCertificates(certificateSource, signingCertificate));
        return xmlFoundCertificates;
    }

    private List<XmlRelatedCertificate> getXmlRelatedCertificates(SignatureCertificateSource certificateSource) {
        HashMap<String, XmlRelatedCertificate> relatedCertificatesMap = new HashMap<String, XmlRelatedCertificate>();
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.KEY_INFO, certificateSource.getKeyInfoCertificates(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.SIGNED_DATA, certificateSource.getSignedDataCertificates(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.CERTIFICATE_VALUES, certificateSource.getCertificateValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.ATTR_AUTORITIES_CERT_VALUES, certificateSource.getAttrAuthoritiesCertValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.TIMESTAMP_VALIDATION_DATA, certificateSource.getTimeStampValidationDataCertValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.DSS_DICTIONARY, certificateSource.getDSSDictionaryCertValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.VRI_DICTIONARY, certificateSource.getVRIDictionaryCertValues(), certificateSource);
        return new ArrayList<XmlRelatedCertificate>(relatedCertificatesMap.values());
    }

    private List<XmlRelatedCertificate> getXmlRelatedCertificates(OCSPCertificateSource certificateSource) {
        HashMap<String, XmlRelatedCertificate> relatedCertificatesMap = new HashMap<String, XmlRelatedCertificate>();
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.BASIC_OCSP_RESP, certificateSource.getCertificates(), certificateSource);
        return new ArrayList<XmlRelatedCertificate>(relatedCertificatesMap.values());
    }

    private void populateCertificateOriginMap(Map<String, XmlRelatedCertificate> relatedCertificatesMap, CertificateOrigin origin, List<CertificateToken> certificateTokens, TokenCertificateSource certificateSource) {
        for (CertificateToken certificateToken : certificateTokens) {
            if (!relatedCertificatesMap.containsKey(certificateToken.getDSSIdAsString())) {
                XmlRelatedCertificate xmlFoundCertificate = this.getXmlRelatedCertificate(origin, certificateToken, certificateSource);
                relatedCertificatesMap.put(certificateToken.getDSSIdAsString(), xmlFoundCertificate);
                continue;
            }
            XmlRelatedCertificate storedFoundCertificate = relatedCertificatesMap.get(certificateToken.getDSSIdAsString());
            if (storedFoundCertificate.getOrigins().contains((Object)origin)) continue;
            storedFoundCertificate.getOrigins().add(origin);
        }
    }

    private XmlRelatedCertificate getXmlRelatedCertificate(CertificateOrigin origin, CertificateToken cert, TokenCertificateSource certificateSource) {
        XmlRelatedCertificate xrc = new XmlRelatedCertificate();
        xrc.getOrigins().add(origin);
        xrc.setCertificate(this.xmlCertsMap.get(cert.getDSSIdAsString()));
        List<CertificateRef> referencesForCertificateToken = certificateSource.getReferencesForCertificateToken(cert);
        for (CertificateRef certificateRef : referencesForCertificateToken) {
            for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
                XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
                if (CertificateRefOrigin.SIGNING_CERTIFICATE.equals((Object)refOrigin)) {
                    this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, cert);
                }
                xrc.getCertificateRefs().add(xmlCertificateRef);
            }
            this.referenceMap.put(certificateRef.getDSSIdAsString(), cert.getDSSIdAsString());
        }
        return xrc;
    }

    private XmlCertificateRef getXmlCertificateRef(CertificateRef ref, CertificateRefOrigin origin) {
        XmlCertificateRef certificateRef = new XmlCertificateRef();
        CertificateIdentifier certificateIdentifier = ref.getCertificateIdentifier();
        if (certificateIdentifier != null) {
            certificateRef.setIssuerSerial(this.getXmlIssuerSerial(certificateIdentifier));
        }
        Digest refDigest = ref.getCertDigest();
        ResponderId responderId = ref.getResponderId();
        if (refDigest != null) {
            certificateRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(refDigest.getAlgorithm(), refDigest.getValue()));
        } else if (certificateIdentifier != null) {
            certificateRef.setSerialInfo(this.getXmlSignerInfo(certificateIdentifier));
        } else if (responderId != null) {
            certificateRef.setSerialInfo(this.getXmlSignerInfo(responderId));
        }
        certificateRef.setOrigin(origin);
        return certificateRef;
    }

    private void verifyAgainstCertificateToken(XmlCertificateRef xmlCertificateRef, CertificateRef ref, CertificateToken signingCertificate) {
        XmlIssuerSerial issuerSerial;
        CertificateTokenRefMatcher tokenRefMatcher = new CertificateTokenRefMatcher();
        XmlDigestAlgoAndValue digestAlgoAndValue = xmlCertificateRef.getDigestAlgoAndValue();
        if (digestAlgoAndValue != null) {
            digestAlgoAndValue.setMatch(signingCertificate != null && tokenRefMatcher.matchByDigest(signingCertificate, ref));
        }
        if ((issuerSerial = xmlCertificateRef.getIssuerSerial()) != null) {
            issuerSerial.setMatch(signingCertificate != null && tokenRefMatcher.matchByIssuerName(signingCertificate, ref) && tokenRefMatcher.matchBySerialNumber(signingCertificate, ref));
        }
    }

    private XmlIssuerSerial getXmlIssuerSerial(CertificateIdentifier certificateIdentifier) {
        XmlIssuerSerial xmlIssuerSerial = new XmlIssuerSerial();
        xmlIssuerSerial.setValue(certificateIdentifier.getIssuerSerialEncoded());
        return xmlIssuerSerial;
    }

    private List<XmlRelatedCertificate> getXmlRelatedCertificateForOrphanReferences(TokenCertificateSource certificateSource) {
        ArrayList<XmlRelatedCertificate> relatedCertificates = new ArrayList<XmlRelatedCertificate>();
        for (CertificateRef certificateRef : certificateSource.getOrphanCertificateRefs()) {
            CertificateToken certificateToken = this.getUsedCertificateByCertificateRef(certificateRef);
            if (certificateToken == null) continue;
            relatedCertificates.add(this.getXmlRelatedCertificate(certificateSource, certificateToken, certificateRef));
        }
        return relatedCertificates;
    }

    private CertificateToken getUsedCertificateByCertificateRef(CertificateRef certificateRef) {
        CertificateTokenRefMatcher matcher = new CertificateTokenRefMatcher();
        for (CertificateToken certificateToken : this.usedCertificates) {
            if (!matcher.match(certificateToken, certificateRef)) continue;
            return certificateToken;
        }
        return null;
    }

    private XmlRelatedCertificate getXmlRelatedCertificate(TokenCertificateSource certificateSource, CertificateToken cert, CertificateRef certificateRef) {
        XmlRelatedCertificate xrc = new XmlRelatedCertificate();
        xrc.setCertificate(this.xmlCertsMap.get(cert.getDSSIdAsString()));
        for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
            XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
            if (CertificateRefOrigin.SIGNING_CERTIFICATE.equals((Object)refOrigin)) {
                this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, cert);
            }
            xrc.getCertificateRefs().add(xmlCertificateRef);
        }
        this.referenceMap.put(certificateRef.getDSSIdAsString(), cert.getDSSIdAsString());
        return xrc;
    }

    private List<XmlOrphanCertificate> getOrphanCertificates(TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        ArrayList<XmlOrphanCertificate> orphanCertificates = new ArrayList<XmlOrphanCertificate>();
        List<CertificateRef> orphanCertificateRefs = certificateSource.getOrphanCertificateRefs();
        for (CertificateRef orphanCertificateRef : orphanCertificateRefs) {
            if (this.getUsedCertificateByCertificateRef(orphanCertificateRef) != null) continue;
            orphanCertificates.add(this.createXmlOrphanCertificate(certificateSource, orphanCertificateRef, signingCertificate));
        }
        return orphanCertificates;
    }

    private XmlOrphanCertificate createXmlOrphanCertificate(TokenCertificateSource certificateSource, CertificateRef orphanCertificateRef, CertificateToken signingCertificate) {
        XmlOrphanCertificate orphanCertificate = new XmlOrphanCertificate();
        orphanCertificate.setToken(this.createXmlOrphanCertificateToken(orphanCertificateRef));
        for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(orphanCertificateRef)) {
            XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(orphanCertificateRef, refOrigin);
            if (CertificateRefOrigin.SIGNING_CERTIFICATE.equals((Object)refOrigin)) {
                this.verifyAgainstCertificateToken(xmlCertificateRef, orphanCertificateRef, signingCertificate);
            }
            orphanCertificate.getCertificateRefs().add(xmlCertificateRef);
        }
        return orphanCertificate;
    }

    private XmlOrphanCertificateToken createXmlOrphanCertificateToken(CertificateRef orphanCertificateRef) {
        XmlOrphanCertificateToken orphanToken = new XmlOrphanCertificateToken();
        orphanToken.setId(orphanCertificateRef.getDSSIdAsString());
        if (orphanCertificateRef.getCertDigest() != null) {
            orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(orphanCertificateRef.getCertDigest()));
        }
        this.xmlOrphanCertificateTokensMap.put(orphanCertificateRef.getDSSIdAsString(), orphanToken);
        return orphanToken;
    }

    private List<XmlFoundTimestamp> getXmlFoundTimestamps(AdvancedSignature signature) {
        ArrayList<XmlFoundTimestamp> foundTimestamps = new ArrayList<XmlFoundTimestamp>();
        for (TimestampToken timestampToken : signature.getAllTimestamps()) {
            XmlFoundTimestamp foundTimestamp = new XmlFoundTimestamp();
            foundTimestamp.setTimestamp(this.xmlTimestampsMap.get(timestampToken.getDSSIdAsString()));
            foundTimestamp.setLocation(timestampToken.getTimestampLocation());
            foundTimestamps.add(foundTimestamp);
        }
        return foundTimestamps;
    }

    private XmlFoundRevocations getXmlFoundRevocations(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        XmlFoundRevocations foundRevocations = new XmlFoundRevocations();
        foundRevocations.getRelatedRevocations().addAll(this.getXmlRelatedRevocations(crlSource, ocspSource));
        foundRevocations.getOrphanRevocations().addAll(this.getXmlOrphanRevocations(crlSource, ocspSource));
        foundRevocations.getOrphanRevocations().addAll(this.getXmlOrphanRevocationRefs(crlSource, ocspSource));
        return foundRevocations;
    }

    private List<XmlRelatedRevocation> getXmlRelatedRevocations(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        ArrayList<XmlRelatedRevocation> xmlRelatedRevocations = new ArrayList<XmlRelatedRevocation>();
        this.addRelatedRevocations(xmlRelatedRevocations, crlSource);
        this.addRelatedRevocations(xmlRelatedRevocations, ocspSource);
        return xmlRelatedRevocations;
    }

    private <R extends Revocation> void addRelatedRevocations(List<XmlRelatedRevocation> result, OfflineRevocationSource<R> source) {
        for (Map.Entry<RevocationToken<R>, Set<RevocationOrigin>> entry : source.getUniqueRevocationTokensWithOrigins().entrySet()) {
            RevocationToken<R> token = entry.getKey();
            String id = token.getDSSIdAsString();
            XmlRevocation xmlRevocation = this.xmlRevocationsMap.get(id);
            if (xmlRevocation == null) continue;
            XmlRelatedRevocation xmlRelatedRevocation = new XmlRelatedRevocation();
            xmlRelatedRevocation.setRevocation(xmlRevocation);
            xmlRelatedRevocation.setType(token.getRevocationType());
            xmlRelatedRevocation.getOrigins().addAll((Collection<RevocationOrigin>)entry.getValue());
            xmlRelatedRevocation.getRevocationRefs().addAll(this.getXmlRevocationRefs(xmlRevocation.getId(), source.findRefsAndOriginsForRevocationToken(token)));
            result.add(xmlRelatedRevocation);
        }
    }

    private List<XmlOrphanRevocation> getXmlOrphanRevocations(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        ArrayList<XmlOrphanRevocation> xmlOrphanRevocations = new ArrayList<XmlOrphanRevocation>();
        this.addOrphanRevocations(xmlOrphanRevocations, crlSource);
        this.addOrphanRevocations(xmlOrphanRevocations, ocspSource);
        return xmlOrphanRevocations;
    }

    private <R extends Revocation> void addOrphanRevocations(List<XmlOrphanRevocation> xmlOrphanRevocations, OfflineRevocationSource<R> source) {
        Map<EncapsulatedRevocationTokenIdentifier, Set<RevocationOrigin>> allBinariesWithOrigins = source.getAllRevocationBinariesWithOrigins();
        for (Map.Entry<EncapsulatedRevocationTokenIdentifier, Set<RevocationOrigin>> entry : allBinariesWithOrigins.entrySet()) {
            EncapsulatedRevocationTokenIdentifier token = entry.getKey();
            String tokenId = token.asXmlId();
            if (this.xmlRevocationsMap.containsKey(tokenId)) continue;
            XmlOrphanRevocation xmlOrphanRevocation = this.getXmlOrphanRevocation(token, entry.getValue());
            xmlOrphanRevocation.getRevocationRefs().addAll(this.getXmlRevocationRefs(tokenId, source.findRefsAndOriginsForBinary(token)));
            xmlOrphanRevocations.add(xmlOrphanRevocation);
        }
    }

    private List<XmlOrphanRevocation> getXmlOrphanRevocationRefs(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        ArrayList<XmlOrphanRevocation> xmlOrphanRevocationRefs = new ArrayList<XmlOrphanRevocation>();
        this.addOrphanRevocationRefs(xmlOrphanRevocationRefs, crlSource, this.commonCRLSource);
        this.addOrphanRevocationRefs(xmlOrphanRevocationRefs, ocspSource, this.commonOCSPSource);
        return xmlOrphanRevocationRefs;
    }

    private <R extends Revocation> void addOrphanRevocationRefs(List<XmlOrphanRevocation> xmlOrphanRevocationRefs, OfflineRevocationSource<R> source, ListRevocationSource<R> allSources) {
        Map<RevocationRef<R>, Set<RevocationRefOrigin>> orphanRevocationReferencesWithOrigins = source.getOrphanRevocationReferencesWithOrigins();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : orphanRevocationReferencesWithOrigins.entrySet()) {
            RevocationRef<R> ref = entry.getKey();
            if (!allSources.isOrphan(ref) || !this.sourceDoesNotContainOrphanBinaries(source, ref)) continue;
            xmlOrphanRevocationRefs.add(this.createOrphanRevocationFromRef(ref, entry.getValue()));
        }
    }

    private <R extends Revocation> boolean sourceDoesNotContainOrphanBinaries(OfflineRevocationSource<R> source, RevocationRef<R> ref) {
        String tokenId = this.referenceMap.get(ref.getDSSIdAsString());
        if (tokenId == null) {
            return true;
        }
        for (Identifier identifier : source.getAllRevocationBinaries()) {
            if (!tokenId.equals(identifier.asXmlId())) continue;
            return false;
        }
        return true;
    }

    private <R extends Revocation> List<XmlRevocationRef> getXmlRevocationRefs(String tokenId, Map<RevocationRef<R>, Set<RevocationRefOrigin>> refsAndOrigins) {
        ArrayList<XmlRevocationRef> xmlRevocationRefs = new ArrayList<XmlRevocationRef>();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : refsAndOrigins.entrySet()) {
            RevocationRef<R> ref = entry.getKey();
            Set<RevocationRefOrigin> origins = entry.getValue();
            XmlRevocationRef xmlRef = null;
            xmlRef = ref instanceof CRLRef ? this.getXmlCRLRevocationRef((CRLRef)ref, origins) : this.getXmlOCSPRevocationRef((OCSPRef)ref, origins);
            this.referenceMap.put(ref.getDSSIdAsString(), tokenId);
            xmlRevocationRefs.add(xmlRef);
        }
        return xmlRevocationRefs;
    }

    private XmlRevocationRef getXmlCRLRevocationRef(CRLRef crlRef, Set<RevocationRefOrigin> origins) {
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(origins);
        if (crlRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(crlRef.getDigest()));
        }
        return xmlRevocationRef;
    }

    private XmlRevocationRef getXmlOCSPRevocationRef(OCSPRef ocspRef, Set<RevocationRefOrigin> origins) {
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(origins);
        if (ocspRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(ocspRef.getDigest()));
        }
        xmlRevocationRef.setProducedAt(ocspRef.getProducedAt());
        ResponderId responderId = ocspRef.getResponderId();
        if (responderId != null) {
            xmlRevocationRef.setResponderId(this.getXmlSignerInfo(responderId));
        }
        return xmlRevocationRef;
    }

    private <R extends Revocation> XmlOrphanRevocation getXmlOrphanRevocation(EncapsulatedRevocationTokenIdentifier token, Set<RevocationOrigin> origins) {
        XmlOrphanRevocation xmlOrphanRevocation = new XmlOrphanRevocation();
        if (token instanceof CRLBinary) {
            xmlOrphanRevocation.setType(RevocationType.CRL);
        } else {
            xmlOrphanRevocation.setType(RevocationType.OCSP);
        }
        xmlOrphanRevocation.getOrigins().addAll(origins);
        xmlOrphanRevocation.setToken(this.createOrphanTokenFromRevocationIdentifier(token));
        return xmlOrphanRevocation;
    }

    private XmlOrphanRevocationToken createOrphanTokenFromRevocationIdentifier(EncapsulatedRevocationTokenIdentifier revocationIdentifier) {
        XmlOrphanRevocationToken orphanToken = new XmlOrphanRevocationToken();
        String tokenId = revocationIdentifier.asXmlId();
        orphanToken.setId(tokenId);
        if (this.tokenExtractionStategy.isRevocationData()) {
            orphanToken.setBase64Encoded(revocationIdentifier.getBinaries());
        } else {
            byte[] digestValue = revocationIdentifier.getDigestValue(this.defaultDigestAlgorithm);
            orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, digestValue));
        }
        if (revocationIdentifier instanceof CRLBinary) {
            orphanToken.setType(RevocationType.CRL);
        } else {
            orphanToken.setType(RevocationType.OCSP);
        }
        this.xmlOrphanRevocationTokensMap.put(tokenId, orphanToken);
        return orphanToken;
    }

    private <R extends Revocation> XmlOrphanRevocation createOrphanRevocationFromRef(RevocationRef<R> ref, Set<RevocationRefOrigin> origins) {
        XmlOrphanRevocation xmlOrphanRevocation = new XmlOrphanRevocation();
        XmlOrphanRevocationToken orphanToken = new XmlOrphanRevocationToken();
        orphanToken.setId(ref.getDSSIdAsString());
        if (ref.getDigest() != null) {
            orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(ref.getDigest()));
        }
        this.xmlOrphanRevocationTokensMap.put(ref.getDSSIdAsString(), orphanToken);
        xmlOrphanRevocation.setToken(orphanToken);
        if (ref instanceof CRLRef) {
            orphanToken.setType(RevocationType.CRL);
            xmlOrphanRevocation.setType(RevocationType.CRL);
            xmlOrphanRevocation.getRevocationRefs().add(this.getXmlCRLRevocationRef((CRLRef)ref, origins));
        } else {
            orphanToken.setType(RevocationType.OCSP);
            xmlOrphanRevocation.setType(RevocationType.OCSP);
            xmlOrphanRevocation.getRevocationRefs().add(this.getXmlOCSPRevocationRef((OCSPRef)ref, origins));
        }
        return xmlOrphanRevocation;
    }

    private XmlPolicy getXmlPolicy(AdvancedSignature signature) {
        SignaturePolicy signaturePolicy = signature.getPolicyId();
        if (signaturePolicy == null) {
            return null;
        }
        XmlPolicy xmlPolicy = new XmlPolicy();
        xmlPolicy.setId(signaturePolicy.getIdentifier());
        xmlPolicy.setUrl(DSSUtils.removeControlCharacters(signaturePolicy.getUrl()));
        xmlPolicy.setDescription(signaturePolicy.getDescription());
        xmlPolicy.setDocumentationReferences(signaturePolicy.getDocumentationReferences());
        xmlPolicy.setNotice(signaturePolicy.getNotice());
        xmlPolicy.setZeroHash(signaturePolicy.isZeroHash());
        Digest digest = signaturePolicy.getDigest();
        if (digest != null) {
            xmlPolicy.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(digest));
        }
        try {
            SignaturePolicyValidator validator = null;
            ServiceLoader<SignaturePolicyValidator> loader = ServiceLoader.load(SignaturePolicyValidator.class);
            Iterator<SignaturePolicyValidator> validatorOptions = loader.iterator();
            if (validatorOptions.hasNext()) {
                for (SignaturePolicyValidator signaturePolicyValidator : loader) {
                    signaturePolicyValidator.setSignature(signature);
                    if (!signaturePolicyValidator.canValidate()) continue;
                    validator = signaturePolicyValidator;
                    break;
                }
            }
            if (validator == null) {
                validator = new BasicASNSignaturePolicyValidator();
                validator.setSignature(signature);
            }
            validator.validate();
            xmlPolicy.setAsn1Processable(validator.isAsn1Processable());
            if (!signaturePolicy.isZeroHash()) {
                xmlPolicy.setDigestAlgorithmsEqual(validator.isDigestAlgorithmsEqual());
            }
            xmlPolicy.setIdentified(validator.isIdentified());
            xmlPolicy.setStatus(validator.isStatus());
            if (Utils.isStringNotBlank(validator.getProcessingErrors())) {
                xmlPolicy.setProcessingError(validator.getProcessingErrors());
            }
        }
        catch (Exception e) {
            xmlPolicy.setStatus(false);
            xmlPolicy.setProcessingError(e.getMessage());
            String errorMessage = "An error occurred during validation a signature policy with id '{}'. Reason : [{}]";
            if (LOG.isDebugEnabled()) {
                LOG.error(errorMessage, signaturePolicy.getIdentifier(), e.getMessage(), e);
            }
            LOG.error(errorMessage, (Object)signaturePolicy.getIdentifier(), (Object)e.getMessage());
        }
        return xmlPolicy;
    }

    private XmlTimestamp buildDetachedXmlTimestamp(TimestampToken timestampToken) {
        XmlTimestamp xmlTimestampToken = new XmlTimestamp();
        xmlTimestampToken.setId(timestampToken.getDSSIdAsString());
        xmlTimestampToken.setType(timestampToken.getTimeStampType());
        xmlTimestampToken.setArchiveTimestampType(timestampToken.getArchiveTimestampType());
        xmlTimestampToken.setProductionTime(timestampToken.getGenerationTime());
        xmlTimestampToken.setTimestampFilename(timestampToken.getFileName());
        xmlTimestampToken.getDigestMatchers().addAll(this.getXmlDigestMatchers(timestampToken));
        xmlTimestampToken.setBasicSignature(this.getXmlBasicSignature(timestampToken));
        xmlTimestampToken.setSignerInformationStore(this.getXmlSignerInformationStore(timestampToken.getSignerInformationStoreInfos()));
        xmlTimestampToken.setPDFRevision(this.getXmlPDFRevision(timestampToken.getPdfRevision()));
        CandidatesForSigningCertificate candidatesForSigningCertificate = timestampToken.getCandidatesForSigningCertificate();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null) {
            xmlTimestampToken.setSigningCertificate(this.getXmlSigningCertificate(timestampToken.getDSSId(), theCertificateValidity));
            xmlTimestampToken.setCertificateChain(this.getXmlForCertificateChain(theCertificateValidity.getPublicKey()));
        }
        xmlTimestampToken.setFoundCertificates(this.getXmlFoundCertificates(timestampToken.getDSSId(), timestampToken.getCertificateSource()));
        xmlTimestampToken.setFoundRevocations(this.getXmlFoundRevocations(timestampToken.getCRLSource(), timestampToken.getOCSPSource()));
        if (this.tokenExtractionStategy.isTimestamp()) {
            xmlTimestampToken.setBase64Encoded(timestampToken.getEncoded());
        } else {
            byte[] certDigest = timestampToken.getDigest(this.defaultDigestAlgorithm);
            xmlTimestampToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
        }
        return xmlTimestampToken;
    }

    private List<XmlDigestMatcher> getXmlDigestMatchers(TimestampToken timestampToken) {
        ArrayList<XmlDigestMatcher> digestMatchers = new ArrayList<XmlDigestMatcher>();
        digestMatchers.add(this.getImprintDigestMatcher(timestampToken));
        digestMatchers.addAll(this.getManifestEntriesDigestMatchers(timestampToken.getManifestFile()));
        return digestMatchers;
    }

    private XmlDigestMatcher getImprintDigestMatcher(TimestampToken timestampToken) {
        XmlDigestMatcher digestMatcher = new XmlDigestMatcher();
        digestMatcher.setType(DigestMatcherType.MESSAGE_IMPRINT);
        Digest messageImprint = timestampToken.getMessageImprint();
        if (messageImprint != null) {
            digestMatcher.setDigestMethod(messageImprint.getAlgorithm());
            digestMatcher.setDigestValue(messageImprint.getValue());
        }
        digestMatcher.setDataFound(timestampToken.isMessageImprintDataFound());
        digestMatcher.setDataIntact(timestampToken.isMessageImprintDataIntact());
        ManifestFile manifestFile = timestampToken.getManifestFile();
        if (manifestFile != null) {
            digestMatcher.setName(manifestFile.getFilename());
        }
        return digestMatcher;
    }

    private List<XmlDigestMatcher> getManifestEntriesDigestMatchers(ManifestFile manifestFile) {
        ArrayList<XmlDigestMatcher> digestMatchers = new ArrayList<XmlDigestMatcher>();
        if (manifestFile != null && Utils.isCollectionNotEmpty(manifestFile.getEntries())) {
            for (ManifestEntry entry : manifestFile.getEntries()) {
                XmlDigestMatcher digestMatcher = new XmlDigestMatcher();
                digestMatcher.setType(DigestMatcherType.MANIFEST_ENTRY);
                Digest digest = entry.getDigest();
                if (digest != null) {
                    digestMatcher.setDigestMethod(digest.getAlgorithm());
                    digestMatcher.setDigestValue(digest.getValue());
                }
                digestMatcher.setDataFound(entry.isFound());
                digestMatcher.setDataIntact(entry.isIntact());
                digestMatcher.setName(entry.getFileName());
                digestMatchers.add(digestMatcher);
            }
        }
        return digestMatchers;
    }

    private List<XmlTimestampedObject> getXmlTimestampedObjects(TimestampToken timestampToken) {
        List<TimestampedReference> timestampReferences = timestampToken.getTimestampedReferences();
        if (Utils.isCollectionNotEmpty(timestampReferences)) {
            ArrayList<XmlTimestampedObject> objects = new ArrayList<XmlTimestampedObject>();
            HashSet<String> addedTokenIds = new HashSet<String>();
            for (TimestampedReference timestampReference : timestampReferences) {
                String id = timestampReference.getObjectId();
                XmlTimestampedObject timestampedObject = this.createXmlTimestampedObject(timestampReference);
                if (timestampedObject.getToken() == null) {
                    throw new DSSException(String.format("Token with Id '%s' not found", id));
                }
                id = timestampedObject.getToken().getId();
                if (addedTokenIds.contains(id)) continue;
                addedTokenIds.add(id);
                objects.add(timestampedObject);
            }
            return objects;
        }
        return null;
    }

    private XmlTimestampedObject createXmlTimestampedObject(TimestampedReference timestampReference) {
        XmlTimestampedObject timestampedObj = new XmlTimestampedObject();
        timestampedObj.setCategory(timestampReference.getCategory());
        String objectId = timestampReference.getObjectId();
        switch (timestampReference.getCategory()) {
            case SIGNATURE: {
                timestampedObj.setToken(this.xmlSignaturesMap.get(objectId));
                return timestampedObj;
            }
            case CERTIFICATE: {
                String relatedCertificateId;
                if (!this.isUsedToken(objectId, this.usedCertificates) && ((relatedCertificateId = this.referenceMap.get(objectId)) == null || !this.isUsedToken(objectId = relatedCertificateId, this.usedCertificates))) break;
                timestampedObj.setToken(this.xmlCertsMap.get(objectId));
                return timestampedObj;
            }
            case REVOCATION: {
                String relatedRevocationId;
                if (!this.isUsedToken(objectId, this.usedRevocations) && ((relatedRevocationId = this.referenceMap.get(objectId)) == null || !this.isUsedToken(objectId = relatedRevocationId, this.usedRevocations))) break;
                timestampedObj.setToken(this.xmlRevocationsMap.get(objectId));
                return timestampedObj;
            }
            case TIMESTAMP: {
                timestampedObj.setToken(this.xmlTimestampsMap.get(objectId));
                return timestampedObj;
            }
            case SIGNED_DATA: {
                timestampedObj.setToken(this.xmlSignedDataMap.get(objectId));
                return timestampedObj;
            }
            default: {
                throw new DSSException("Unsupported category " + (Object)((Object)timestampReference.getCategory()));
            }
        }
        if (TimestampedObjectType.CERTIFICATE.equals((Object)timestampedObj.getCategory())) {
            timestampedObj.setToken(this.xmlOrphanCertificateTokensMap.get(objectId));
            timestampedObj.setCategory(TimestampedObjectType.ORPHAN_CERTIFICATE);
        } else if (TimestampedObjectType.REVOCATION.equals((Object)timestampedObj.getCategory())) {
            timestampedObj.setToken(this.xmlOrphanRevocationTokensMap.get(objectId));
            timestampedObj.setCategory(TimestampedObjectType.ORPHAN_REVOCATION);
        } else {
            throw new DSSException(String.format("The type of object [%s] is not supported for Orphan Tokens!", new Object[]{timestampedObj.getCategory()}));
        }
        return timestampedObj;
    }

    private <T extends Token> boolean isUsedToken(String tokenId, Collection<T> usedTokens) {
        for (Token token : usedTokens) {
            if (!token.getDSSIdAsString().equals(tokenId)) continue;
            return true;
        }
        return false;
    }

    private XmlBasicSignature getXmlBasicSignature(Token token) {
        XmlBasicSignature xmlBasicSignatureType = new XmlBasicSignature();
        SignatureAlgorithm signatureAlgorithm = token.getSignatureAlgorithm();
        if (signatureAlgorithm != null) {
            xmlBasicSignatureType.setEncryptionAlgoUsedToSignThisToken(signatureAlgorithm.getEncryptionAlgorithm());
            xmlBasicSignatureType.setDigestAlgoUsedToSignThisToken(signatureAlgorithm.getDigestAlgorithm());
            xmlBasicSignatureType.setMaskGenerationFunctionUsedToSignThisToken(signatureAlgorithm.getMaskGenerationFunction());
        }
        xmlBasicSignatureType.setKeyLengthUsedToSignThisToken(DSSPKUtils.getPublicKeySize(token));
        SignatureValidity signatureValidity = token.getSignatureValidity();
        if (SignatureValidity.NOT_EVALUATED != signatureValidity) {
            boolean signatureValid = SignatureValidity.VALID == token.getSignatureValidity();
            xmlBasicSignatureType.setSignatureIntact(signatureValid);
            xmlBasicSignatureType.setSignatureValid(signatureValid);
        }
        return xmlBasicSignatureType;
    }

    private XmlBasicSignature getXmlBasicSignature(AdvancedSignature signature, PublicKey signingCertificatePublicKey) {
        XmlBasicSignature xmlBasicSignature = new XmlBasicSignature();
        xmlBasicSignature.setEncryptionAlgoUsedToSignThisToken(signature.getEncryptionAlgorithm());
        int keyLength = signingCertificatePublicKey == null ? 0 : DSSPKUtils.getPublicKeySize(signingCertificatePublicKey);
        xmlBasicSignature.setKeyLengthUsedToSignThisToken(String.valueOf(keyLength));
        xmlBasicSignature.setDigestAlgoUsedToSignThisToken(signature.getDigestAlgorithm());
        xmlBasicSignature.setMaskGenerationFunctionUsedToSignThisToken(signature.getMaskGenerationFunction());
        SignatureCryptographicVerification scv = signature.getSignatureCryptographicVerification();
        xmlBasicSignature.setSignatureIntact(scv.isSignatureIntact());
        xmlBasicSignature.setSignatureValid(scv.isSignatureValid());
        return xmlBasicSignature;
    }

    private List<XmlDigestMatcher> getXmlDigestMatchers(AdvancedSignature signature) {
        ArrayList<XmlDigestMatcher> refs = new ArrayList<XmlDigestMatcher>();
        List<ReferenceValidation> refValidations = signature.getReferenceValidations();
        if (Utils.isCollectionNotEmpty(refValidations)) {
            for (ReferenceValidation referenceValidation : refValidations) {
                refs.add(this.getXmlDigestMatcher(referenceValidation));
                List<ReferenceValidation> dependentValidations = referenceValidation.getDependentValidations();
                if (!Utils.isCollectionNotEmpty(dependentValidations) || !Utils.isCollectionNotEmpty(signature.getDetachedContents()) && !this.isAtLeastOneFound(dependentValidations)) continue;
                for (ReferenceValidation dependentValidation : referenceValidation.getDependentValidations()) {
                    refs.add(this.getXmlDigestMatcher(dependentValidation));
                }
            }
        }
        return refs;
    }

    public boolean isAtLeastOneFound(List<ReferenceValidation> referenceValidations) {
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (!referenceValidation.isFound()) continue;
            return true;
        }
        return false;
    }

    private XmlDigestMatcher getXmlDigestMatcher(ReferenceValidation referenceValidation) {
        XmlDigestMatcher ref = new XmlDigestMatcher();
        ref.setType(referenceValidation.getType());
        ref.setName(referenceValidation.getName());
        Digest digest = referenceValidation.getDigest();
        if (digest != null) {
            ref.setDigestValue(digest.getValue());
            ref.setDigestMethod(digest.getAlgorithm());
        }
        ref.setDataFound(referenceValidation.isFound());
        ref.setDataIntact(referenceValidation.isIntact());
        return ref;
    }

    private List<XmlSignatureScope> getXmlSignatureScopes(List<SignatureScope> scopes) {
        ArrayList<XmlSignatureScope> xmlScopes = new ArrayList<XmlSignatureScope>();
        if (Utils.isCollectionNotEmpty(scopes)) {
            for (SignatureScope xmlSignatureScope : scopes) {
                xmlScopes.add(this.getXmlSignatureScope(xmlSignatureScope));
            }
        }
        return xmlScopes;
    }

    private XmlSignatureScope getXmlSignatureScope(SignatureScope scope) {
        XmlSignatureScope xmlSignatureScope = new XmlSignatureScope();
        xmlSignatureScope.setName(scope.getName());
        xmlSignatureScope.setScope(scope.getType());
        xmlSignatureScope.setDescription(scope.getDescription());
        xmlSignatureScope.setTransformations(scope.getTransformations());
        xmlSignatureScope.setSignerData(this.xmlSignedDataMap.get(scope.getDSSIdAsString()));
        return xmlSignatureScope;
    }

    private XmlCertificate buildDetachedXmlCertificate(CertificateToken certToken) {
        XmlCertificate xmlCert = new XmlCertificate();
        xmlCert.setId(certToken.getDSSIdAsString());
        X500PrincipalHelper subject = certToken.getSubject();
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", subject.getCanonical()));
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", subject.getRFC2253()));
        X500PrincipalHelper issuer = certToken.getIssuer();
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", issuer.getCanonical()));
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", issuer.getRFC2253()));
        xmlCert.setSerialNumber(certToken.getSerialNumber());
        xmlCert.setSubjectSerialNumber(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.SERIALNUMBER, subject));
        xmlCert.setCommonName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.CN, subject));
        xmlCert.setLocality(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.L, subject));
        xmlCert.setState(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.ST, subject));
        xmlCert.setCountryName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.C, subject));
        xmlCert.setOrganizationIdentifier(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.ORGANIZATION_IDENTIFIER, subject));
        xmlCert.setOrganizationName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.O, subject));
        xmlCert.setOrganizationalUnit(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.OU, subject));
        xmlCert.setGivenName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.GIVENNAME, subject));
        xmlCert.setSurname(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.SURNAME, subject));
        xmlCert.setPseudonym(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.PSEUDONYM, subject));
        xmlCert.setEmail(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.E, subject));
        List<String> subjectAlternativeNames = DSSASN1Utils.getSubjectAlternativeNames(certToken);
        if (Utils.isCollectionNotEmpty(subjectAlternativeNames)) {
            xmlCert.setSubjectAlternativeNames(subjectAlternativeNames);
        }
        xmlCert.setAuthorityInformationAccessUrls(this.getCleanedUrls(DSSASN1Utils.getCAAccessLocations(certToken)));
        xmlCert.setOCSPAccessUrls(this.getCleanedUrls(DSSASN1Utils.getOCSPAccessLocations(certToken)));
        xmlCert.setCRLDistributionPoints(this.getCleanedUrls(DSSASN1Utils.getCrlUrls(certToken)));
        xmlCert.setSources(this.getXmlCertificateSources(certToken));
        xmlCert.setNotAfter(certToken.getNotAfter());
        xmlCert.setNotBefore(certToken.getNotBefore());
        PublicKey publicKey = certToken.getPublicKey();
        xmlCert.setPublicKeySize(DSSPKUtils.getPublicKeySize(publicKey));
        xmlCert.setPublicKeyEncryptionAlgo(EncryptionAlgorithm.forKey(publicKey));
        xmlCert.setEntityKey(certToken.getEntityKey().asXmlId());
        xmlCert.setKeyUsageBits(certToken.getKeyUsageBits());
        xmlCert.setExtendedKeyUsages(this.getXmlOids(DSSASN1Utils.getExtendedKeyUsage(certToken)));
        xmlCert.setIdPkixOcspNoCheck(DSSASN1Utils.hasIdPkixOcspNoCheckExtension(certToken));
        xmlCert.setPSD2Info(this.getPSD2Info(certToken));
        xmlCert.setBasicSignature(this.getXmlBasicSignature(certToken));
        xmlCert.setQCStatementIds(this.getXmlOids(DSSASN1Utils.getQCStatementsIdList(certToken)));
        xmlCert.setQCTypes(this.getXmlOids(DSSASN1Utils.getQCTypesIdList(certToken)));
        xmlCert.setCertificatePolicies(this.getXmlCertificatePolicies(DSSASN1Utils.getCertificatePolicies(certToken)));
        xmlCert.setSemanticsIdentifier(this.getXmlOid(DSSASN1Utils.getSemanticsIdentifier(certToken)));
        xmlCert.setSelfSigned(certToken.isSelfSigned());
        xmlCert.setTrusted(this.trustedCertSources.isTrusted(certToken));
        if (this.tokenExtractionStategy.isCertificate()) {
            xmlCert.setBase64Encoded(certToken.getEncoded());
        } else {
            byte[] certDigest = certToken.getDigest(this.defaultDigestAlgorithm);
            xmlCert.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
        }
        return xmlCert;
    }

    private XmlOID getXmlOid(OidDescription oidDescription) {
        if (oidDescription == null) {
            return null;
        }
        XmlOID xmlOID = new XmlOID();
        xmlOID.setValue(oidDescription.getOid());
        xmlOID.setDescription(oidDescription.getDescription());
        return xmlOID;
    }

    private XmlPSD2Info getPSD2Info(CertificateToken certToken) {
        PSD2QcType psd2QcStatement = DSSASN1Utils.getPSD2QcStatement(certToken);
        if (psd2QcStatement != null) {
            XmlPSD2Info xmlInfo = new XmlPSD2Info();
            xmlInfo.setNcaId(psd2QcStatement.getNcaId());
            xmlInfo.setNcaName(psd2QcStatement.getNcaName());
            List<RoleOfPSP> rolesOfPSP = psd2QcStatement.getRolesOfPSP();
            ArrayList<XmlPSD2Role> psd2Roles = new ArrayList<XmlPSD2Role>();
            for (RoleOfPSP roleOfPSP : rolesOfPSP) {
                XmlPSD2Role xmlRole = new XmlPSD2Role();
                RoleOfPspOid role = roleOfPSP.getPspOid();
                xmlRole.setPspOid(this.getXmlOid(role));
                xmlRole.setPspName(roleOfPSP.getPspName());
                psd2Roles.add(xmlRole);
            }
            xmlInfo.setPSD2Roles(psd2Roles);
            return xmlInfo;
        }
        return null;
    }

    private List<CertificateSourceType> getXmlCertificateSources(CertificateToken token) {
        Set<CertificateSourceType> sourceTypes;
        ArrayList<CertificateSourceType> certificateSources = new ArrayList<CertificateSourceType>();
        if (this.certificateSourceTypes != null && (sourceTypes = this.certificateSourceTypes.get(token)) != null) {
            certificateSources.addAll(sourceTypes);
        }
        if (Utils.isCollectionEmpty(certificateSources)) {
            certificateSources.add(CertificateSourceType.UNKNOWN);
        }
        return certificateSources;
    }

    private Set<RevocationToken<Revocation>> getRevocationsForCert(CertificateToken certToken) {
        HashSet<RevocationToken<Revocation>> revocations = new HashSet<RevocationToken<Revocation>>();
        if (Utils.isCollectionNotEmpty(this.usedRevocations)) {
            for (RevocationToken<Revocation> revocationToken : this.usedRevocations) {
                if (!Utils.areStringsEqual(certToken.getDSSIdAsString(), revocationToken.getRelatedCertificateID())) continue;
                revocations.add(revocationToken);
            }
        }
        return revocations;
    }

    private List<XmlCertificatePolicy> getXmlCertificatePolicies(List<CertificatePolicy> certificatePolicies) {
        ArrayList<XmlCertificatePolicy> result = new ArrayList<XmlCertificatePolicy>();
        for (CertificatePolicy cp : certificatePolicies) {
            XmlCertificatePolicy xmlCP = new XmlCertificatePolicy();
            xmlCP.setValue(cp.getOid());
            xmlCP.setDescription(OidRepository.getDescription(cp.getOid()));
            xmlCP.setCpsUrl(DSSUtils.removeControlCharacters(cp.getCpsUrl()));
            result.add(xmlCP);
        }
        return result;
    }

    private List<XmlOID> getXmlOids(List<String> oidList) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        if (Utils.isCollectionNotEmpty(oidList)) {
            for (String oid : oidList) {
                XmlOID xmlOID = new XmlOID();
                xmlOID.setValue(oid);
                xmlOID.setDescription(OidRepository.getDescription(oid));
                result.add(xmlOID);
            }
        }
        return result;
    }

    private List<XmlTrustedServiceProvider> getXmlTrustedServiceProviders(CertificateToken certToken) {
        ArrayList<XmlTrustedServiceProvider> result = new ArrayList<XmlTrustedServiceProvider>();
        Map<CertificateToken, List<TrustProperties>> servicesByTrustedCert = this.getRelatedTrustServices(certToken);
        for (Map.Entry<CertificateToken, List<TrustProperties>> entry : servicesByTrustedCert.entrySet()) {
            CertificateToken trustedCert = entry.getKey();
            List<TrustProperties> services = entry.getValue();
            Map<TrustServiceProvider, List<TrustProperties>> servicesByProviders = this.classifyByServiceProvider(services);
            for (Map.Entry<TrustServiceProvider, List<TrustProperties>> servicesByProvider : servicesByProviders.entrySet()) {
                List<TrustProperties> trustServices = servicesByProvider.getValue();
                XmlTrustedServiceProvider serviceProvider = this.buildXmlTrustedServiceProvider(trustServices.iterator().next());
                serviceProvider.setTrustedServices(this.buildXmlTrustedServices(trustServices, certToken, trustedCert));
                result.add(serviceProvider);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private XmlTrustedServiceProvider buildXmlTrustedServiceProvider(TrustProperties trustProperties) {
        XmlTrustedServiceProvider result = new XmlTrustedServiceProvider();
        if (trustProperties.getLOTLIdentifier() != null) {
            result.setLOTL(this.xmlTrustedListsMap.get(trustProperties.getLOTLIdentifier().asXmlId()));
        }
        if (trustProperties.getTLIdentifier() != null) {
            result.setTL(this.xmlTrustedListsMap.get(trustProperties.getTLIdentifier().asXmlId()));
        }
        TrustServiceProvider tsp = trustProperties.getTrustServiceProvider();
        result.setTSPNames(this.getLangAndValues(tsp.getNames()));
        result.setTSPTradeNames(this.getLangAndValues(tsp.getTradeNames()));
        result.setTSPRegistrationIdentifiers(tsp.getRegistrationIdentifiers());
        return result;
    }

    private List<XmlLangAndValue> getLangAndValues(Map<String, List<String>> map) {
        if (Utils.isMapNotEmpty(map)) {
            ArrayList<XmlLangAndValue> result = new ArrayList<XmlLangAndValue>();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String lang = entry.getKey();
                for (String value : entry.getValue()) {
                    XmlLangAndValue langAndValue = new XmlLangAndValue();
                    langAndValue.setLang(lang);
                    langAndValue.setValue(value);
                    result.add(langAndValue);
                }
            }
            return result;
        }
        return null;
    }

    private Map<CertificateToken, List<TrustProperties>> getRelatedTrustServices(CertificateToken certToken) {
        HashMap<CertificateToken, List<TrustProperties>> result = new HashMap<CertificateToken, List<TrustProperties>>();
        HashSet<CertificateToken> processedTokens = new HashSet<CertificateToken>();
        block0: for (CertificateSource trustedSource : this.trustedCertSources.getSources()) {
            if (!(trustedSource instanceof TrustedListsCertificateSource)) continue;
            TrustedListsCertificateSource trustedCertSource = (TrustedListsCertificateSource)trustedSource;
            while (certToken != null) {
                List<TrustProperties> trustServices = trustedCertSource.getTrustServices(certToken);
                if (!trustServices.isEmpty()) {
                    result.put(certToken, trustServices);
                }
                if (certToken.isSelfSigned() || processedTokens.contains(certToken)) continue block0;
                processedTokens.add(certToken);
                certToken = this.getIssuerCertificate(certToken);
            }
        }
        return result;
    }

    private List<XmlTrustedService> buildXmlTrustedServices(List<TrustProperties> trustPropertiesList, CertificateToken certToken, CertificateToken trustedCert) {
        ArrayList<XmlTrustedService> result = new ArrayList<XmlTrustedService>();
        for (TrustProperties trustProperties : trustPropertiesList) {
            TimeDependentValues<TrustServiceStatusAndInformationExtensions> trustService = trustProperties.getTrustService();
            List<TrustServiceStatusAndInformationExtensions> serviceStatusAfterOfEqualsCertIssuance = trustService.getAfter(certToken.getNotBefore());
            if (!Utils.isCollectionNotEmpty(serviceStatusAfterOfEqualsCertIssuance)) continue;
            for (TrustServiceStatusAndInformationExtensions serviceInfoStatus : serviceStatusAfterOfEqualsCertIssuance) {
                List<String> serviceSupplyPoints;
                List<String> additionalServiceInfoUris;
                XmlTrustedService trustedService = new XmlTrustedService();
                trustedService.setServiceDigitalIdentifier(this.xmlCertsMap.get(trustedCert.getDSSIdAsString()));
                trustedService.setServiceNames(this.getLangAndValues(serviceInfoStatus.getNames()));
                trustedService.setServiceType(serviceInfoStatus.getType());
                trustedService.setStatus(serviceInfoStatus.getStatus());
                trustedService.setStartDate(serviceInfoStatus.getStartDate());
                trustedService.setEndDate(serviceInfoStatus.getEndDate());
                List<String> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
                if (Utils.isCollectionNotEmpty(qualifiers)) {
                    trustedService.setCapturedQualifiers(qualifiers);
                }
                if (Utils.isCollectionNotEmpty(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris())) {
                    trustedService.setAdditionalServiceInfoUris(additionalServiceInfoUris);
                }
                if (Utils.isCollectionNotEmpty(serviceSupplyPoints = serviceInfoStatus.getServiceSupplyPoints())) {
                    trustedService.setServiceSupplyPoints(serviceSupplyPoints);
                }
                trustedService.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
                result.add(trustedService);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Map<TrustServiceProvider, List<TrustProperties>> classifyByServiceProvider(List<TrustProperties> trustPropertiesList) {
        HashMap<TrustServiceProvider, List<TrustProperties>> servicesByProviders = new HashMap<TrustServiceProvider, List<TrustProperties>>();
        if (Utils.isCollectionNotEmpty(trustPropertiesList)) {
            for (TrustProperties trustProperties : trustPropertiesList) {
                TrustServiceProvider currentTrustServiceProvider = trustProperties.getTrustServiceProvider();
                ArrayList<TrustProperties> list = (ArrayList<TrustProperties>)servicesByProviders.get(currentTrustServiceProvider);
                if (list == null) {
                    list = new ArrayList<TrustProperties>();
                    servicesByProviders.put(currentTrustServiceProvider, list);
                }
                list.add(trustProperties);
            }
        }
        return servicesByProviders;
    }

    private List<String> getQualifiers(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certificateToken) {
        LOG.trace("--> GET_QUALIFIERS()");
        ArrayList<String> list = new ArrayList<String>();
        List<ConditionForQualifiers> conditionsForQualifiers = serviceInfoStatus.getConditionsForQualifiers();
        if (Utils.isCollectionNotEmpty(conditionsForQualifiers)) {
            for (ConditionForQualifiers conditionForQualifiers : conditionsForQualifiers) {
                Condition condition = conditionForQualifiers.getCondition();
                if (!condition.check(certificateToken)) continue;
                list.addAll(conditionForQualifiers.getQualifiers());
            }
        }
        return list;
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(Digest digest) {
        if (digest == null) {
            return this.getXmlDigestAlgoAndValue(null, null);
        }
        return this.getXmlDigestAlgoAndValue(digest.getAlgorithm(), digest.getValue());
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(DigestAlgorithm digestAlgo, byte[] digestValue) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digestAlgo);
        xmlDigestAlgAndValue.setDigestValue(digestValue == null ? DSSUtils.EMPTY_BYTE_ARRAY : digestValue);
        return xmlDigestAlgAndValue;
    }

    private String emptyToNull(String text) {
        if (Utils.isStringEmpty(text)) {
            return null;
        }
        return text;
    }
}

