/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.BasicBuildingBlocks;
import eu.europa.esig.dss.validation.process.qualification.trust.TLValidationBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractDetailedReportBuilder {
    protected final I18nProvider i18nProvider;
    protected final DiagnosticData diagnosticData;
    protected final ValidationPolicy policy;
    protected final Date currentTime;

    protected AbstractDetailedReportBuilder(I18nProvider i18nProvider, Date currentTime, ValidationPolicy policy, DiagnosticData diagnosticData) {
        this.i18nProvider = i18nProvider;
        this.currentTime = currentTime;
        this.policy = policy;
        this.diagnosticData = diagnosticData;
    }

    protected XmlDetailedReport init() {
        XmlDetailedReport detailedReport = new XmlDetailedReport();
        if (this.policy.isEIDASConstraintPresent()) {
            detailedReport.getTLAnalysis().addAll(this.executeAllTlAnalysis(this.diagnosticData, this.policy, this.currentTime));
        }
        return detailedReport;
    }

    protected List<XmlTLAnalysis> executeAllTlAnalysis(DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime) {
        ArrayList<XmlTLAnalysis> result = new ArrayList<XmlTLAnalysis>();
        result.addAll(this.validateTL(policy, currentTime, diagnosticData.getListOfTrustedLists()));
        result.addAll(this.validateTL(policy, currentTime, diagnosticData.getTrustedLists()));
        return result;
    }

    private List<XmlTLAnalysis> validateTL(ValidationPolicy policy, Date currentTime, List<XmlTrustedList> trustedLists) {
        ArrayList<XmlTLAnalysis> result = new ArrayList<XmlTLAnalysis>();
        if (Utils.isCollectionNotEmpty(trustedLists)) {
            for (XmlTrustedList xmlTrustedList : trustedLists) {
                TLValidationBlock tlValidation = new TLValidationBlock(this.i18nProvider, xmlTrustedList, currentTime, policy);
                result.add((XmlTLAnalysis)tlValidation.execute());
            }
        }
        return result;
    }

    protected void process(Collection<? extends AbstractTokenProxy> tokensToProcess, Context context, Map<String, XmlBasicBuildingBlocks> bbbs) {
        for (AbstractTokenProxy abstractTokenProxy : tokensToProcess) {
            BasicBuildingBlocks bbb = new BasicBuildingBlocks(this.i18nProvider, this.diagnosticData, abstractTokenProxy, this.currentTime, this.policy, context);
            XmlBasicBuildingBlocks result = bbb.execute();
            bbbs.put(abstractTokenProxy.getId(), result);
        }
    }
}

