/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.validation.executor.AbstractProcessExecutor;
import eu.europa.esig.dss.validation.executor.DocumentProcessExecutor;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.executor.signature.DetailedReportBuilder;
import eu.europa.esig.dss.validation.executor.signature.ETSIValidationReportBuilder;
import eu.europa.esig.dss.validation.executor.signature.SimpleReportBuilder;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.validationreport.jaxb.ValidationReportType;
import java.util.Objects;

public class DefaultSignatureProcessExecutor
extends AbstractProcessExecutor
implements DocumentProcessExecutor {
    protected ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    protected boolean enableEtsiValidationReport = true;
    protected boolean includeSemantics = false;

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public void setIncludeSemantics(boolean includeSemantics) {
        this.includeSemantics = includeSemantics;
    }

    @Override
    public Reports execute() {
        this.assertConfigurationValid();
        Objects.requireNonNull(this.validationLevel, "The validation level is missing");
        DiagnosticData diagnosticData = this.getDiagnosticData();
        return this.buildReports(diagnosticData);
    }

    protected DiagnosticData getDiagnosticData() {
        return new DiagnosticData(this.jaxbDiagnosticData);
    }

    protected Reports buildReports(DiagnosticData diagnosticData) {
        DetailedReportBuilder detailedReportBuilder = new DetailedReportBuilder(this.getI18nProvider(), this.currentTime, this.policy, this.validationLevel, diagnosticData);
        XmlDetailedReport jaxbDetailedReport = detailedReportBuilder.build();
        DetailedReport detailedReportWrapper = new DetailedReport(jaxbDetailedReport);
        SimpleReportBuilder simpleReportBuilder = new SimpleReportBuilder(this.getI18nProvider(), this.currentTime, this.policy, diagnosticData, detailedReportWrapper, this.includeSemantics);
        XmlSimpleReport simpleReport = simpleReportBuilder.build();
        ValidationReportType validationReport = null;
        if (this.enableEtsiValidationReport) {
            ETSIValidationReportBuilder etsiValidationReportBuilder = new ETSIValidationReportBuilder(this.currentTime, diagnosticData, detailedReportWrapper);
            validationReport = etsiValidationReportBuilder.build();
        }
        return new Reports(this.jaxbDiagnosticData, jaxbDetailedReport, simpleReport, validationReport);
    }
}

