/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationConsistentCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;
    private final RevocationWrapper revocationData;
    private Date thisUpdate;
    private Date certNotBefore;
    private Date certNotAfter;
    private Date notAfterRevoc;
    private boolean certHashOK;

    public RevocationConsistentCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, RevocationWrapper revocationData, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.revocationData = revocationData;
    }

    @Override
    protected boolean process() {
        Date expiredCertsRevocationInfo;
        CertificateWrapper revocCert;
        Date archiveCutOff;
        this.certNotBefore = this.certificate.getNotBefore();
        this.certNotAfter = this.certificate.getNotAfter();
        this.notAfterRevoc = this.thisUpdate = this.revocationData.getThisUpdate();
        Date expiredCertsOnCRL = this.revocationData.getExpiredCertsOnCRL();
        if (expiredCertsOnCRL != null) {
            this.notAfterRevoc = expiredCertsOnCRL;
        }
        if ((archiveCutOff = this.revocationData.getArchiveCutOff()) != null) {
            this.notAfterRevoc = archiveCutOff;
        }
        if ((expiredCertsOnCRL != null || archiveCutOff != null) && (revocCert = this.revocationData.getSigningCertificate()) != null && (expiredCertsRevocationInfo = revocCert.getCertificateTSPServiceExpiredCertsRevocationInfo()) != null && expiredCertsRevocationInfo.before(this.notAfterRevoc)) {
            this.notAfterRevoc = expiredCertsRevocationInfo;
        }
        this.certHashOK = this.revocationData.isCertHashExtensionPresent() && this.revocationData.isCertHashExtensionMatch();
        return this.thisUpdate != null && this.certNotBefore.compareTo(this.thisUpdate) <= 0 && (this.certNotAfter.compareTo(this.notAfterRevoc) >= 0 || this.certHashOK);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IRDC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IRDC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        if (this.thisUpdate == null) {
            return MessageTag.REVOCATION_NO_THIS_UPDATE.setArgs(this.revocationData.getId());
        }
        if (!this.certNotBefore.before(this.thisUpdate)) {
            return MessageTag.REVOCATION_THIS_UPDATE_BEFORE.setArgs(this.revocationData.getId(), ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
        }
        if (this.certNotAfter.compareTo(this.notAfterRevoc) < 0 && !this.certHashOK) {
            return MessageTag.REVOCATION_NOT_AFTER_AFTER.setArgs(this.revocationData.getId(), ValidationProcessUtils.getFormattedDate(this.notAfterRevoc), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
        }
        if (this.certHashOK) {
            return MessageTag.REVOCATION_CERT_HASH_OK.setArgs(this.revocationData.getId());
        }
        return MessageTag.REVOCATION_CONSISTENT.setArgs(this.revocationData.getId(), ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }
}

