/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.BigIntegers;

public final class DSSSignatureUtils {
    private DSSSignatureUtils() {
    }

    public static byte[] convertToXmlDSig(EncryptionAlgorithm algorithm, byte[] signatureValue) {
        if (EncryptionAlgorithm.ECDSA == algorithm && DSSSignatureUtils.isAsn1Encoded(signatureValue)) {
            return DSSSignatureUtils.convertASN1toXMLDSIG(signatureValue);
        }
        if (EncryptionAlgorithm.DSA == algorithm) {
            return DSSSignatureUtils.convertASN1toXMLDSIG(signatureValue);
        }
        return signatureValue;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] convertASN1toXMLDSIG(byte[] binaries) {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ASN1InputStream is = new ASN1InputStream(binaries);){
                byte[] sBytes;
                int sSize;
                ASN1Sequence seq = (ASN1Sequence)is.readObject();
                if (seq.size() != 2) {
                    throw new IllegalArgumentException("ASN1 Sequence size should be 2 !");
                }
                ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
                ASN1Integer s2 = (ASN1Integer)seq.getObjectAt(1);
                byte[] rBytes = BigIntegers.asUnsignedByteArray(r.getValue());
                int rSize = rBytes.length;
                int max = Math.max(rSize, sSize = (sBytes = BigIntegers.asUnsignedByteArray(s2.getValue())).length);
                max = max % 2 == 0 ? max : max + 1;
                DSSSignatureUtils.leftPad(buffer, max, rBytes);
                buffer.write(rBytes);
                DSSSignatureUtils.leftPad(buffer, max, sBytes);
                buffer.write(sBytes);
                byArray = buffer.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new DSSException("Unable to convert to xmlDsig : " + e.getMessage(), e);
        }
    }

    private static void leftPad(ByteArrayOutputStream stream, int size, byte[] array) {
        int diff = size - array.length;
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                stream.write(0);
            }
        }
    }

    private static boolean isAsn1Encoded(byte[] signatureValue) {
        boolean bl;
        ASN1InputStream is = new ASN1InputStream(signatureValue);
        try {
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            bl = seq != null && seq.size() == 2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        is.close();
        return bl;
    }
}

