/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ISignatureAttribute;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Attribute;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESAttribute
implements ISignatureAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESAttribute.class);
    private final Element element;
    private final XAdESPaths xadesPaths;
    private String localName;

    XAdESAttribute(Element element, XAdESPaths xadesPaths) {
        this.element = element;
        this.xadesPaths = xadesPaths;
    }

    public String getName() {
        if (this.localName == null) {
            this.localName = this.element.getLocalName();
        }
        return this.localName;
    }

    public String getNamespace() {
        return this.element.getNamespaceURI();
    }

    public final Element findElement(String xPathExpression) {
        return DomUtils.getElement(this.element, xPathExpression);
    }

    public final NodeList getNodeList(String xPathExpression) {
        return DomUtils.getNodeList(this.element, xPathExpression);
    }

    public String getTimestampCanonicalizationMethod() {
        String canonicalizationMethod = DomUtils.getValue(this.element, XMLDSigPaths.CANONICALIZATION_ALGORITHM_PATH);
        if (Utils.isStringEmpty(canonicalizationMethod)) {
            NodeList nodeList = DomUtils.getNodeList(this.element, XAdES111Paths.HASH_DATA_INFO_TRANSFORM_PATH);
            if (nodeList != null && nodeList.getLength() == 1) {
                Element transform = (Element)nodeList.item(0);
                canonicalizationMethod = transform.getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
            } else {
                LOG.warn("Unable to retrieve the canonicalization algorithm");
            }
        }
        return canonicalizationMethod;
    }

    public List<TimestampInclude> getTimestampIncludedReferences() {
        NodeList timestampIncludes;
        String currentIncludePath = this.xadesPaths.getCurrentInclude();
        if (currentIncludePath != null && (timestampIncludes = DomUtils.getNodeList(this.element, currentIncludePath)) != null && timestampIncludes.getLength() > 0) {
            ArrayList<TimestampInclude> includes = new ArrayList<TimestampInclude>();
            for (int jj = 0; jj < timestampIncludes.getLength(); ++jj) {
                Element include = (Element)timestampIncludes.item(jj);
                String uri = DomUtils.getId(include.getAttribute(XAdES132Attribute.URI.getAttributeName()));
                String referencedData = include.getAttribute(XAdES132Attribute.REFERENCED_DATA.getAttributeName());
                includes.add(new TimestampInclude(uri, Boolean.parseBoolean(referencedData)));
            }
            return includes;
        }
        return null;
    }

    public int getElementHashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

