/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestEntrySignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.scope.XPointerSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlElementSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlFullSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlRootSignatureScope;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder<XAdESSignature> {
    @Override
    public List<SignatureScope> findSignatureScope(XAdESSignature xadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        List<ReferenceValidation> referenceValidations = xadesSignature.getReferenceValidations();
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (DigestMatcherType.SIGNED_PROPERTIES.equals((Object)referenceValidation.getType()) || DigestMatcherType.KEY_INFO.equals((Object)referenceValidation.getType()) || !(referenceValidation instanceof XAdESReferenceValidation)) continue;
            XAdESReferenceValidation xadesReferenceValidation = (XAdESReferenceValidation)referenceValidation;
            String id = xadesReferenceValidation.getId();
            String uri = xadesReferenceValidation.getUri();
            String xmlIdOfSignedElement = DomUtils.getId(uri);
            List<String> transformations = xadesReferenceValidation.getTransformationNames();
            if (xadesReferenceValidation.isFound() && DigestMatcherType.XPOINTER.equals((Object)xadesReferenceValidation.getType())) {
                result.add(new XPointerSignatureScope(id, uri, this.getDigest(xadesReferenceValidation.getOriginalContentBytes())));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.OBJECT.equals((Object)xadesReferenceValidation.getType())) {
                Node objectById = xadesSignature.getObjectById(uri);
                if (objectById == null || !objectById.hasChildNodes()) continue;
                Node referencedObject = objectById.getFirstChild();
                result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations, this.getDigest(DSSXMLUtils.getNodeBytes(referencedObject))));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.MANIFEST.equals((Object)xadesReferenceValidation.getType())) {
                result.add(new ManifestSignatureScope(xadesReferenceValidation.getName(), xadesReferenceValidation.getDigest(), xadesReferenceValidation.getTransformationNames()));
                for (ReferenceValidation manifestEntry : xadesReferenceValidation.getDependentValidations()) {
                    if (manifestEntry.getName() == null || !manifestEntry.isFound()) continue;
                    List<SignatureScope> detachedResult = this.getFromDetachedContent(xadesSignature, transformations, manifestEntry.getName());
                    if (Utils.isCollectionNotEmpty(detachedResult)) {
                        result.addAll(detachedResult);
                        continue;
                    }
                    if (manifestEntry.getDigest() == null) continue;
                    result.add(new ManifestEntrySignatureScope(manifestEntry.getName(), manifestEntry.getDigest(), xadesReferenceValidation.getName(), manifestEntry.getTransformationNames()));
                }
                continue;
            }
            if (xadesReferenceValidation.isFound() && "".equals(uri)) {
                byte[] originalContentBytes = xadesReferenceValidation.getOriginalContentBytes();
                if (originalContentBytes == null) continue;
                result.add(new XmlRootSignatureScope(transformations, this.getDigest(originalContentBytes)));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DomUtils.isElementReference(uri)) {
                NodeList nodeList = DomUtils.getNodeList(xadesSignature.getSignatureElement().getOwnerDocument().getDocumentElement(), "//*" + DomUtils.getXPathByIdAttribute(uri));
                if (nodeList == null || nodeList.getLength() != 1) continue;
                Node signedElement = nodeList.item(0);
                if (this.isEverythingCovered(xadesSignature, xmlIdOfSignedElement)) {
                    result.add(new XmlRootSignatureScope(transformations, this.getDigest(DSSXMLUtils.getNodeBytes(signedElement))));
                    continue;
                }
                result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations, this.getDigest(DSSXMLUtils.getNodeBytes(signedElement))));
                continue;
            }
            if (xadesReferenceValidation.isIntact() && Utils.isCollectionNotEmpty(xadesSignature.getDetachedContents())) {
                result.addAll(this.getFromDetachedContent(xadesSignature, transformations, uri));
                continue;
            }
            if (!Utils.isCollectionEmpty(transformations)) continue;
            result.add(new FullSignatureScope(uri, xadesReferenceValidation.getDigest()));
        }
        return result;
    }

    private List<SignatureScope> getFromDetachedContent(XAdESSignature xadesSignature, List<String> transformations, String uri) {
        ArrayList<SignatureScope> detachedSignatureScopes = new ArrayList<SignatureScope>();
        List<DSSDocument> detachedContents = xadesSignature.getDetachedContents();
        if (Utils.isCollectionNotEmpty(detachedContents)) {
            for (DSSDocument detachedDocument : detachedContents) {
                String fileName;
                String decodedUrl;
                String string = decodedUrl = uri != null ? DSSUtils.decodeUrl(uri) : uri;
                if (detachedDocument.getName() != null && (uri != null || detachedContents.size() != 1) && (uri == null || !uri.equals(detachedDocument.getName()) && !decodedUrl.equals(detachedDocument.getName()))) continue;
                String string2 = fileName = detachedDocument.getName() != null ? detachedDocument.getName() : decodedUrl;
                if (detachedDocument instanceof DigestDocument) {
                    DigestDocument digestDocument = (DigestDocument)detachedDocument;
                    detachedSignatureScopes.add(new DigestSignatureScope(fileName, digestDocument.getExistingDigest()));
                    continue;
                }
                if (Utils.isCollectionNotEmpty(transformations)) {
                    detachedSignatureScopes.add(new XmlFullSignatureScope(fileName, transformations, DSSUtils.getDigest(this.getDefaultDigestAlgorithm(), detachedDocument)));
                    continue;
                }
                if (this.isASiCSArchive(xadesSignature, detachedDocument)) {
                    detachedSignatureScopes.add(new ContainerSignatureScope(decodedUrl, DSSUtils.getDigest(this.getDefaultDigestAlgorithm(), detachedDocument)));
                    for (DSSDocument archivedDocument : xadesSignature.getContainerContents()) {
                        detachedSignatureScopes.add(new ContainerContentSignatureScope(DSSUtils.decodeUrl(archivedDocument.getName()), DSSUtils.getDigest(this.getDefaultDigestAlgorithm(), archivedDocument)));
                    }
                    continue;
                }
                detachedSignatureScopes.add(new FullSignatureScope(fileName, DSSUtils.getDigest(this.getDefaultDigestAlgorithm(), detachedDocument)));
            }
        }
        return detachedSignatureScopes;
    }

    public boolean isEverythingCovered(XAdESSignature signature, String coveredObjectId) {
        Element parent = signature.getSignatureElement().getOwnerDocument().getDocumentElement();
        return parent != null && this.isRelatedToUri(parent, coveredObjectId);
    }

    private boolean isRelatedToUri(Node currentNode, String id) {
        String idValue = DSSXMLUtils.getIDIdentifier(currentNode);
        if (idValue == null) {
            return Utils.isStringBlank(id);
        }
        return id.equals(idValue) || id.equals("");
    }
}

