/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.validationreport.parsers;

import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.UriBasedEnum;
import eu.europa.esig.validationreport.enums.ConstraintStatus;
import eu.europa.esig.validationreport.enums.ObjectType;
import eu.europa.esig.validationreport.enums.SignatureValidationProcessID;
import eu.europa.esig.validationreport.enums.TypeOfProof;
import java.util.HashMap;
import java.util.Map;

public final class UriBasedEnumParser {
    private static final Map<String, UriBasedEnum> URI_TO_ENUM_MAP = new HashMap<String, UriBasedEnum>();

    private static void register(UriBasedEnum[] values) {
        for (UriBasedEnum uriBasedEnum : values) {
            URI_TO_ENUM_MAP.put(uriBasedEnum.getUri(), uriBasedEnum);
        }
    }

    private UriBasedEnumParser() {
    }

    public static Indication parseMainIndication(String v) {
        return (Indication)UriBasedEnumParser.parse(v);
    }

    public static ObjectType parseObjectType(String v) {
        return (ObjectType)UriBasedEnumParser.parse(v);
    }

    public static RevocationReason parseRevocationReason(String v) {
        return (RevocationReason)UriBasedEnumParser.parse(v);
    }

    public static SignatureValidationProcessID parseSignatureValidationProcessID(String v) {
        return (SignatureValidationProcessID)UriBasedEnumParser.parse(v);
    }

    public static SubIndication parseSubIndication(String v) {
        return (SubIndication)UriBasedEnumParser.parse(v);
    }

    public static TypeOfProof parseTypeOfProof(String v) {
        return (TypeOfProof)UriBasedEnumParser.parse(v);
    }

    public static ConstraintStatus parseConstraintStatus(String v) {
        return (ConstraintStatus)UriBasedEnumParser.parse(v);
    }

    private static UriBasedEnum parse(String v) {
        if (v != null) {
            return URI_TO_ENUM_MAP.get(v);
        }
        return null;
    }

    public static String print(UriBasedEnum v) {
        if (v != null) {
            return v.getUri();
        }
        return null;
    }

    static {
        UriBasedEnumParser.register(Indication.values());
        UriBasedEnumParser.register(ObjectType.values());
        UriBasedEnumParser.register(RevocationReason.values());
        UriBasedEnumParser.register(SignatureValidationProcessID.values());
        UriBasedEnumParser.register(SubIndication.values());
        UriBasedEnumParser.register(TypeOfProof.values());
        UriBasedEnumParser.register(ConstraintStatus.values());
    }
}

